/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker;

import com.mapinfo.mapmarker.CandidateRange;
import com.mapinfo.mapmarker.ICandidateRangeIterator;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.AddressImpl;
import com.mapinfo.mapmarker.user.IResponseCandidate;
import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.util.DoublePoint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class CandidateAddress
extends AddressImpl
implements IResponseCandidate {
    private boolean closeMatchFlag;
    private String formattedStreetAddress;
    private String formattedLocationAddress;
    private long sourceStreetID;
    private DirectPosition location;
    private int locationPrecision;
    private String coordSysString;
    private boolean matchedAddressNumber;
    private boolean matchedStreetName;
    private boolean matchedPreDirectional;
    private boolean matchedPostDirectional;
    private boolean matchedThoroughfareType;
    private boolean matchedStreetNameFields;
    private boolean matchedPostalCode1;
    private boolean matchedPostalCode2;
    private boolean matchedAreaName1;
    private boolean matchedAreaName2;
    private boolean matchedAreaName3;
    private boolean matchedAreaName4;
    private boolean matchedPlaceName;
    private boolean matchedGenericField1;
    private boolean matchedGenericField2;
    private boolean matchedGenericField3;
    private boolean matchedGenericField4;
    private boolean matchedCountry;
    private List candidateRangeList;
    private boolean candidateRangesSorted;
    private int numberOfReturnableRanges;
    private boolean fromUserDictionary;
    private int dictionaryNumber;
    public static String INTERSECTION_OUTPUT_STRING = "INTERSECTION_OUTPUT";

    public CandidateAddress() {
        this.init();
    }

    public CandidateAddress(Address address) {
        super(address);
        this.init();
        if (address != null && address instanceof CandidateAddress) {
            CandidateAddress candidateAddress = (CandidateAddress)address;
            this.closeMatchFlag = candidateAddress.closeMatchFlag;
            this.formattedStreetAddress = candidateAddress.formattedStreetAddress;
            this.formattedLocationAddress = candidateAddress.formattedLocationAddress;
            this.location = new DirectPosition(candidateAddress.location);
            this.locationPrecision = candidateAddress.locationPrecision;
            this.coordSysString = candidateAddress.coordSysString;
            this.matchedAddressNumber = candidateAddress.matchedAddressNumber;
            this.matchedStreetNameFields = candidateAddress.matchedStreetNameFields;
            this.matchedStreetName = candidateAddress.matchedStreetName;
            this.matchedPreDirectional = candidateAddress.matchedPreDirectional;
            this.matchedPostDirectional = candidateAddress.matchedPostDirectional;
            this.matchedThoroughfareType = candidateAddress.matchedThoroughfareType;
            this.matchedPostalCode1 = candidateAddress.matchedPostalCode1;
            this.matchedPostalCode2 = candidateAddress.matchedPostalCode2;
            this.matchedAreaName1 = candidateAddress.matchedAreaName1;
            this.matchedAreaName2 = candidateAddress.matchedAreaName2;
            this.matchedAreaName3 = candidateAddress.matchedAreaName3;
            this.matchedAreaName4 = candidateAddress.matchedAreaName4;
            this.matchedGenericField1 = candidateAddress.matchedGenericField1;
            this.matchedGenericField2 = candidateAddress.matchedGenericField2;
            this.matchedGenericField3 = candidateAddress.matchedGenericField3;
            this.matchedGenericField4 = candidateAddress.matchedGenericField4;
            this.matchedCountry = candidateAddress.matchedCountry;
            this.matchedPlaceName = candidateAddress.matchedPlaceName;
            this.candidateRangeList = new ArrayList(candidateAddress.candidateRangeList);
            this.candidateRangesSorted = candidateAddress.candidateRangesSorted;
            this.numberOfReturnableRanges = candidateAddress.numberOfReturnableRanges;
            this.fromUserDictionary = candidateAddress.fromUserDictionary;
            this.dictionaryNumber = candidateAddress.dictionaryNumber;
        }
    }

    private void init() {
        this.formattedStreetAddress = "";
        this.formattedLocationAddress = "";
        this.location = new DirectPosition();
        this.locationPrecision = 0;
        this.coordSysString = "epsg:4326";
        this.candidateRangeList = new ArrayList();
        this.candidateRangesSorted = true;
        this.dictionaryNumber = 1;
    }

    public boolean isCloseMatch() {
        return this.closeMatchFlag;
    }

    public void setCloseMatch() {
        this.closeMatchFlag = true;
    }

    @Override
    public String getFormattedStreetAddress() {
        return this.formattedStreetAddress;
    }

    public void setFormattedStreetAddress(String formattedStreetAddress) {
        this.formattedStreetAddress = formattedStreetAddress;
    }

    @Override
    public String getFormattedLocationAddress() {
        return this.formattedLocationAddress;
    }

    public void setFormattedLocationAddress(String formattedLocationAddress) {
        this.formattedLocationAddress = formattedLocationAddress;
    }

    public void setSourceStreetID(long id) {
        this.sourceStreetID = id;
    }

    public long getSourceStreetID() {
        return this.sourceStreetID;
    }

    public String getSegmentID() {
        return this.getAdditionalFieldForKey("SEGMENT_ID");
    }

    public void setLocation(DoublePoint p) {
        if (p == null) {
            this.location = null;
            return;
        }
        this.location = new DirectPosition(p.x, p.y);
    }

    public void setLocation(DirectPosition p) {
        this.location = p;
    }

    @Override
    public DoublePoint getLocation() {
        if (this.location == null) {
            return null;
        }
        return new DoublePoint(this.location.getX(), this.location.getY());
    }

    @Override
    public DirectPosition getLocationPoint() {
        return this.location;
    }

    public void setLocationPrecision(int locationPrecision) {
        this.locationPrecision = locationPrecision < 0 || locationPrecision > 18 ? 0 : locationPrecision;
    }

    @Override
    public int getLocationPrecision() {
        return this.locationPrecision;
    }

    public void setCoordSysString(String coordSysString) {
        this.coordSysString = coordSysString;
    }

    @Override
    public String getCoordSysString() {
        return this.coordSysString;
    }

    public void setAddressNumberMatched() {
        this.matchedAddressNumber = true;
    }

    public boolean doesAddressNumberMatch() {
        return this.matchedAddressNumber;
    }

    public void setStreetPrefixAndSuffixMatched() {
        this.matchedStreetNameFields = true;
    }

    public boolean doStreetPrefixAndSuffixMatch() {
        return this.matchedStreetNameFields;
    }

    public void setPostalCode1Matched() {
        this.matchedPostalCode1 = true;
    }

    public boolean doesPostalCode1Match() {
        return this.matchedPostalCode1;
    }

    public void setPostalCode2Matched() {
        this.matchedPostalCode2 = true;
    }

    public boolean doesPostalCode2Match() {
        return this.matchedPostalCode2;
    }

    public void setAreaName1Matched() {
        this.matchedAreaName1 = true;
    }

    public boolean doesAreaName1Match() {
        return this.matchedAreaName1;
    }

    public void setAreaName2Matched() {
        this.matchedAreaName2 = true;
    }

    public boolean doesAreaName2Match() {
        return this.matchedAreaName2;
    }

    public void setAreaName3Matched() {
        this.matchedAreaName3 = true;
    }

    public boolean doesAreaName3Match() {
        return this.matchedAreaName3;
    }

    public void setAreaName4Matched() {
        this.matchedAreaName4 = true;
    }

    public boolean doesAreaName4Match() {
        return this.matchedAreaName4;
    }

    public void setGenericField1Matched() {
        this.matchedGenericField1 = true;
    }

    public boolean doesGenericField1Match() {
        return this.matchedGenericField1;
    }

    public void setGenericField2Matched() {
        this.matchedGenericField2 = true;
    }

    public boolean doesGenericField2Match() {
        return this.matchedGenericField2;
    }

    public void setGenericField3Matched() {
        this.matchedGenericField3 = true;
    }

    public boolean doesGenericField3Match() {
        return this.matchedGenericField3;
    }

    public void setGenericField4Matched() {
        this.matchedGenericField4 = true;
    }

    public boolean doesGenericField4Match() {
        return this.matchedGenericField4;
    }

    public void setCountryMatched() {
        this.matchedCountry = true;
    }

    public boolean doesCountryMatch() {
        return this.matchedCountry;
    }

    public void setPlaceNameMatched() {
        this.matchedPlaceName = true;
    }

    public boolean doesPlaceNameMatch() {
        return this.matchedPlaceName;
    }

    public void addKeyValueToAdditionalFields(String key, String value) {
        if (this.getAdditionalFieldForKey(key) == null) {
            this.getAdditionalFields().put(key, value);
        }
    }

    public void addCandidateRange(CandidateRange range) {
        this.candidateRangesSorted = false;
        this.candidateRangeList.add(range);
    }

    public void setNumberOfReturnableRanges(int size) {
        this.numberOfReturnableRanges = size;
    }

    @Override
    public int getNumberOfCandidateRangesFound() {
        return this.candidateRangeList.size();
    }

    @Override
    public int getNumberOfCandidateRanges() {
        int candidateRangeListSize = this.candidateRangeList.size();
        if (this.numberOfReturnableRanges < 0 || this.numberOfReturnableRanges > candidateRangeListSize) {
            return candidateRangeListSize;
        }
        return this.numberOfReturnableRanges;
    }

    private void sortCandidateRanges() {
        if (this.candidateRangeList.isEmpty()) {
            this.candidateRangesSorted = true;
            return;
        }
        Collections.sort(this.candidateRangeList);
        this.candidateRangesSorted = true;
    }

    @Override
    public String toString() {
        String lineSeparator = System.getProperty("line.separator");
        StringBuffer returnString = new StringBuffer(super.toString());
        returnString.append(lineSeparator);
        returnString.append("formattedStreetAddress: ");
        returnString.append(this.getFormattedStreetAddress());
        returnString.append(lineSeparator);
        returnString.append("formattedLocationAddress: ");
        returnString.append(this.getFormattedLocationAddress());
        returnString.append(lineSeparator);
        returnString.append("closeMatch: ");
        returnString.append(this.isCloseMatch());
        returnString.append(lineSeparator);
        returnString.append("sourceStreetID: ");
        returnString.append(this.getSourceStreetID());
        returnString.append(lineSeparator);
        returnString.append("addressNumberMatched: ");
        returnString.append(this.doesAddressNumberMatch());
        returnString.append(lineSeparator);
        returnString.append("streetPrefixAndSuffixMatched: ");
        returnString.append(this.doStreetPrefixAndSuffixMatch());
        returnString.append(lineSeparator);
        returnString.append("streetNameMatched: ");
        returnString.append(this.doesStreetNameMatch());
        returnString.append(lineSeparator);
        returnString.append("thoroughfareTypeMatched: ");
        returnString.append(this.doesThoroughfareTypeMatch());
        returnString.append(lineSeparator);
        returnString.append("preDirectionalMatched: ");
        returnString.append(this.doesPreDirectionalMatch());
        returnString.append(lineSeparator);
        returnString.append("postDirectionalMatched: ");
        returnString.append(this.doesPostDirectionalMatch());
        returnString.append(lineSeparator);
        if (this.getPlaceName() != null) {
            returnString.append("placeNameMatched: ");
            returnString.append(this.doesPlaceNameMatch());
            returnString.append(lineSeparator);
        }
        returnString.append("postalCode1Matched: ");
        returnString.append(this.doesPostalCode1Match());
        returnString.append(lineSeparator);
        returnString.append("postalCode2Matched: ");
        returnString.append(this.doesPostalCode2Match());
        returnString.append(lineSeparator);
        if (this.getAreaName1() != null) {
            returnString.append("areaName1Matched: ");
            returnString.append(this.doesAreaName1Match());
            returnString.append(lineSeparator);
        }
        if (this.getAreaName2() != null) {
            returnString.append("areaName2Matched: ");
            returnString.append(this.doesAreaName2Match());
            returnString.append(lineSeparator);
        }
        if (this.getAreaName3() != null) {
            returnString.append("areaName3Matched: ");
            returnString.append(this.doesAreaName3Match());
            returnString.append(lineSeparator);
        }
        if (this.getAreaName4() != null) {
            returnString.append("areaName4Matched: ");
            returnString.append(this.doesAreaName4Match());
            returnString.append(lineSeparator);
        }
        if (this.getGenericField1() != null) {
            returnString.append("genericField1Matched: ");
            returnString.append(this.doesGenericField1Match());
            returnString.append(lineSeparator);
        }
        if (this.getGenericField2() != null) {
            returnString.append("genericField2Matched: ");
            returnString.append(this.doesGenericField2Match());
            returnString.append(lineSeparator);
        }
        if (this.getGenericField3() != null) {
            returnString.append("genericField3Matched: ");
            returnString.append(this.doesGenericField3Match());
            returnString.append(lineSeparator);
        }
        if (this.getGenericField4() != null) {
            returnString.append("genericField4Matched: ");
            returnString.append(this.doesGenericField4Match());
            returnString.append(lineSeparator);
        }
        returnString.append("countryMatched: ");
        returnString.append(this.doesCountryMatch());
        returnString.append(lineSeparator);
        returnString.append("fromUserDictionary: ");
        returnString.append(this.fromUserDictionary());
        returnString.append(lineSeparator);
        returnString.append("configuredDictionaryNumber: ");
        returnString.append(this.getConfiguredDictionaryNumber());
        returnString.append(lineSeparator);
        returnString.append("location: ");
        returnString.append(this.getLocationPoint().toString());
        returnString.append(lineSeparator);
        returnString.append("locationPrecision: ");
        returnString.append(this.getLocationPrecision());
        returnString.append(lineSeparator);
        returnString.append("coordSysString: ");
        returnString.append(this.getCoordSysString());
        returnString.append(lineSeparator);
        returnString.append(lineSeparator);
        returnString.append("This candidate has ");
        returnString.append(this.getNumberOfCandidateRanges());
        returnString.append(" CandidateRange(s).");
        returnString.append(lineSeparator);
        return returnString.toString();
    }

    public String getPrecisionCode() {
        return (String)this.getAdditionalFields().get("RESULT_CODE");
    }

    public CandidateRange getRangeAt(int index) {
        CandidateRange range = null;
        if (!this.candidateRangesSorted) {
            this.sortCandidateRanges();
        }
        if (this.candidateRangeList != null && index >= 0 && index < this.candidateRangeList.size()) {
            range = (CandidateRange)this.candidateRangeList.get(index);
        }
        return range;
    }

    public boolean doesStreetNameMatch() {
        return this.matchedStreetName;
    }

    public void setStreetNameMatched() {
        this.matchedStreetName = true;
    }

    public boolean doesPreDirectionalMatch() {
        return this.matchedPreDirectional;
    }

    public void setPreDirectionalMatched() {
        this.matchedPreDirectional = true;
    }

    public void setPreDirectionalMatched(boolean bMatched) {
        this.matchedPreDirectional = bMatched;
    }

    public boolean doesPostDirectionalMatch() {
        return this.matchedPostDirectional;
    }

    public void setPostDirectionalMatched() {
        this.matchedPostDirectional = true;
    }

    public void setPostDirectionalMatched(boolean bMatched) {
        this.matchedPostDirectional = bMatched;
    }

    public boolean doesThoroughfareTypeMatch() {
        return this.matchedThoroughfareType;
    }

    public void setThoroughfareTypeMatched() {
        this.matchedThoroughfareType = true;
    }

    public void setFromUserDictionary() {
        this.fromUserDictionary = true;
    }

    @Override
    public boolean fromUserDictionary() {
        return this.fromUserDictionary;
    }

    public void overrideThoroughfareTypeMatched(boolean bMatched) {
        this.matchedThoroughfareType = bMatched;
    }

    public void overridePreDirectionalMatched(boolean bMatched) {
        this.matchedPreDirectional = bMatched;
    }

    public void overridePostDirectionalMatched(boolean bMatched) {
        this.matchedPostDirectional = bMatched;
    }

    @Override
    public ICandidateRangeIterator rangeIterator() {
        if (!this.candidateRangesSorted) {
            this.sortCandidateRanges();
        }
        return new CandidateRangeIterator(this.candidateRangeList.iterator());
    }

    public void setConfiguredDictionaryNumber(int number) {
        if (number < 1) {
            return;
        }
        this.dictionaryNumber = number;
    }

    @Override
    public int getConfiguredDictionaryNumber() {
        return this.dictionaryNumber;
    }

    private static class CandidateRangeIterator
    implements ICandidateRangeIterator {
        private final Iterator m_i;

        private CandidateRangeIterator(Iterator i) {
            this.m_i = i;
        }

        @Override
        public boolean hasNext() {
            return this.m_i.hasNext();
        }

        @Override
        public CandidateRange next() {
            return (CandidateRange)this.m_i.next();
        }
    }
}

