/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker;

import com.mapinfo.mapmarker.CandidateRangeUnit;
import com.mapinfo.mapmarker.ICandidateRangeUnitIterator;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.AddressImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CandidateRange
implements Comparable {
    private String lowAddress;
    private String highAddress;
    private long offset;
    private long numberOfAddresses;
    private int leftRightIndicator;
    private int oddEvenIndicator;
    private String m_placeName;
    private String postalCode1;
    private String postalCode2;
    private String areaName1;
    private String areaName2;
    private String areaName3;
    private String areaName4;
    private Map additionalFields;
    private final List m_rangeUnits;
    private boolean m_rangeUnitsSorted;
    private int numberOfReturnableRangeUnits;
    private boolean m_haveAddressFields;
    public static final int STREET_SIDE_UNKNOWN = 0;
    public static final int STREET_SIDE_LEFT = 1;
    public static final int STREET_SIDE_RIGHT = 2;
    public static final int ODD_EVEN_UNKNOWN = -1;
    public static final int ODD_EVEN_BOTH = 0;
    public static final int ODD_EVEN_ODD = 1;
    public static final int ODD_EVEN_EVEN = 2;
    public static final int ODD_EVEN_IRREGULAR = 5;

    public CandidateRange() {
        this.leftRightIndicator = 0;
        this.oddEvenIndicator = -1;
        this.m_rangeUnits = new ArrayList();
        this.m_rangeUnitsSorted = true;
    }

    public CandidateRange(CandidateRange copy) {
        this.lowAddress = copy.lowAddress;
        this.highAddress = copy.highAddress;
        this.offset = copy.offset;
        this.numberOfAddresses = copy.numberOfAddresses;
        this.leftRightIndicator = copy.leftRightIndicator;
        this.oddEvenIndicator = copy.oddEvenIndicator;
        this.m_placeName = copy.m_placeName;
        this.postalCode1 = copy.postalCode1;
        this.postalCode2 = copy.postalCode2;
        this.areaName1 = copy.areaName1;
        this.areaName2 = copy.areaName2;
        this.areaName3 = copy.areaName3;
        this.areaName4 = copy.areaName4;
        if (copy.hasAdditionalFields()) {
            this.additionalFields = new HashMap(copy.additionalFields);
        }
        this.m_rangeUnits = new ArrayList(copy.m_rangeUnits);
        this.m_rangeUnitsSorted = copy.m_rangeUnitsSorted;
        this.numberOfReturnableRangeUnits = copy.numberOfReturnableRangeUnits;
        this.m_haveAddressFields = copy.m_haveAddressFields;
    }

    public String getLowAddress() {
        return this.lowAddress;
    }

    public void setLowAddress(String lowAddress) {
        this.lowAddress = lowAddress;
    }

    public String getHighAddress() {
        return this.highAddress;
    }

    public void setHighAddress(String highAddress) {
        this.highAddress = highAddress;
    }

    public int getLeftRightIndicator() {
        return this.leftRightIndicator;
    }

    public void setLeftRightIndicator(int leftRightIndicator) {
        this.leftRightIndicator = leftRightIndicator >= 0 && leftRightIndicator <= 2 ? leftRightIndicator : 0;
    }

    public int getOddEvenIndicator() {
        return this.oddEvenIndicator;
    }

    public void setOddEvenIndicator(int oddEvenIndicator) {
        this.oddEvenIndicator = oddEvenIndicator >= -1 && oddEvenIndicator <= 2 ? oddEvenIndicator : -1;
    }

    public void setPlaceName(String placeName) {
        this.m_placeName = placeName;
        this.m_haveAddressFields = true;
    }

    public String getPlaceName() {
        return this.m_placeName;
    }

    public String getPostalCode1() {
        return this.postalCode1;
    }

    public void setPostalCode1(String postalCode1) {
        this.postalCode1 = postalCode1;
        this.m_haveAddressFields = true;
    }

    public String getPostalCode2() {
        return this.postalCode2;
    }

    public void setPostalCode2(String postalCode2) {
        this.postalCode2 = postalCode2;
        this.m_haveAddressFields = true;
    }

    public String getAreaName1() {
        return this.areaName1;
    }

    public void setAreaName1(String areaName1) {
        this.areaName1 = areaName1;
        this.m_haveAddressFields = true;
    }

    public String getAreaName2() {
        return this.areaName2;
    }

    public void setAreaName2(String areaName2) {
        this.areaName2 = areaName2;
        this.m_haveAddressFields = true;
    }

    public String getAreaName3() {
        return this.areaName3;
    }

    public void setAreaName3(String areaName3) {
        this.areaName3 = areaName3;
        this.m_haveAddressFields = true;
    }

    public String getAreaName4() {
        return this.areaName4;
    }

    public void setAreaName4(String areaName4) {
        this.areaName4 = areaName4;
        this.m_haveAddressFields = true;
    }

    public Object getAdditionalField(String key) {
        if (this.additionalFields == null) {
            return null;
        }
        return this.additionalFields.get(key);
    }

    public void setAdditionalField(String key, Object value) {
        if (key == null || value == null) {
            return;
        }
        if (this.additionalFields == null) {
            this.additionalFields = new HashMap();
        }
        this.additionalFields.put(key, value);
    }

    public void setAdditionalFields(HashMap adFields) {
        this.additionalFields = adFields;
    }

    public Map getAdditionalFields() {
        if (this.additionalFields == null) {
            this.additionalFields = new HashMap();
        }
        return this.additionalFields;
    }

    public long getOffset() {
        return this.offset;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    public void setNumberOfAddresses(long numberOfAddresses) {
        this.numberOfAddresses = numberOfAddresses;
    }

    public long getNumberOfAddresses() {
        return this.numberOfAddresses;
    }

    public void setNumberOfReturnableRangeUnits(int size) {
        this.numberOfReturnableRangeUnits = size;
    }

    public void addRangeUnit(CandidateRangeUnit unit) {
        this.m_rangeUnits.add(unit);
        this.m_rangeUnitsSorted = false;
    }

    private void sortCandidateRangeUnits() {
        if (this.m_rangeUnits.isEmpty()) {
            this.m_rangeUnitsSorted = true;
            return;
        }
        Collections.sort(this.m_rangeUnits);
        this.m_rangeUnitsSorted = true;
    }

    public int getNumberOfCandidateRangeUnitsFound() {
        return this.m_rangeUnits.size();
    }

    public int getNumberOfRangeUnitsReturned() {
        int rangeUnitsCount = this.m_rangeUnits.size();
        if (this.numberOfReturnableRangeUnits < 0 || this.numberOfReturnableRangeUnits > rangeUnitsCount) {
            return rangeUnitsCount;
        }
        return this.numberOfReturnableRangeUnits;
    }

    public CandidateRangeUnit getRangeUnitAt(int index) {
        if (!this.m_rangeUnitsSorted) {
            this.sortCandidateRangeUnits();
        }
        CandidateRangeUnit unit = null;
        if (this.m_rangeUnits != null && index >= 0 && index < this.m_rangeUnits.size()) {
            unit = (CandidateRangeUnit)this.m_rangeUnits.get(index);
        }
        return unit;
    }

    public ICandidateRangeUnitIterator rangeUnitIterator() {
        if (!this.m_rangeUnitsSorted) {
            this.sortCandidateRangeUnits();
        }
        return new CandidateRangeUnitIterator(this.m_rangeUnits.iterator());
    }

    public int compareTo(Object o) {
        CandidateRange range = (CandidateRange)o;
        if (this.offset == range.offset) {
            if (this.numberOfAddresses == range.numberOfAddresses) {
                return 0;
            }
            if (this.numberOfAddresses < range.numberOfAddresses) {
                return -1;
            }
            return 1;
        }
        if (this.offset < range.offset) {
            return -1;
        }
        return 1;
    }

    public String toString() {
        Set keys;
        String lineSeparator = System.getProperty("line.separator");
        StringBuffer returnString = new StringBuffer();
        String lowAddress = this.getLowAddress();
        String highAddress = this.getHighAddress();
        int lengthDiff = highAddress.length() - lowAddress.length();
        returnString.append("Low Address:\t\t\t");
        for (int i = 0; i < lengthDiff; ++i) {
            returnString.append(' ');
        }
        returnString.append(lowAddress);
        returnString.append(lineSeparator);
        returnString.append("High Address:\t\t\t");
        returnString.append(highAddress);
        returnString.append(lineSeparator);
        switch (this.getOddEvenIndicator()) {
            case 0: {
                returnString.append("Odd/Even/Both:\t\t\tBoth");
                returnString.append(lineSeparator);
                break;
            }
            case 2: {
                returnString.append("Odd/Even/Both:\t\t\tEven");
                returnString.append(lineSeparator);
                break;
            }
            case 1: {
                returnString.append("Odd/Even/Both:\t\t\tOdd");
                returnString.append(lineSeparator);
            }
        }
        if (this.getPlaceName() != null) {
            returnString.append("Place name:\t\t\t");
            returnString.append(this.getPlaceName());
            returnString.append(lineSeparator);
        }
        if (this.getPostalCode1() != null) {
            returnString.append("Postcode1:\t\t\t");
            returnString.append(this.getPostalCode1());
            returnString.append(lineSeparator);
        }
        if (this.getPostalCode2() != null) {
            returnString.append("Postcode2:\t\t\t");
            returnString.append(this.getPostalCode2());
            returnString.append(lineSeparator);
        }
        if (this.getAreaName1() != null) {
            returnString.append("Area Name 1:\t\t\t");
            returnString.append(this.getAreaName1());
            returnString.append(lineSeparator);
        }
        if (this.getAreaName2() != null) {
            returnString.append("Area Name 2:\t\t\t");
            returnString.append(this.getAreaName2());
            returnString.append(lineSeparator);
        }
        if (this.getAreaName3() != null) {
            returnString.append("Area Name 3:\t\t\t");
            returnString.append(this.getAreaName3());
            returnString.append(lineSeparator);
        }
        if (this.getAreaName4() != null) {
            returnString.append("Area Name 4:\t\t\t");
            returnString.append(this.getAreaName4());
            returnString.append(lineSeparator);
        }
        if (this.hasAdditionalFields() && (keys = this.additionalFields.keySet()) != null) {
            for (String key : keys) {
                String value = (String)this.additionalFields.get(key);
                returnString.append(key);
                returnString.append(":\t\t\t");
                returnString.append(value);
                returnString.append(lineSeparator);
            }
        }
        if (this.m_rangeUnits.size() != 0) {
            returnString.append(lineSeparator);
            returnString.append("RangeUnits(" + this.m_rangeUnits.size() + "):");
            returnString.append(lineSeparator);
            ICandidateRangeUnitIterator i = this.rangeUnitIterator();
            int cnt = 0;
            while (i.hasNext()) {
                returnString.append("=============================================");
                returnString.append(lineSeparator);
                returnString.append("RangeUnit # " + cnt);
                returnString.append(lineSeparator);
                returnString.append(i.next().toString());
                returnString.append("=============================================");
                returnString.append(lineSeparator);
                ++cnt;
            }
        }
        return returnString.toString();
    }

    public Address getRangeAddress() {
        if (!this.m_haveAddressFields) {
            return null;
        }
        AddressImpl address = new AddressImpl();
        address.setPlaceName(this.getPlaceName());
        address.setPostCode1(this.getPostalCode1());
        address.setPostCode2(this.getPostalCode2());
        address.setAreaName1(this.getAreaName1());
        address.setAreaName2(this.getAreaName2());
        address.setAreaName3(this.getAreaName3());
        address.setAreaName4(this.getAreaName4());
        return address;
    }

    public void setRangeAddress(Address address) {
        this.m_haveAddressFields = true;
        this.setPlaceName(address.getPlaceName());
        this.setPostalCode1(address.getPostCode1());
        this.setPostalCode2(address.getPostCode2());
        this.setAreaName1(address.getAreaName1());
        this.setAreaName2(address.getAreaName2());
        this.setAreaName3(address.getAreaName3());
        this.setAreaName4(address.getAreaName4());
    }

    public boolean hasAdditionalFields() {
        if (this.additionalFields == null) {
            return false;
        }
        return this.additionalFields.size() != 0;
    }

    private static class CandidateRangeUnitIterator
    implements ICandidateRangeUnitIterator {
        private final Iterator m_i;

        private CandidateRangeUnitIterator(Iterator i) {
            this.m_i = i;
        }

        @Override
        public boolean hasNext() {
            return this.m_i.hasNext();
        }

        @Override
        public CandidateRangeUnit next() {
            return (CandidateRangeUnit)this.m_i.next();
        }
    }
}

