/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker;

import com.mapinfo.mapmarker.IGeocodeConstraints;
import com.mapinfo.midev.coordsys.CoordSys;
import com.mapinfo.midev.coordsys.util.CoordSysUtilities;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class GeocodeConstraints
extends Properties {
    public static final String KEY_CLOSEMATCHESONLY = "closeMatchesOnly";
    public static final String KEY_MUST_MATCH_ADDRNUM = "MustMatchAddrNum";
    public static final String KEY_MUST_MATCH_MAINADDR = "MustMatchMainAddr";
    public static final String KEY_MUST_MATCH_AREA1 = "MustMatchArea1";
    public static final String KEY_MUST_MATCH_AREA2 = "MustMatchArea2";
    public static final String KEY_MUST_MATCH_AREA3 = "MustMatchArea3";
    public static final String KEY_MUST_MATCH_AREA4 = "MustMatchArea4";
    public static final String KEY_MUST_MATCH_POSTAL = "MustMatchPostalCode";
    public static final String KEY_MUST_MATCH_COUNTRY = "MustMatchCountry";
    public static final String KEY_MUST_MATCH_INPUT = "MustMatchInput";
    public static final String KEY_MAXCANDIDATES = "maxCandidatesReturned";
    public static final String KEY_MAXRANGES = "maxRanges";
    public static final String KEY_MAXRANGEUNITS = "maxRangeUnits";
    public static final String KEY_CORNEROFFSET = "OffsetFromCorner";
    public static final String KEY_STREETOFFSET = "OffsetFromStreet";
    public static final String KEY_CORNEROFFSETUNITS = "cornerOffsetUnits";
    public static final String KEY_STREETOFFSETUNITS = "streetOffsetUnits";
    public static final String KEY_CLIENT_LOCALE = "ClientLocale";
    public static final String KEY_CLIENT_CRS = "ClientCRS";
    public static final String KEY_GEOCODEMATCHTYPE = "GeocodeRequestType";
    public static final String KEY_FALLBACK_TO_POSTAL = "fallbackToPostal";
    public static final String KEY_FALLBACK_TO_GEOGRAPHIC = "fallbackToGeographic";
    public static final String VALUE_GEOCODE_MATCH_ADDRESS = "0";
    public static final String VALUE_GEOCODE_MATCH_POSTCODE = "1";
    public static final String VALUE_GEOCODE_MATCH_POI = "2";
    public static final String VALUE_GEOCODE_MATCH_GEOGRAPHIC = "4";
    public static final String VALUE_GEOCODE_MATCH_CITIES = "3";
    public static final String VALUE_GEOCODE_MATCH_STANDARDIZE_ONLY = "5";
    public static final String VALUE_GEOCODE_MATCH_BROWSE = "6";
    public static final String VALUE_GEOCODE_MATCH_UNKNOWN = "-1";
    public static final String VALUE_ALL_POSSIBLE_CANDIDATES = "-1";
    public static final String VALUE_ALL_POSSIBLE_RANGES = "-1";
    public static final String VALUE_ALL_POSSIBLE_RANGEUNITS = "-1";
    public static final String EPSG_WGS84 = "epsg:4326";
    private static final Set m_definedKeys = new HashSet();
    private final Set m_definedSet = new HashSet();
    private final Set m_undefinedSet = new HashSet();

    public IGeocodeConstraints convertToNewConstraints() {
        Set custom;
        boolean bSet;
        com.mapinfo.mapmarker.user.GeocodeConstraints newConstraints = new com.mapinfo.mapmarker.user.GeocodeConstraints();
        String old = this.getProperty(KEY_CLIENT_CRS);
        if (old != null) {
            newConstraints.setClientCoordinateSystem(old);
        }
        if ((old = this.getProperty(KEY_CLIENT_LOCALE)) != null) {
            newConstraints.setClientLocale(old);
        }
        if ((old = this.getProperty(KEY_CLOSEMATCHESONLY)) != null) {
            bSet = old.equalsIgnoreCase("true");
            newConstraints.setReturnCloseCandidatesOnly(bSet);
        }
        if ((old = this.getProperty(KEY_CORNEROFFSET)) != null) {
            try {
                double offset = Double.parseDouble(old);
                newConstraints.setCornerOffset(offset);
            }
            catch (NumberFormatException offset) {
                // empty catch block
            }
        }
        if ((old = this.getProperty(KEY_CORNEROFFSETUNITS)) != null) {
            newConstraints.setCornerOffsetUnits(old);
        }
        if ((old = this.getProperty(KEY_FALLBACK_TO_GEOGRAPHIC)) != null) {
            bSet = old.equalsIgnoreCase("true");
            newConstraints.setFallbackToGeographic(bSet);
        }
        if ((old = this.getProperty(KEY_FALLBACK_TO_POSTAL)) != null) {
            bSet = old.equalsIgnoreCase("true");
            newConstraints.setFallbackToPostal(bSet);
        }
        if ((old = this.getProperty(KEY_GEOCODEMATCHTYPE)) != null) {
            try {
                int type = Integer.parseInt(old);
                newConstraints.setGeocodeType(type);
            }
            catch (NumberFormatException type) {
                // empty catch block
            }
        }
        if ((old = this.getProperty(KEY_MAXCANDIDATES)) != null) {
            try {
                int max = Integer.parseInt(old);
                newConstraints.setMaxCandidates(max);
            }
            catch (NumberFormatException max) {
                // empty catch block
            }
        }
        if ((old = this.getProperty(KEY_MAXRANGES)) != null) {
            try {
                int max = Integer.parseInt(old);
                newConstraints.setMaxRanges(max);
            }
            catch (NumberFormatException max) {
                // empty catch block
            }
        }
        if ((old = this.getProperty(KEY_MAXRANGEUNITS)) != null) {
            try {
                int max = Integer.parseInt(old);
                newConstraints.setMaxRangeUnits(max);
            }
            catch (NumberFormatException max) {
                // empty catch block
            }
        }
        if ((old = this.getProperty(KEY_MUST_MATCH_ADDRNUM)) != null) {
            boolean bSet2 = old.equalsIgnoreCase("true");
            newConstraints.setMustMatchAddressNumber(bSet2);
        }
        if ((old = this.getProperty(KEY_MUST_MATCH_AREA1)) != null) {
            boolean bSet3 = old.equalsIgnoreCase("true");
            newConstraints.setMustMatchArea1(bSet3);
        }
        if ((old = this.getProperty(KEY_MUST_MATCH_AREA2)) != null) {
            boolean bSet4 = old.equalsIgnoreCase("true");
            newConstraints.setMustMatchArea2(bSet4);
        }
        if ((old = this.getProperty(KEY_MUST_MATCH_AREA3)) != null) {
            boolean bSet5 = old.equalsIgnoreCase("true");
            newConstraints.setMustMatchArea3(bSet5);
        }
        if ((old = this.getProperty(KEY_MUST_MATCH_AREA4)) != null) {
            boolean bSet6 = old.equalsIgnoreCase("true");
            newConstraints.setMustMatchArea4(bSet6);
        }
        if ((old = this.getProperty(KEY_MUST_MATCH_COUNTRY)) != null) {
            boolean bSet7 = old.equalsIgnoreCase("true");
            newConstraints.setMustMatchCountry(bSet7);
        }
        if ((old = this.getProperty(KEY_MUST_MATCH_INPUT)) != null) {
            boolean bSet8 = old.equalsIgnoreCase("true");
            newConstraints.setMustMatchInput(bSet8);
        }
        if ((old = this.getProperty(KEY_MUST_MATCH_MAINADDR)) != null) {
            boolean bSet9 = old.equalsIgnoreCase("true");
            newConstraints.setMustMatchMainAddress(bSet9);
        }
        if ((old = this.getProperty(KEY_MUST_MATCH_POSTAL)) != null) {
            boolean bSet10 = old.equalsIgnoreCase("true");
            newConstraints.setMustMatchPostalCode(bSet10);
        }
        if ((old = this.getProperty(KEY_STREETOFFSET)) != null) {
            try {
                double offset = Double.parseDouble(old);
                newConstraints.setStreetOffset(offset);
            }
            catch (NumberFormatException offset) {
                // empty catch block
            }
        }
        if ((old = this.getProperty(KEY_STREETOFFSETUNITS)) != null) {
            newConstraints.setStreetOffsetUnits(old);
        }
        if ((custom = this.undefinedKeySet()) != null) {
            for (String key : custom) {
                old = this.getProperty(key);
                newConstraints.setCustomString(key, old);
            }
        }
        return newConstraints;
    }

    public static GeocodeConstraints convertFromNewConstraints(IGeocodeConstraints newConstraints) {
        Locale locale;
        GeocodeConstraints oldConstraints = new GeocodeConstraints();
        CoordSys csys = newConstraints.getClientCoordinateSystemObject();
        if (csys != null) {
            oldConstraints.setProperty(KEY_CLIENT_CRS, CoordSysUtilities.getSRSName((CoordSys)csys));
        }
        if ((locale = newConstraints.getClientLocale()) != null) {
            oldConstraints.setProperty(KEY_CLIENT_LOCALE, locale.getDisplayName());
        }
        oldConstraints.setProperty(KEY_CORNEROFFSET, String.valueOf(newConstraints.getCornerOffset()));
        oldConstraints.setProperty(KEY_STREETOFFSET, String.valueOf(newConstraints.getStreetOffset()));
        oldConstraints.setProperty(KEY_CORNEROFFSETUNITS, newConstraints.getCornerOffsetUnits());
        oldConstraints.setProperty(KEY_STREETOFFSETUNITS, newConstraints.getStreetOffsetUnits());
        oldConstraints.setProperty(KEY_CLOSEMATCHESONLY, String.valueOf(newConstraints.isReturnCloseCandidatesOnly()));
        oldConstraints.setProperty(KEY_FALLBACK_TO_GEOGRAPHIC, String.valueOf(newConstraints.isFallbackToGeographic()));
        oldConstraints.setProperty(KEY_FALLBACK_TO_POSTAL, String.valueOf(newConstraints.isFallbackToPostal()));
        oldConstraints.setProperty(KEY_GEOCODEMATCHTYPE, String.valueOf(newConstraints.getGeocodeType()));
        oldConstraints.setProperty(KEY_MAXCANDIDATES, String.valueOf(newConstraints.getMaxCandidates()));
        oldConstraints.setProperty(KEY_MAXRANGES, String.valueOf(newConstraints.getMaxRanges()));
        oldConstraints.setProperty(KEY_MAXRANGEUNITS, String.valueOf(newConstraints.getMaxRangeUnits()));
        oldConstraints.setProperty(KEY_MUST_MATCH_ADDRNUM, String.valueOf(newConstraints.isMustMatchAddressNumber()));
        oldConstraints.setProperty(KEY_MUST_MATCH_AREA1, String.valueOf(newConstraints.isMustMatchArea1()));
        oldConstraints.setProperty(KEY_MUST_MATCH_AREA2, String.valueOf(newConstraints.isMustMatchArea2()));
        oldConstraints.setProperty(KEY_MUST_MATCH_AREA3, String.valueOf(newConstraints.isMustMatchArea3()));
        oldConstraints.setProperty(KEY_MUST_MATCH_AREA4, String.valueOf(newConstraints.isMustMatchArea4()));
        oldConstraints.setProperty(KEY_MUST_MATCH_COUNTRY, String.valueOf(newConstraints.isMustMatchCountry()));
        oldConstraints.setProperty(KEY_MUST_MATCH_INPUT, String.valueOf(newConstraints.isMustMatchInput()));
        oldConstraints.setProperty(KEY_MUST_MATCH_MAINADDR, String.valueOf(newConstraints.isMustMatchMainAddress()));
        oldConstraints.setProperty(KEY_MUST_MATCH_POSTAL, String.valueOf(newConstraints.isMustMatchPostalCode()));
        HashMap values = newConstraints.getCustomValues();
        if (values != null && !values.isEmpty()) {
            for (String key : values.keySet()) {
                String value = (String)values.get(key);
                oldConstraints.setProperty(key, value);
            }
        }
        return oldConstraints;
    }

    public GeocodeConstraints() {
        this.setDefaultValues();
    }

    public GeocodeConstraints(GeocodeConstraints defaults) {
        this();
        if (defaults != null) {
            this.putAll((Map<?, ?>)defaults);
            this.m_definedSet.addAll(defaults.m_definedSet);
            this.m_undefinedSet.addAll(defaults.m_undefinedSet);
        }
    }

    protected void setDefaultValues() {
        super.setProperty(KEY_GEOCODEMATCHTYPE, VALUE_GEOCODE_MATCH_ADDRESS);
        super.setProperty(KEY_MUST_MATCH_ADDRNUM, "false");
        super.setProperty(KEY_MUST_MATCH_AREA1, "false");
        super.setProperty(KEY_MUST_MATCH_AREA2, "false");
        super.setProperty(KEY_MUST_MATCH_AREA3, "false");
        super.setProperty(KEY_MUST_MATCH_AREA4, "false");
        super.setProperty(KEY_MUST_MATCH_COUNTRY, "true");
        super.setProperty(KEY_MUST_MATCH_INPUT, "false");
        super.setProperty(KEY_MUST_MATCH_MAINADDR, "false");
        super.setProperty(KEY_MUST_MATCH_POSTAL, "false");
        super.setProperty(KEY_CLOSEMATCHESONLY, "false");
        super.setProperty(KEY_MAXCANDIDATES, VALUE_GEOCODE_MATCH_CITIES);
        super.setProperty(KEY_MAXRANGES, VALUE_GEOCODE_MATCH_ADDRESS);
        super.setProperty(KEY_MAXRANGEUNITS, VALUE_GEOCODE_MATCH_ADDRESS);
        super.setProperty(KEY_CORNEROFFSET, "25");
        super.setProperty(KEY_STREETOFFSET, "25");
        super.setProperty(KEY_CORNEROFFSETUNITS, "ft");
        super.setProperty(KEY_STREETOFFSETUNITS, "ft");
        super.setProperty(KEY_FALLBACK_TO_POSTAL, "false");
        super.setProperty(KEY_FALLBACK_TO_GEOGRAPHIC, "false");
        super.setProperty(KEY_CLIENT_CRS, EPSG_WGS84);
        super.setProperty(KEY_CLIENT_LOCALE, Locale.getDefault().toString());
    }

    @Override
    public Object setProperty(String key, String value) {
        this.set(key);
        return super.setProperty(key, value);
    }

    @Override
    public Object put(Object key, Object value) {
        this.set(key);
        return super.put(key, value);
    }

    private final void set(Object key) {
        if (m_definedKeys.contains(key)) {
            this.m_definedSet.add(key);
        } else {
            this.m_undefinedSet.add(key);
        }
    }

    public Set undefinedKeySet() {
        return this.m_undefinedSet;
    }

    public boolean isSet(String key) {
        return this.m_definedSet.contains(key) || this.m_undefinedSet.contains(key);
    }

    public static final GeocodeConstraints getDefaultConstraints() {
        return new GeocodeConstraints();
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer(512);
        String lineSeparator = System.getProperty("line.separator");
        for (String string : this.keySet()) {
            String val = this.getProperty(string);
            sb.append(string);
            sb.append("=");
            sb.append(val);
            sb.append(lineSeparator);
        }
        return sb.toString();
    }

    public final void overrideValues(Properties p) {
        if (p != null) {
            for (Object key : p.keySet()) {
                Object obj = p.get(key);
                if (obj == null) continue;
                this.put(key, obj);
            }
        }
    }

    private static final void initDefinedKeys() {
        m_definedKeys.add(KEY_CLIENT_CRS);
        m_definedKeys.add(KEY_CLIENT_LOCALE);
        m_definedKeys.add(KEY_CLOSEMATCHESONLY);
        m_definedKeys.add(KEY_CORNEROFFSET);
        m_definedKeys.add(KEY_CORNEROFFSETUNITS);
        m_definedKeys.add(KEY_FALLBACK_TO_GEOGRAPHIC);
        m_definedKeys.add(KEY_FALLBACK_TO_POSTAL);
        m_definedKeys.add(KEY_GEOCODEMATCHTYPE);
        m_definedKeys.add(KEY_MAXCANDIDATES);
        m_definedKeys.add(KEY_MAXRANGES);
        m_definedKeys.add(KEY_MAXRANGEUNITS);
        m_definedKeys.add(KEY_STREETOFFSET);
        m_definedKeys.add(KEY_STREETOFFSETUNITS);
    }

    static {
        GeocodeConstraints.initDefinedKeys();
    }
}

