/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;

public abstract class MapMarkerInternalBaseException
extends Exception {
    private int m_errorCode;
    private Object[] m_msgArguments;

    public MapMarkerInternalBaseException(int errorCode) {
        this.m_errorCode = errorCode;
    }

    public MapMarkerInternalBaseException(int errorCode, Object[] msgArguments) {
        this.m_errorCode = errorCode;
        this.m_msgArguments = msgArguments;
    }

    public MapMarkerInternalBaseException(int errorCode, Throwable cause) {
        super(cause);
        this.m_errorCode = errorCode;
    }

    public MapMarkerInternalBaseException(int errorCode, Object[] msgArguments, Throwable cause) {
        super(cause);
        this.m_errorCode = errorCode;
        this.m_msgArguments = msgArguments;
    }

    @Override
    public String getLocalizedMessage() {
        return this.getLocalizedMessage(Locale.getDefault());
    }

    public String getLocalizedMessage(Locale locale) {
        ResourceBundle bundle = ResourceBundle.getBundle(this.getMessageBundleBase(), locale);
        String msg = bundle.getString(String.valueOf(this.m_errorCode));
        return MessageFormat.format(msg, this.m_msgArguments);
    }

    @Override
    public String getMessage() {
        return this.getLocalizedMessage();
    }

    public int getErrorCode() {
        return this.m_errorCode;
    }

    public abstract String getMessageModule();

    public abstract String getMessageBundleBase();
}

