/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.adapter;

import com.mapinfo.mapmarker.Constraints;
import com.mapinfo.mapmarker.GeocodableAddressFactory;
import com.mapinfo.mapmarker.GeocodeResult;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.IGeocodeConstraints;
import com.mapinfo.mapmarker.MMInternalFatalException;
import com.mapinfo.mapmarker.MapMarkerInternalException;
import com.mapinfo.mapmarker.adapter.AbstractEngineAdapter;
import com.mapinfo.mapmarker.adapter.MMEngineException;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.IDictionarySearchOrder;
import com.mapinfo.mapmarker.core.reverseGeocode.MMGeneralReverseGeocodeException;
import com.mapinfo.mapmarker.core.reverseGeocode.MMGeneralReverseGeocodeFatalException;
import com.mapinfo.mapmarker.core.reverseGeocode.MMJReverseGeocoder;
import com.mapinfo.mapmarker.core.reverseGeocode.ReverseGeocodeInternalConstraints;
import com.mapinfo.mapmarker.user.IReverseGeocodeConstraints;
import com.mapinfo.mapmarker.user.MMJGeocoderInstance;
import com.mapinfo.mapmarker.user.ReverseGeocodeLocation;
import com.mapinfo.mapmarker.user.ReverseGeocodeResponse;
import java.util.List;
import java.util.ResourceBundle;

public final class MMJEngineAdapter
extends AbstractEngineAdapter {
    private static final String ENGINE_DESCRIPTION = "MapMarker - Java based Geocoding Engine";
    private static final ResourceBundle m_rb = ResourceBundle.getBundle("com.mapinfo.mapmarker.adapter.AdapterStrings");
    private static final String INPUT_ADDRESS_NULL = "exception.null.input.address";

    @Override
    public void init() {
    }

    @Override
    public List geocode(int geocodeType, Address inputAddress, IGeocodeConstraints constraint, GeocodeResult result) throws MapMarkerInternalException, MMInternalFatalException {
        if (inputAddress == null) {
            throw new IllegalArgumentException(m_rb.getString(INPUT_ADDRESS_NULL));
        }
        MMJGeocoderInstance geocoder = new MMJGeocoderInstance();
        IConstraints internalSettings = Constraints.convertFromConstraints(constraint, null);
        GeocodeResult gResult = geocoder.geocode(geocodeType, inputAddress, internalSettings);
        if (gResult == null) {
            throw new MMEngineException(2302);
        }
        List uCands = null;
        if (geocodeType < 100) {
            switch (geocodeType) {
                case 0: 
                case 1: 
                case 4: {
                    uCands = geocoder.filterReturnCandidates();
                    break;
                }
                case 5: 
                case 6: {
                    uCands = geocoder.createCandidateList(gResult.getNumberCandidates());
                    break;
                }
            }
        } else {
            uCands = geocoder.createCandidateList(gResult.getNumberCandidates());
        }
        result.copy(gResult);
        return uCands;
    }

    @Override
    public String getAdapterDescription() {
        return ENGINE_DESCRIPTION;
    }

    @Override
    public String[] getLicenseInformation() {
        return GeocodableAddressFactory.getAllLicenseInformation();
    }

    @Override
    public IDictionarySearchOrder getDictionaryInformation(Address addr, IGeocodeConstraints constraints) throws MapMarkerInternalException, MMInternalFatalException {
        MMJGeocoderInstance geocoder = new MMJGeocoderInstance();
        IConstraints internalSettings = Constraints.convertFromConstraints(constraints, null);
        return geocoder.getDictionaryInformation(addr, internalSettings);
    }

    @Override
    public ReverseGeocodeResponse reverseGeocode(int type, String country, ReverseGeocodeLocation location, IReverseGeocodeConstraints constraints) throws MapMarkerInternalException, MMInternalFatalException {
        MMJReverseGeocoder reverseGeocoder = new MMJReverseGeocoder(country);
        try {
            return reverseGeocoder.reverseGeocode(type, location, new ReverseGeocodeInternalConstraints(constraints));
        }
        catch (RuntimeException REx) {
            throw new MMGeneralReverseGeocodeException(2308, (Throwable)REx);
        }
        catch (Throwable t) {
            throw new MMGeneralReverseGeocodeFatalException(2308, t);
        }
    }
}

