/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common;

import com.mapinfo.mapmarker.utils.MMJLog;
import java.text.CollationElementIterator;
import java.text.Collator;
import java.text.ParseException;
import java.text.RuleBasedCollator;
import java.util.Locale;

public class CollationKeyGenerator {
    protected RuleBasedCollator m_collator = null;

    public CollationKeyGenerator(Locale loc) {
        this.m_collator = (RuleBasedCollator)RuleBasedCollator.getInstance(loc);
        this.m_collator.setDecomposition(1);
        this.m_collator.setStrength(0);
    }

    public CollationKeyGenerator(Locale loc, String extraRules) {
        this(loc);
        if (extraRules != null && extraRules.trim().length() != 0) {
            Collator collator = null;
            try {
                collator = new RuleBasedCollator(this.m_collator.getRules() + extraRules);
            }
            catch (ParseException PEx) {
                MMJLog.getLog().error("Unable to create extraRules collator", (Throwable)PEx);
            }
            if (collator != null) {
                collator.setDecomposition(2);
                collator.setStrength(0);
                this.m_collator = collator;
            }
        }
    }

    public CollationKeyGenerator(Collator collator) {
        this.m_collator = (RuleBasedCollator)collator;
    }

    public CollationKeyGenerator(Locale loc, String extraRules, int decompositionMode) {
        this(loc, extraRules);
        this.m_collator.setDecomposition(decompositionMode);
    }

    public int[] getCollationKey(String str) {
        int[] keys = new int[150];
        CollationElementIterator iterator = this.m_collator.getCollationElementIterator(str);
        int i = 0;
        int t = 0;
        while ((t = iterator.next()) != -1) {
            keys[i++] = t;
        }
        int[] array = new int[i];
        System.arraycopy(keys, 0, array, 0, i);
        return array;
    }
}

