/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common;

import java.text.CollationElementIterator;
import java.text.RuleBasedCollator;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

class CollatorKeyCache {
    private static final int MAX_CACHE_SIZE = 300;
    private final int[] DUMMY_INT_ARRAY = new int[150];
    private final CollationKeyCacheItem[] m_cache;
    private final Set m_cacheSet = new HashSet(300);
    private int m_size = 0;
    private final RuleBasedCollator m_collator;

    protected CollatorKeyCache(RuleBasedCollator collator) {
        this.m_collator = collator;
        this.m_cache = new CollationKeyCacheItem[300];
        Arrays.fill(this.m_cache, null);
    }

    protected final synchronized int[] getCollationKeyArray(String token) {
        int t;
        int[] keys = this.searchCacheForString(token);
        if (keys.length != 0) {
            return keys;
        }
        CollationElementIterator iterator = this.m_collator.getCollationElementIterator(token);
        int i = 0;
        while (i < this.DUMMY_INT_ARRAY.length && (t = iterator.next()) != -1) {
            this.DUMMY_INT_ARRAY[i++] = t;
        }
        int[] result = new int[i];
        System.arraycopy(this.DUMMY_INT_ARRAY, 0, result, 0, i);
        this.insertInCache(token, result);
        return result;
    }

    private int[] searchCacheForString(String str) {
        if (this.m_cacheSet.contains(str)) {
            int hash = str.hashCode();
            for (int i = 0; i < this.m_size; ++i) {
                String temp;
                if (this.m_cache[i].getHashCode() != hash || (temp = this.m_cache[i].getStr()) == null || !str.equals(temp)) continue;
                if (i != 0) {
                    return this.promoteItem(i).getKeys();
                }
                return this.m_cache[i].getKeys();
            }
        }
        return new int[0];
    }

    private void insertInCache(String str, int[] keys) {
        CollationKeyCacheItem item = new CollationKeyCacheItem(str, keys);
        if (this.m_size == 300) {
            this.m_cacheSet.remove(this.m_cache[299].getStr());
            System.arraycopy(this.m_cache, 0, this.m_cache, 1, this.m_size - 1);
        } else {
            System.arraycopy(this.m_cache, 0, this.m_cache, 1, this.m_size);
            ++this.m_size;
        }
        this.m_cacheSet.add(str);
        this.m_cache[0] = item;
    }

    private final CollationKeyCacheItem promoteItem(int cacheIndex) {
        CollationKeyCacheItem tempItem = this.m_cache[cacheIndex];
        System.arraycopy(this.m_cache, 0, this.m_cache, 1, cacheIndex);
        this.m_cache[0] = tempItem;
        return tempItem;
    }

    private static class CollationKeyCacheItem {
        private final String m_str;
        private final int[] m_keys;
        private final int m_hashCode;

        private CollationKeyCacheItem(String str, int[] keys) {
            this.m_str = str;
            this.m_hashCode = str.hashCode();
            this.m_keys = keys;
        }

        private final int[] getKeys() {
            return this.m_keys;
        }

        private final String getStr() {
            return this.m_str;
        }

        private final int getHashCode() {
            return this.m_hashCode;
        }
    }
}

