/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common;

import com.mapinfo.mapmarker.common.IDictionarySearchOrder;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class DictionarySearchOrder
implements IDictionarySearchOrder {
    private static final String DESCRIPTION_PROPFILE_NAME = "dictionarydesc.properties";
    private static final String DESCRIPTION_PROP_DESCRIPTION = "description";
    private static final String DESCRIPTION_TEXT_AD_PREFIX = "Address dictionary: ";
    private static final String DESCRIPTION_TEXT_UD_PREFIX = "User dictionary: ";
    private static final String DESCRIPTION_TEXT_NO_DESCRIPTION = "no description";
    private int m_dictionaryCount;
    private List m_dictionaries;

    public DictionarySearchOrder(int count) {
        this.m_dictionaryCount = count;
        this.m_dictionaries = new ArrayList(count);
    }

    public DictionarySearchOrder(IDictionarySearchOrder searchOrder) {
        if (searchOrder == null) {
            throw new IllegalArgumentException("searchOrder can not be null.");
        }
        this.m_dictionaryCount = searchOrder.getDictionaryCount();
        this.m_dictionaries = new ArrayList(this.m_dictionaryCount);
        for (int index = 0; index < this.m_dictionaryCount; ++index) {
            int cfgIdx = index + 1;
            this.addDictionary(cfgIdx, searchOrder.isDictionaryAvailableForSearch(cfgIdx), searchOrder.getDictionaryDescription(cfgIdx), searchOrder.getSearchOrderForDictionary(cfgIdx), searchOrder.isUserDictionary(cfgIdx));
        }
    }

    @Override
    public int getDictionaryCount() {
        return this.m_dictionaryCount;
    }

    public boolean loadDictionaryFromPath(int idx, String path, boolean bUserDict) {
        if (idx < 1 || idx > this.m_dictionaryCount) {
            return false;
        }
        this.m_dictionaries.add(--idx, new SearchDictionary(idx, this.lookupDictionaryDescription(path, bUserDict), idx, true, bUserDict));
        return true;
    }

    public boolean addDictionary(int cfgIdx, boolean bSearchable, String desc, int userPriority, boolean bUserDict) {
        if (cfgIdx < 1 || cfgIdx > this.m_dictionaryCount || userPriority < 1 || userPriority > this.m_dictionaryCount) {
            return false;
        }
        this.m_dictionaries.add(--cfgIdx, new SearchDictionary(cfgIdx, desc, --userPriority, bSearchable, bUserDict));
        return true;
    }

    @Override
    public boolean isDictionaryAvailableForSearch(int idx) {
        return this.adjusted_isDictionaryAvailableForSearch(this.adjustUserIndex(idx));
    }

    private boolean adjusted_isDictionaryAvailableForSearch(int trueIdx) {
        if (trueIdx < 0 || trueIdx >= this.m_dictionaryCount || trueIdx >= this.m_dictionaries.size()) {
            return false;
        }
        SearchDictionary dict = (SearchDictionary)this.m_dictionaries.get(trueIdx);
        if (dict == null) {
            return false;
        }
        return dict.bSearchable;
    }

    @Override
    public boolean isUserDictionary(int idx) {
        return this.adjusted_isUserDictionary(this.adjustUserIndex(idx));
    }

    private boolean adjusted_isUserDictionary(int trueIdx) {
        if (trueIdx < 0 || trueIdx >= this.m_dictionaryCount || trueIdx >= this.m_dictionaries.size()) {
            return false;
        }
        SearchDictionary dict = (SearchDictionary)this.m_dictionaries.get(trueIdx);
        if (dict == null) {
            return false;
        }
        return dict.bUserDict;
    }

    @Override
    public void setDictionaryAvailableForSearch(int idx, boolean bAvailable) {
        this.adjusted_setDictionaryAvailableForSearch(this.adjustUserIndex(idx), bAvailable);
    }

    private void adjusted_setDictionaryAvailableForSearch(int trueIdx, boolean bAvailable) {
        if (trueIdx < 0 || trueIdx >= this.m_dictionaryCount || trueIdx >= this.m_dictionaries.size()) {
            return;
        }
        SearchDictionary dict = (SearchDictionary)this.m_dictionaries.get(trueIdx);
        if (dict == null) {
            return;
        }
        dict.bSearchable = bAvailable;
    }

    @Override
    public int getSearchOrderForDictionary(int idx) {
        int trueIdx = this.adjusted_getUserSearchOrderForDictionary(this.adjustUserIndex(idx));
        return this.adjustTrueIndex(trueIdx);
    }

    private int adjusted_getUserSearchOrderForDictionary(int trueIdx) {
        if (trueIdx < 0 || trueIdx >= this.m_dictionaryCount || trueIdx >= this.m_dictionaries.size()) {
            return -2;
        }
        SearchDictionary dict = (SearchDictionary)this.m_dictionaries.get(trueIdx);
        if (dict == null) {
            return -2;
        }
        return dict.userPriority;
    }

    @Override
    public void setSearchOrderForDictionary(int idx, int newSearchOrder) {
        this.adjusted_setUserSearchOrderForDictionary(this.adjustUserIndex(idx), this.adjustUserIndex(newSearchOrder));
    }

    private void adjusted_setUserSearchOrderForDictionary(int trueIdx, int trueNewSearchOrder) {
        SearchDictionary tmpDict;
        int i;
        if (trueIdx < 0 || trueIdx >= this.m_dictionaryCount || trueIdx >= this.m_dictionaries.size() || trueNewSearchOrder < 0 || trueNewSearchOrder >= this.m_dictionaryCount) {
            return;
        }
        SearchDictionary dict = (SearchDictionary)this.m_dictionaries.get(trueIdx);
        if (dict == null) {
            return;
        }
        int count = this.getDictionaryCount();
        int currentPriority = dict.userPriority;
        for (i = 0; i < count; ++i) {
            if (i == trueIdx) continue;
            tmpDict = (SearchDictionary)this.m_dictionaries.get(i);
            if (tmpDict.userPriority <= currentPriority) continue;
            --tmpDict.userPriority;
        }
        for (i = 0; i < count; ++i) {
            if (i == trueIdx) continue;
            tmpDict = (SearchDictionary)this.m_dictionaries.get(i);
            if (tmpDict.userPriority < trueNewSearchOrder) continue;
            ++tmpDict.userPriority;
        }
        dict.userPriority = trueNewSearchOrder;
    }

    @Override
    public String getDictionaryDescription(int idx) {
        return this.adjusted_getDictionaryDescription(this.adjustUserIndex(idx));
    }

    private String adjusted_getDictionaryDescription(int trueIdx) {
        if (trueIdx < 0 || trueIdx >= this.m_dictionaryCount || trueIdx >= this.m_dictionaries.size()) {
            return null;
        }
        SearchDictionary dict = (SearchDictionary)this.m_dictionaries.get(trueIdx);
        if (dict == null) {
            return null;
        }
        return dict.description;
    }

    private String lookupDictionaryDescription(String path, boolean bUserDict) {
        StringBuffer buf = new StringBuffer();
        if (bUserDict) {
            buf.append(DESCRIPTION_TEXT_UD_PREFIX);
        } else {
            buf.append(DESCRIPTION_TEXT_AD_PREFIX);
        }
        File descFile = new File(path, DESCRIPTION_PROPFILE_NAME);
        boolean foundDescription = false;
        if (descFile.exists()) {
            try {
                Properties props = new Properties();
                props.load(new FileInputStream(descFile));
                String desc = props.getProperty(DESCRIPTION_PROP_DESCRIPTION);
                if (desc != null) {
                    buf.append(desc);
                    foundDescription = true;
                }
            }
            catch (IOException props) {}
        } else {
            descFile = new File(path, "dictionarydesc.txt");
            try {
                RandomAccessFile raf = new RandomAccessFile(descFile, "r");
                long len = raf.length();
                if (len >= Integer.MAX_VALUE) {
                    len = 256L;
                }
                byte[] bytes = new byte[(int)len];
                raf.readFully(bytes);
                raf.close();
                buf.append(new String(bytes));
                foundDescription = true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (!foundDescription) {
            buf.append(DESCRIPTION_TEXT_NO_DESCRIPTION);
        }
        return buf.toString();
    }

    public String toString() {
        int ct = this.getDictionaryCount();
        StringBuffer sb = new StringBuffer(256);
        for (int i = 1; i <= ct; ++i) {
            sb.append("Dictionary number: ");
            sb.append(i);
            sb.append(" user order: ");
            sb.append(this.getSearchOrderForDictionary(i));
            sb.append(" available: ");
            sb.append(this.isDictionaryAvailableForSearch(i));
            sb.append(" desc: ");
            sb.append(this.getDictionaryDescription(i));
            sb.append(System.getProperty("line.separator"));
        }
        return sb.toString();
    }

    private int adjustUserIndex(int idx) {
        return idx - 1;
    }

    private int adjustTrueIndex(int idx) {
        return idx + 1;
    }

    private class SearchDictionary {
        String description;
        int userPriority;
        boolean bSearchable;
        boolean bUserDict;
        int cfgOrder;

        public SearchDictionary(int configuredOrder, String desc, int priority, boolean isSearchable, boolean isUserDictionary) {
            this.bSearchable = isSearchable;
            this.bUserDict = isUserDictionary;
            this.cfgOrder = configuredOrder;
            this.description = desc;
            this.userPriority = priority;
        }
    }
}

