/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common;

import com.mapinfo.mapmarker.CandidateAddress;
import com.mapinfo.mapmarker.CandidateRange;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.BrowseSegmentEquivalenceTestor;
import com.mapinfo.mapmarker.common.ICandidate;
import com.mapinfo.mapmarker.common.ParsedNumber;
import com.mapinfo.mapmarker.common.Range;
import com.mapinfo.mapmarker.common.Segment;
import com.mapinfo.mapmarker.common.StreetCandidateAddress;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class InternalBrowseAddress
implements Address,
ICandidate {
    private List m_segments;
    private static final BrowseSegmentEquivalenceTestor m_segmentTestor = new BrowseSegmentEquivalenceTestor();
    private StreetCandidateAddress m_address;
    private String m_vendorCode;

    public InternalBrowseAddress() {
        this(new StreetCandidateAddress());
    }

    public InternalBrowseAddress(Address address) {
        if (address instanceof InternalBrowseAddress) {
            this.setStreetCandidateAddress(((InternalBrowseAddress)address).m_address);
        } else if (address instanceof StreetCandidateAddress) {
            this.setStreetCandidateAddress((StreetCandidateAddress)address);
        } else {
            this.setStreetCandidateAddress(this.makeStreetCandidateAddress(address));
        }
        this.m_segments = new ArrayList();
    }

    protected void setStreetCandidateAddress(StreetCandidateAddress address) {
        this.m_address = address;
    }

    protected StreetCandidateAddress getStreetCandidateAddress() {
        return this.m_address;
    }

    protected StreetCandidateAddress makeStreetCandidateAddress(Address addr) {
        return new StreetCandidateAddress(addr);
    }

    @Override
    public void setGenericField1(String genericField1) {
        this.m_address.setGenericField1(genericField1);
    }

    @Override
    public String getGenericField1() {
        return this.m_address.getGenericField1();
    }

    @Override
    public void setGenericField2(String genericField2) {
        this.m_address.setGenericField2(genericField2);
    }

    @Override
    public String getGenericField2() {
        return this.m_address.getGenericField2();
    }

    @Override
    public void setGenericField3(String genericField3) {
        this.m_address.setGenericField3(genericField3);
    }

    @Override
    public String getGenericField3() {
        return this.m_address.getGenericField3();
    }

    @Override
    public void setGenericField4(String genericField4) {
        this.m_address.setGenericField4(genericField4);
    }

    @Override
    public String getGenericField4() {
        return this.m_address.getGenericField4();
    }

    @Override
    public void setPlaceName(String placeName) {
        this.m_address.setPlaceName(placeName);
    }

    @Override
    public String getPlaceName() {
        return this.m_address.getPlaceName();
    }

    @Override
    public void setAddressNumber(String addressNumber) {
        this.m_address.setAddressNumber(addressNumber);
    }

    @Override
    public void setAddressNumber(ParsedNumber addressNumber) {
        this.m_address.setAddressNumber(addressNumber);
    }

    @Override
    public String getAddressNumber() {
        return this.m_address.getAddressNumber();
    }

    @Override
    public ParsedNumber getParsedAddressNumber() {
        return this.m_address.getParsedAddressNumber();
    }

    @Override
    public void setPreAddress(String preAddress) {
        this.m_address.setPreAddress(preAddress);
    }

    @Override
    public String getPreAddress() {
        return this.m_address.getPreAddress();
    }

    @Override
    public void setPreDirectional(String preDir) {
        this.m_address.setPreDirectional(preDir);
    }

    @Override
    public String getPreDirectional() {
        return this.m_address.getPreDirectional();
    }

    @Override
    public void setPreThoroughfareType(String preType) {
        this.m_address.setPreThoroughfareType(preType);
    }

    @Override
    public String getPreThoroughfareType() {
        return this.m_address.getPreThoroughfareType();
    }

    @Override
    public void setMainAddress(String mainAddress) {
        this.m_address.setMainAddress(mainAddress);
    }

    @Override
    public String getMainAddress() {
        return this.m_address.getMainAddress();
    }

    @Override
    public void setPostThoroughfareType(String postType) {
        this.m_address.setPostThoroughfareType(postType);
    }

    @Override
    public String getPostThoroughfareType() {
        return this.m_address.getPostThoroughfareType();
    }

    @Override
    public void setPostDirectional(String postDir) {
        this.m_address.setPostDirectional(postDir);
    }

    @Override
    public String getPostDirectional() {
        return this.m_address.getPostDirectional();
    }

    @Override
    public void setPostAddress(String postAddress) {
        this.m_address.setPostAddress(postAddress);
    }

    @Override
    public String getPostAddress() {
        return this.m_address.getPostAddress();
    }

    @Override
    public void setPostCode1(String postCode1) {
        this.m_address.setPostCode1(postCode1);
    }

    @Override
    public String getPostCode1() {
        return this.m_address.getPostCode1();
    }

    @Override
    public void setPostCode2(String postCode2) {
        this.m_address.setPostCode2(postCode2);
    }

    @Override
    public String getPostCode2() {
        return this.m_address.getPostCode2();
    }

    @Override
    public void setAreaName1(String areaName1) {
        this.m_address.setAreaName1(areaName1);
    }

    @Override
    public String getAreaName1() {
        return this.m_address.getAreaName1();
    }

    @Override
    public void setAreaName2(String areaName2) {
        this.m_address.setAreaName2(areaName2);
    }

    @Override
    public String getAreaName2() {
        return this.m_address.getAreaName2();
    }

    @Override
    public void setAreaName3(String areaName3) {
        this.m_address.setAreaName3(areaName3);
    }

    @Override
    public String getAreaName3() {
        return this.m_address.getAreaName3();
    }

    @Override
    public void setAreaName4(String areaName4) {
        this.m_address.setAreaName4(areaName4);
    }

    @Override
    public String getAreaName4() {
        return this.m_address.getAreaName4();
    }

    @Override
    public void setUnitValue(String unitValue) {
        this.m_address.setUnitValue(unitValue);
    }

    @Override
    public String getUnitValue() {
        return this.m_address.getUnitValue();
    }

    @Override
    public void setUnitType(String unitType) {
        this.m_address.setUnitType(unitType);
    }

    @Override
    public String getUnitType() {
        return this.m_address.getUnitType();
    }

    @Override
    public void flush() {
        this.m_address.flush();
    }

    @Override
    public void setAdditionalFields(HashMap additionalFields) {
        this.m_address.setAdditionalFields(additionalFields);
    }

    @Override
    public HashMap getAdditionalFields() {
        return this.m_address.getAdditionalFields();
    }

    public String getAdditionalFieldForKey(String key) {
        return this.m_address.getAdditionalFieldForKey(key);
    }

    @Override
    public boolean hasAdditionalFields() {
        return this.m_address.hasAdditionalFields();
    }

    @Override
    public void setAddressID(String addressID) {
        this.m_address.setAddressID(addressID);
    }

    @Override
    public String getAddressID() {
        return this.m_address.getAddressID();
    }

    @Override
    public void setCountry(String country) {
        this.m_address.setCountry(country);
    }

    @Override
    public String getCountry() {
        return this.m_address.getCountry();
    }

    @Override
    public boolean isCloseMatch() {
        return false;
    }

    public void addSegment(Segment segment) {
        segment.setCoordSysInfo(null);
        segment.setPointsAsCompressed(null);
        this.m_segments.add(segment);
    }

    public int getSegmentCount() {
        return this.m_segments.size();
    }

    public Segment getSegmentAt(int segmentNumber) {
        return (Segment)this.m_segments.get(segmentNumber);
    }

    public Segment getMatchingSegment(Segment seg) {
        int segmentCount = this.getSegmentCount();
        BrowseSegmentEquivalenceTestor segmentTestor = this.getSegmentTestor();
        for (int i = 0; i < segmentCount; ++i) {
            Segment localSegment = (Segment)this.m_segments.get(i);
            if (!segmentTestor.equivalent(localSegment, seg)) continue;
            return localSegment;
        }
        return null;
    }

    protected BrowseSegmentEquivalenceTestor getSegmentTestor() {
        return m_segmentTestor;
    }

    protected String getFormattedStreetAddress() {
        int len;
        StringBuffer str = new StringBuffer();
        String tmp = this.getPreAddress();
        if (tmp != null) {
            str.append(tmp);
            str.append(' ');
        }
        if ((tmp = this.getPreThoroughfareType()) != null) {
            str.append(tmp);
            str.append(' ');
        }
        if ((tmp = this.getMainAddress()) != null) {
            str.append(tmp);
            str.append(' ');
        }
        if ((tmp = this.getPostThoroughfareType()) != null) {
            str.append(tmp);
            str.append(' ');
        }
        if ((tmp = this.getPostAddress()) != null) {
            str.append(tmp);
            str.append(' ');
        }
        if ((len = str.length()) != 0) {
            str.deleteCharAt(len - 1);
        }
        return str.toString();
    }

    public boolean fromUserDictionary() {
        return this.m_address.fromUserDictionary();
    }

    protected void copySegmentInfoToRange(CandidateRange range, Segment segment, int segmentSide) {
        if (segmentSide == 0) {
            if (range.getAreaName1() == null) {
                range.setAreaName1(segment.getLeftAreaName1());
            }
            if (range.getAreaName2() == null) {
                range.setAreaName2(segment.getLeftAreaName2());
            }
            if (range.getAreaName3() == null) {
                range.setAreaName3(segment.getLeftAreaName3());
            }
            if (range.getAreaName4() == null) {
                range.setAreaName4(segment.getLeftAreaName4());
            }
            if (range.getPostalCode1() == null) {
                range.setPostalCode1(segment.getLeftPostCode1());
            }
            if (range.getPostalCode2() == null) {
                range.setPostalCode2(segment.getLeftPostCode2());
            }
        } else {
            if (range.getAreaName1() == null) {
                range.setAreaName1(segment.getRightAreaName1());
            }
            if (range.getAreaName2() == null) {
                range.setAreaName2(segment.getRightAreaName2());
            }
            if (range.getAreaName3() == null) {
                range.setAreaName3(segment.getRightAreaName3());
            }
            if (range.getAreaName4() == null) {
                range.setAreaName4(segment.getRightAreaName4());
            }
            if (range.getPostalCode1() == null) {
                range.setPostalCode1(segment.getRightPostCode1());
            }
            if (range.getPostalCode2() == null) {
                range.setPostalCode2(segment.getRightPostCode2());
            }
        }
    }

    @Override
    public CandidateAddress toCandidateAddress(Address parsed, IConstraints constraints) {
        CandidateAddress cand = new CandidateAddress(this);
        cand.setFormattedStreetAddress(this.getFormattedStreetAddress());
        cand.setNumberOfReturnableRanges(-1);
        if (this.fromUserDictionary()) {
            cand.setFromUserDictionary();
        }
        int segmentCount = this.getSegmentCount();
        for (int i = 0; i < segmentCount; ++i) {
            int rightRangeCount;
            Segment segment = this.getSegmentAt(i);
            int leftRangeCount = segment.getRangeCount(0);
            if (leftRangeCount != 0) {
                for (int j = 0; j < leftRangeCount; ++j) {
                    Range leftRange = segment.getRangeAt(j, 0);
                    CandidateRange range = leftRange.toCandidateRange(null, 0);
                    this.copySegmentInfoToRange(range, segment, 0);
                    cand.addCandidateRange(range);
                }
            } else if (this.makeEmptyRangeForSegment(segment, 0)) {
                CandidateRange range = new CandidateRange();
                range.setLowAddress("");
                range.setHighAddress("");
                this.copySegmentInfoToRange(range, segment, 0);
                range.setLeftRightIndicator(0);
                cand.addCandidateRange(range);
            }
            if ((rightRangeCount = segment.getRangeCount(1)) != 0) {
                for (int j = 0; j < rightRangeCount; ++j) {
                    Range rightRange = segment.getRangeAt(j, 1);
                    CandidateRange range = rightRange.toCandidateRange(null, 1);
                    this.copySegmentInfoToRange(range, segment, 1);
                    cand.addCandidateRange(range);
                }
                continue;
            }
            if (!this.makeEmptyRangeForSegment(segment, 1)) continue;
            CandidateRange range = new CandidateRange();
            range.setLowAddress("");
            range.setHighAddress("");
            this.copySegmentInfoToRange(range, segment, 1);
            range.setLeftRightIndicator(1);
            cand.addCandidateRange(range);
        }
        cand.addKeyValueToAdditionalFields("StreetDataType", this.getVendorCode());
        return cand;
    }

    protected boolean makeEmptyRangeForSegment(Segment segment, int side) {
        if (segment != null) {
            if (side == 0) {
                return !StringUtilities.isEmpty(segment.getLeftAreaName1()) || !StringUtilities.isEmpty(segment.getLeftAreaName2()) || !StringUtilities.isEmpty(segment.getLeftAreaName3()) || !StringUtilities.isEmpty(segment.getLeftAreaName4());
            }
            return !StringUtilities.isEmpty(segment.getRightAreaName1()) || !StringUtilities.isEmpty(segment.getRightAreaName2()) || !StringUtilities.isEmpty(segment.getRightAreaName3()) || !StringUtilities.isEmpty(segment.getRightAreaName4());
        }
        return false;
    }

    public void setVendorCode(String vendor_Code) {
        this.m_vendorCode = vendor_Code;
    }

    public String getVendorCode() {
        return this.m_vendorCode;
    }
}

