/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common;

import com.mapinfo.mapmarker.CandidateAddress;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.MapMarkerInternalException;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.ICandidate;
import com.mapinfo.mapmarker.common.InternalCandidateAddress;
import com.mapinfo.mapmarker.common.ParsedNumber;
import com.mapinfo.mapmarker.common.Range;
import com.mapinfo.mapmarker.common.Segment;
import com.mapinfo.mapmarker.common.dp.binary.ICompressedSegment;
import com.mapinfo.mapmarker.utils.CoordConvertor;
import com.mapinfo.mapmarker.utils.MidevConversionUtils;
import com.mapinfo.midev.geometry.DirectPosition;
import java.util.HashMap;

public class InternalIntersectionCandidateAddress
implements ICandidate,
Comparable {
    public InternalCandidateAddress m_candidate1;
    private InternalCandidateAddress m_candidate2;
    private boolean m_closeMatch;
    private DirectPosition m_intersectionPoint;
    private double m_combinedAddressScore;
    private double m_combinedAdditionalFieldsScore;
    private ParsedNumber m_Street1HN;
    private ParsedNumber m_Street2HN;
    private int m_street1Segmentptnum;
    private int m_street2Segmentptnum;
    private boolean m_dictionaryBonus;

    public InternalIntersectionCandidateAddress(InternalCandidateAddress candidate1, InternalCandidateAddress candidate2) {
        this.m_candidate1 = candidate1;
        this.m_candidate2 = candidate2;
        this.m_closeMatch = false;
        this.m_combinedAddressScore = (candidate1.getCombinedAddressScore() + candidate2.getCombinedAddressScore()) / 2.0;
        this.m_combinedAdditionalFieldsScore = (candidate1.getCombinedAdditionalFieldScore() + candidate2.getCombinedAdditionalFieldScore()) / 2.0;
        this.applyDictionaryBonus(candidate1.hasDictionaryBonus() || candidate2.hasDictionaryBonus());
    }

    @Override
    public boolean isCloseMatch() {
        return this.m_closeMatch;
    }

    public double getCombinedAddressScore() {
        return this.m_combinedAddressScore;
    }

    public double getCombinedAdditionalFieldsScore() {
        return this.m_combinedAdditionalFieldsScore;
    }

    public boolean hasIntersection() {
        return this.privateHasIntersection();
    }

    public void applyDictionaryBonus(boolean bonus) {
        this.m_dictionaryBonus = bonus;
    }

    public boolean hasDictionaryBonus() {
        return this.m_dictionaryBonus;
    }

    private boolean privateHasIntersection() {
        DirectPosition[] segment1Points = new DirectPosition[2];
        DirectPosition[] segment2Points = new DirectPosition[2];
        Segment segment1 = this.m_candidate1.getSegment();
        Segment segment2 = this.m_candidate2.getSegment();
        int segment1PointCount = segment1.getSegmentPointCount();
        int segment2PointCount = segment2.getSegmentPointCount();
        if (segment1PointCount == 0 || segment2PointCount == 0) {
            return false;
        }
        segment1Points[0] = segment1.getSegmentPointAt(0);
        segment1Points[1] = segment1.getSegmentPointAt(segment1PointCount - 1);
        segment2Points[0] = segment2.getSegmentPointAt(0);
        segment2Points[1] = segment2.getSegmentPointAt(segment2PointCount - 1);
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 2; ++j) {
                if (!this.isValidPointIntersection(segment1Points[i], segment2Points[j])) continue;
                this.m_street1Segmentptnum = i;
                this.m_street2Segmentptnum = j;
                this.m_closeMatch = true;
                this.m_intersectionPoint = new DirectPosition(segment1Points[i]);
                this.setApproxHouseNumbers();
                return true;
            }
        }
        if (segment1.getRangeCount(0) == 0 && segment1.getRangeCount(1) == 0 || segment2.getRangeCount(0) == 0 && segment2.getRangeCount(1) == 0) {
            Object[] segment1FullPoints = segment1.getSegmentPoints().toArray();
            Object[] segment2FullPoints = segment2.getSegmentPoints().toArray();
            for (int i = 0; i < segment1FullPoints.length; ++i) {
                DirectPosition segment1Point = (DirectPosition)segment1FullPoints[i];
                for (int j = 0; j < segment2FullPoints.length; ++j) {
                    DirectPosition segment2Point = (DirectPosition)segment2FullPoints[j];
                    if (!this.isValidPointIntersection(segment1Point, segment2Point)) continue;
                    this.m_street1Segmentptnum = i;
                    this.m_street2Segmentptnum = j;
                    this.m_closeMatch = true;
                    this.m_intersectionPoint = new DirectPosition(segment1Point);
                    this.setApproxHouseNumbers();
                    return true;
                }
            }
        }
        return false;
    }

    private Range getRangeOnSeg(Segment seg, int side, int highlow) {
        int rangeCnt = seg.getRangeCount(side);
        if (highlow == 0) {
            return seg.getRangeAt(0, side);
        }
        int theRng = rangeCnt - 1;
        Range range = seg.getRangeAt(theRng, side);
        while (theRng > 0 && range.getHighNumber() == range.getLowNumber()) {
            range = seg.getRangeAt(--theRng, side);
        }
        return range;
    }

    private long min(long l1, long l2) {
        if (l1 <= l2) {
            return l1;
        }
        return l2;
    }

    private void setApproxHouseNumbers() {
        int street1Side;
        int street2Side = street1Side = 0;
        Segment Can1Segment = this.m_candidate1.getSegment();
        Segment Can2Segment = this.m_candidate2.getSegment();
        Range rangeStreet1 = Can1Segment.getRangeAt(0, street1Side);
        Range rangeStreet2 = Can2Segment.getRangeAt(0, street2Side);
        if (rangeStreet1 == null) {
            street1Side = 1;
            rangeStreet1 = Can1Segment.getRangeAt(0, street1Side);
        }
        if (rangeStreet2 == null) {
            street2Side = 1;
            rangeStreet2 = Can2Segment.getRangeAt(0, street2Side);
        }
        if (rangeStreet1 == null || rangeStreet2 == null) {
            return;
        }
        if (Can1Segment.getRangeCount(street1Side) > 1) {
            rangeStreet1 = this.getRangeOnSeg(Can1Segment, street1Side, this.m_street1Segmentptnum);
        }
        if (Can2Segment.getRangeCount(street2Side) > 1) {
            rangeStreet2 = this.getRangeOnSeg(Can2Segment, street2Side, this.m_street2Segmentptnum);
        }
        this.m_Street1HN = this.m_street1Segmentptnum == 0 ? rangeStreet1.getParsedFrom() : rangeStreet1.getParsedTo();
        this.m_Street2HN = this.m_street2Segmentptnum == 0 ? rangeStreet2.getParsedFrom() : rangeStreet2.getParsedTo();
    }

    protected boolean isValidPointIntersection(DirectPosition candidate1Pnt, DirectPosition candidate2Pnt) {
        double xFudgeFactor = 0.0;
        double yFudgeFactor = 0.0;
        ICompressedSegment compressed1 = this.m_candidate1.getSegment().getSegmentPointsAsCompressed();
        ICompressedSegment compressed2 = this.m_candidate2.getSegment().getSegmentPointsAsCompressed();
        if (compressed1 != null && compressed2 != null) {
            double xFactor = this.min(this.m_candidate1.getSegment().getSegmentPointsAsCompressed().getXFactor(), this.m_candidate2.getSegment().getSegmentPointsAsCompressed().getXFactor());
            double yFactor = this.min(this.m_candidate1.getSegment().getSegmentPointsAsCompressed().getYFactor(), this.m_candidate2.getSegment().getSegmentPointsAsCompressed().getYFactor());
            if (xFactor > 0.0 && yFactor > 0.0) {
                xFudgeFactor = 1.0 / xFactor + 1.0 / (xFactor * xFactor);
                yFudgeFactor = 1.0 / yFactor + 1.0 / (yFactor * yFactor);
            }
        }
        double xDelta = Math.abs(candidate1Pnt.getX() - candidate2Pnt.getX());
        double yDelta = Math.abs(candidate1Pnt.getY() - candidate2Pnt.getY());
        return xDelta <= xFudgeFactor && yDelta <= yFudgeFactor;
    }

    @Override
    public CandidateAddress toCandidateAddress(Address input, IConstraints constraints) throws MapMarkerInternalException {
        if (!this.m_closeMatch) {
            return null;
        }
        CandidateAddress returnCandidate = new CandidateAddress(this.m_candidate1);
        returnCandidate.setPostAddress(null);
        returnCandidate.setPreAddress(null);
        returnCandidate.setPostThoroughfareType(null);
        returnCandidate.setPreThoroughfareType(null);
        returnCandidate.setAddressNumber((String)null);
        returnCandidate.setPreDirectional(null);
        returnCandidate.setPostDirectional(null);
        if (input.getPostCode1() != null && input.getPostCode1().length() != 0) {
            if (input.getPostCode1().equals(this.m_candidate1.getPostCode1()) && input.getPostCode1().equals(this.m_candidate2.getPostCode1())) {
                returnCandidate.setPostalCode1Matched();
            }
        } else {
            returnCandidate.setPostalCode1Matched();
        }
        if (input.getPostCode2() != null && input.getPostCode2().length() != 0) {
            if (input.getPostCode2().equals(this.m_candidate1.getPostCode2()) && input.getPostCode2().equals(this.m_candidate2.getPostCode2())) {
                returnCandidate.setPostalCode2Matched();
            }
        } else {
            returnCandidate.setPostalCode2Matched();
        }
        if (input.getAreaName1() != null && input.getAreaName1().length() != 0) {
            if (input.getAreaName1().equals(this.m_candidate1.getAreaName1()) && input.getAreaName1().equals(this.m_candidate2.getAreaName1())) {
                returnCandidate.setAreaName1Matched();
            }
        } else {
            returnCandidate.setAreaName1Matched();
        }
        if (input.getAreaName2() != null && input.getAreaName2().length() != 0) {
            if (input.getAreaName2().equals(this.m_candidate1.getAreaName2()) && input.getAreaName2().equals(this.m_candidate2.getAreaName2())) {
                returnCandidate.setAreaName2Matched();
            }
        } else {
            returnCandidate.setAreaName2Matched();
        }
        if (input.getAreaName3() != null && input.getAreaName3().length() != 0) {
            if (input.getAreaName3().equals(this.m_candidate1.getAreaName3()) && input.getAreaName3().equals(this.m_candidate2.getAreaName3())) {
                returnCandidate.setAreaName3Matched();
            }
        } else {
            returnCandidate.setAreaName3Matched();
        }
        if (input.getAreaName4() != null && input.getAreaName4().length() != 0) {
            if (input.getAreaName4().equals(this.m_candidate1.getAreaName4()) && input.getAreaName4().equals(this.m_candidate2.getAreaName4())) {
                returnCandidate.setAreaName4Matched();
            }
        } else {
            returnCandidate.setAreaName4Matched();
        }
        if (input.getCountry() != null && input.getCountry().length() != 0 && this.m_candidate1.getCountryScore() == 1.0 && this.m_candidate2.getCountryScore() == 1.0) {
            returnCandidate.setCountryMatched();
        }
        if (this.m_Street1HN != null) {
            this.m_candidate1.setAddressNumber(this.m_Street1HN);
        }
        if (this.m_Street2HN != null) {
            this.m_candidate2.setAddressNumber(this.m_Street2HN);
        }
        returnCandidate.setFormattedStreetAddress(this.m_candidate1.getFormattedStreetAddress() + " && " + this.m_candidate2.getFormattedStreetAddress());
        returnCandidate.setFormattedLocationAddress(this.m_candidate1.getFormattedLocationAddress());
        returnCandidate.setMainAddress(returnCandidate.getFormattedStreetAddress());
        if (this.m_candidate1.getMainAddressScore() == 1.0 && this.m_candidate2.getMainAddressScore() == 1.0) {
            returnCandidate.setStreetNameMatched();
        }
        if (this.m_candidate1.getPostAddressScore() == 1.0 && this.m_candidate2.getPostAddressScore() == 1.0 && this.m_candidate1.getPreAddressScore() == 1.0 && this.m_candidate2.getPreAddressScore() == 1.0) {
            returnCandidate.setStreetPrefixAndSuffixMatched();
        }
        if (this.m_candidate1.getPreThoroughfareTypeScore() == 1.0 && this.m_candidate2.getPreThoroughfareTypeScore() == 1.0 && this.m_candidate1.getPostThoroughfareTypeScore() == 1.0 && this.m_candidate2.getPostThoroughfareTypeScore() == 1.0) {
            returnCandidate.setThoroughfareTypeMatched();
        }
        if (this.m_candidate1.getPreDirectionalScore() == 1.0 && this.m_candidate2.getPreDirectionalScore() == 1.0) {
            returnCandidate.setPreDirectionalMatched();
        }
        if (this.m_candidate1.getPostDirectionalScore() == 1.0 && this.m_candidate2.getPostDirectionalScore() == 1.0) {
            returnCandidate.setPostDirectionalMatched();
        }
        returnCandidate.setCloseMatch();
        returnCandidate.setLocation(this.m_intersectionPoint);
        returnCandidate.setLocation(CoordConvertor.transformPointFromWGS84(constraints.getClientCoordinateSystemObject(), returnCandidate.getLocationPoint()));
        returnCandidate.setLocationPrecision(6);
        returnCandidate.setCoordSysString(MidevConversionUtils.getSRSname(constraints.getClientCoordinateSystemObject()));
        if (this.m_candidate1.fromUserDictionary() || this.m_candidate2.fromUserDictionary()) {
            returnCandidate.setFromUserDictionary();
        }
        HashMap adFields = returnCandidate.getAdditionalFields();
        adFields.put(CandidateAddress.INTERSECTION_OUTPUT_STRING, returnCandidate.getFormattedStreetAddress());
        String geores = this.buildPrecisionCode(returnCandidate);
        returnCandidate.addKeyValueToAdditionalFields("RESULT_CODE", geores);
        returnCandidate.addKeyValueToAdditionalFields("StreetDataType", this.m_candidate1.getVendorCode());
        return returnCandidate;
    }

    public boolean isSameIntersection(InternalIntersectionCandidateAddress that) {
        return this.m_intersectionPoint.equals((Object)that.m_intersectionPoint) && this.checkStreetHouseNumbers(that);
    }

    public boolean equals(Object o) {
        InternalIntersectionCandidateAddress that = (InternalIntersectionCandidateAddress)o;
        return this.getCombinedAddressScore() == that.getCombinedAddressScore() && this.getCombinedAdditionalFieldsScore() == that.getCombinedAdditionalFieldsScore() && this.hasDictionaryBonus() == that.hasDictionaryBonus();
    }

    private boolean rangesEquivalent(Object o) {
        InternalIntersectionCandidateAddress that = (InternalIntersectionCandidateAddress)o;
        return this.checkStreetHouseNumbers(that);
    }

    public int compareTo(Object o2) {
        double address2Score;
        boolean bRangesOkay = false;
        InternalIntersectionCandidateAddress candidate2 = (InternalIntersectionCandidateAddress)o2;
        if (this.rangesEquivalent(candidate2)) {
            bRangesOkay = true;
        }
        if (this.equals(candidate2) && bRangesOkay) {
            return 0;
        }
        if (this.equals(candidate2) && !bRangesOkay && this.getApproximateHouseNumberforStreet1() != null && this.getApproximateHouseNumberforStreet2() != null) {
            return 1;
        }
        if (this.equals(candidate2) && !bRangesOkay && candidate2.getApproximateHouseNumberforStreet1() != null && candidate2.getApproximateHouseNumberforStreet2() != null) {
            return -1;
        }
        double address1Score = this.getCombinedAddressScore();
        if (address1Score == (address2Score = candidate2.getCombinedAddressScore())) {
            double additionalScore2;
            double additionalScore1 = this.getCombinedAdditionalFieldsScore();
            if (additionalScore1 == (additionalScore2 = candidate2.getCombinedAdditionalFieldsScore())) {
                if (this.hasDictionaryBonus() && !candidate2.hasDictionaryBonus()) {
                    return 1;
                }
                return -1;
            }
            if (additionalScore1 < additionalScore2) {
                return -1;
            }
            return 1;
        }
        if (address1Score < address2Score) {
            return -1;
        }
        return 1;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("InternalIntersectionCandidateAddress:");
        buffer.append("\nIntersection Point: " + this.m_intersectionPoint.toString());
        buffer.append("\nCloseMatch? " + this.isCloseMatch());
        buffer.append("\nCombinedAddressScore: " + this.getCombinedAddressScore());
        buffer.append("\nCombinedAdditionalFieldsScore: " + this.getCombinedAdditionalFieldsScore());
        buffer.append("\nAddress 1: " + this.m_candidate1.toString());
        buffer.append("\nAddress 2: " + this.m_candidate2.toString());
        buffer.append("\nFromUserDictionary: ");
        buffer.append("\nAddress 1: " + this.m_candidate1.fromUserDictionary());
        buffer.append("\nAddress 2: " + this.m_candidate2.fromUserDictionary());
        return buffer.toString();
    }

    public InternalCandidateAddress getCandidate1() {
        return this.m_candidate1;
    }

    public InternalCandidateAddress getCandidate2() {
        return this.m_candidate2;
    }

    public DirectPosition getIntersectionPoint() {
        return this.m_intersectionPoint;
    }

    public void setIntersectionPoint(DirectPosition pnt) {
        this.m_intersectionPoint = pnt;
    }

    public void setCombinedAddressScore(double combinedScore) {
        this.m_combinedAddressScore = combinedScore;
    }

    public void setCombinedAdditionalFieldsScore(double combinedAdditionalScore) {
        this.m_combinedAdditionalFieldsScore = combinedAdditionalScore;
    }

    public boolean streetsHaveHouseNumbers() {
        return this.getApproximateHouseNumberforStreet1() != null && this.getApproximateHouseNumberforStreet2() != null;
    }

    private boolean checkStreetHouseNumbers(InternalIntersectionCandidateAddress that) {
        return this.m_Street1HN != null && that.m_Street1HN != null || this.m_Street1HN == null && that.m_Street1HN == null || this.m_Street2HN != null && that.m_Street2HN != null || this.m_Street2HN == null && that.m_Street2HN == null;
    }

    public String getApproximateHouseNumberforStreet1() {
        if (this.m_Street1HN == null) {
            return null;
        }
        return this.m_Street1HN.getCombinedAddressNumber();
    }

    public String getApproximateHouseNumberforStreet2() {
        if (this.m_Street2HN == null) {
            return null;
        }
        return this.m_Street2HN.getCombinedAddressNumber();
    }

    public String buildPrecisionCode(CandidateAddress cand) {
        return "SX";
    }
}

