/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common;

import com.mapinfo.mapmarker.common.ISoundexKey;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class MiSoundexKey
implements ISoundexKey {
    protected int m_numericValue;
    protected char m_firstChar;

    public MiSoundexKey() {
    }

    public MiSoundexKey(MiSoundexKey key) {
        this.m_numericValue = key.m_numericValue;
        this.m_firstChar = key.m_firstChar;
    }

    public int getNumericValue() {
        return this.m_numericValue;
    }

    public char getFirstChar() {
        return this.m_firstChar;
    }

    public void setNumericValue(int value) {
        this.m_numericValue = value;
    }

    public void setFirstChar(char firstChar) {
        this.m_firstChar = firstChar;
    }

    public int compareTo(Object o) {
        MiSoundexKey that = (MiSoundexKey)o;
        int charComp = this.getFirstChar() - that.getFirstChar();
        int numComp = this.getNumericValue() - that.getNumericValue();
        if (numComp != 0) {
            return numComp;
        }
        return charComp;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("First char: ");
        sb.append(this.m_firstChar);
        sb.append("  Numeric value: ");
        sb.append(this.m_numericValue);
        return sb.toString();
    }

    @Override
    public void read(DataInput in) throws IOException {
        this.m_firstChar = in.readChar();
        this.m_numericValue = in.readInt();
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeChar(this.m_firstChar);
        out.writeInt(this.m_numericValue);
    }

    public boolean equals(Object that) {
        MiSoundexKey thatKey = (MiSoundexKey)that;
        return this.m_firstChar == thatKey.m_firstChar && this.m_numericValue == thatKey.m_numericValue;
    }

    public int hashCode() {
        int result = this.m_numericValue;
        result = 31 * result + this.m_firstChar;
        return result;
    }

    public boolean isNumeric() {
        return this.m_firstChar == '0';
    }
}

