/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common;

import com.mapinfo.mapmarker.common.ParsedNumber;
import com.mapinfo.mapmarker.common.ParsedRangeScore;
import com.mapinfo.mapmarker.utils.StringUtilities;

public class ParsedRange {
    private boolean bPrintDebug = false;
    private ParsedNumber m_low;
    private ParsedNumber m_high;
    private ParsedRangeScore m_queryScore;
    private boolean bPointRange;
    private boolean bHasPrefix;
    private boolean bHasNumber;
    private boolean bHasSuffix;
    private boolean bHasSuffixNumber;
    private boolean bHasTrailer;
    private boolean bHasNumSeparator;
    private boolean bHasSuffixSeparator;
    private boolean bHasPrefixSeparator;
    private boolean bHasTrailerSeparator;
    private int m_varyingField;
    private String m_varyingStringLow;
    private String m_varyingStringHigh;
    private long m_varyingNumLow;
    private long m_varyingNumHigh;
    private boolean bIsHyphenated;
    private long m_unhyphenatedLowValue;
    private long m_unhyphenatedHighValue;
    public static final int VARYING_PREFIX = 1;
    public static final int VARYING_NUMBER = 2;
    public static final int VARYING_SUFFIX = 3;
    public static final int VARYING_SUFFIX_NUMBER = 4;
    public static final int VARYING_TRAILER = 5;
    String m_fixedPrefix;
    String m_fixedSuffix;
    String m_fixedTrailer;
    long m_fixedNumber;
    long m_fixedSuffixNumber;
    private boolean m_bMismatchedFractionalTrailers;

    public ParsedRange(ParsedRange copy) {
        this.m_bMismatchedFractionalTrailers = copy.isMismatchedFractionalTrailers();
        this.m_fixedNumber = copy.m_fixedNumber;
        this.m_fixedSuffixNumber = copy.m_fixedSuffixNumber;
        this.m_high = new ParsedNumber(copy.getHighEndpoint());
        this.m_low = new ParsedNumber(copy.getLowEndpoint());
        this.m_queryScore = new ParsedRangeScore(copy.getQueryScore());
        this.m_unhyphenatedHighValue = copy.m_unhyphenatedHighValue;
        this.m_unhyphenatedLowValue = copy.m_unhyphenatedLowValue;
        this.m_varyingField = copy.m_varyingField;
        this.m_varyingNumHigh = copy.m_varyingNumHigh;
        this.m_varyingNumLow = copy.m_varyingNumLow;
        this.m_fixedPrefix = copy.m_fixedPrefix;
        this.m_fixedSuffix = copy.m_fixedSuffix;
        this.m_fixedTrailer = copy.m_fixedTrailer;
        this.m_varyingStringHigh = copy.m_varyingStringHigh;
        this.m_varyingStringLow = copy.m_varyingStringLow;
    }

    public ParsedRange(ParsedNumber singleNumber) {
        this.setupPointRange(singleNumber);
    }

    public ParsedRange(ParsedNumber low, ParsedNumber high) {
        if (low.equals(high)) {
            this.setupPointRange(low);
            return;
        }
        this.m_low = low;
        this.m_high = high;
        boolean bLowHyp = low.isHyphenatedNumber();
        boolean bHighHyp = high.isHyphenatedNumber();
        if (bLowHyp && bHighHyp) {
            this.setIsHyphenated(true);
            this.m_unhyphenatedLowValue = ParsedNumber.computeUnhyphenatedNumber(low, low, high);
            this.m_unhyphenatedHighValue = ParsedNumber.computeUnhyphenatedNumber(high, low, high);
        } else if (this.bPrintDebug && (bLowHyp || bHighHyp)) {
            System.out.println("bad low is " + low.getCombinedAddressNumber());
            System.out.println("bad high is " + high.getCombinedAddressNumber());
        }
        String tmplow = low.getAddressPrefix();
        String tmphigh = high.getAddressPrefix();
        if (tmplow != null && tmphigh != null && tmplow.length() != 0 && tmphigh.length() != 0) {
            this.bHasPrefix = true;
            if (!tmplow.equalsIgnoreCase(tmphigh)) {
                if (this.bPrintDebug && this.m_varyingField != 0) {
                    System.out.println("bad low is " + low.getCombinedAddressNumber());
                    System.out.println("bad high is " + high.getCombinedAddressNumber());
                }
                this.m_varyingField = 1;
                this.setVaryingStringLow(tmplow);
                this.setVaryingStringHigh(tmphigh);
            } else {
                this.m_fixedPrefix = low.getAddressPrefix();
            }
        } else if (this.bPrintDebug && (tmplow != null && tmplow.length() != 0 || tmphigh != null && tmphigh.length() != 0)) {
            System.out.println("bad low is " + low.getCombinedAddressNumber());
            System.out.println("bad high is " + high.getCombinedAddressNumber());
        }
        if (low.getAddressNumberExists() && high.getAddressNumberExists()) {
            this.bHasNumber = true;
            if (low.getAddressNumber() != high.getAddressNumber()) {
                if (this.bPrintDebug && this.m_varyingField != 0) {
                    System.out.println("bad low is " + low.getCombinedAddressNumber());
                    System.out.println("bad high is " + high.getCombinedAddressNumber());
                }
                this.m_varyingField = 2;
                this.setVaryingNumLow(low.getAddressNumber());
                this.setVaryingNumHigh(high.getAddressNumber());
            } else {
                this.m_fixedNumber = low.getAddressNumber();
            }
        } else if (this.bPrintDebug && (low.getAddressNumberExists() || high.getAddressNumberExists())) {
            System.out.println("bad low is " + low.getCombinedAddressNumber());
            System.out.println("bad high is " + high.getCombinedAddressNumber());
        }
        tmplow = low.getAddressSuffix();
        tmphigh = high.getAddressSuffix();
        if (tmplow != null && tmphigh != null && tmplow.length() != 0 && tmphigh.length() != 0) {
            this.bHasSuffix = true;
            if (!tmplow.equalsIgnoreCase(tmphigh)) {
                if (this.bPrintDebug && this.m_varyingField != 0) {
                    System.out.println("bad low is " + low.getCombinedAddressNumber());
                    System.out.println("bad high is " + high.getCombinedAddressNumber());
                }
                this.m_varyingField = 3;
                this.setVaryingStringLow(tmplow);
                this.setVaryingStringHigh(tmphigh);
            } else {
                this.m_fixedSuffix = low.getAddressSuffix();
            }
        } else if (this.bPrintDebug && (tmplow != null && tmplow.length() != 0 || tmphigh != null && tmphigh.length() != 0)) {
            System.out.println("bad low is " + low.getCombinedAddressNumber());
            System.out.println("bad high is " + high.getCombinedAddressNumber());
        }
        if (low.getSuffixNumberExists() && high.getSuffixNumberExists()) {
            this.bHasSuffixNumber = true;
            if (low.getSuffixNumber() != high.getSuffixNumber()) {
                if (this.bPrintDebug && this.m_varyingField != 0) {
                    System.out.println("bad low is " + low.getCombinedAddressNumber());
                    System.out.println("bad high is " + high.getCombinedAddressNumber());
                }
                this.m_varyingField = 4;
                this.setVaryingNumLow(low.getSuffixNumber());
                this.setVaryingNumHigh(high.getSuffixNumber());
            } else {
                this.m_fixedSuffixNumber = low.getSuffixNumber();
            }
        } else if (this.bPrintDebug && (low.getSuffixNumberExists() || high.getSuffixNumberExists())) {
            System.out.println("bad low is " + low.getCombinedAddressNumber());
            System.out.println("bad high is " + high.getCombinedAddressNumber());
        }
        tmplow = low.getAddressTrailer();
        tmphigh = high.getAddressTrailer();
        if (low.isFractionalTrailer() && !high.isFractionalTrailer()) {
            this.setMismatchedFractionalTrailers(true);
            this.bHasTrailer = true;
            if (this.bPrintDebug) {
                System.out.println("bad mismatch low is " + low.getCombinedAddressNumber());
                System.out.println("bad mismatch high is " + high.getCombinedAddressNumber());
            }
        } else if (!low.isFractionalTrailer() && high.isFractionalTrailer()) {
            this.setMismatchedFractionalTrailers(true);
            this.bHasTrailer = true;
            if (this.bPrintDebug) {
                System.out.println("bad mismatch low is " + low.getCombinedAddressNumber());
                System.out.println("bad mismatch high is " + high.getCombinedAddressNumber());
            }
        } else if (tmplow != null && tmphigh != null && tmplow.length() != 0 && tmphigh.length() != 0) {
            this.bHasTrailer = true;
            if (!tmplow.equalsIgnoreCase(tmphigh)) {
                if (this.bPrintDebug && this.m_varyingField != 0) {
                    System.out.println("bad low is " + low.getCombinedAddressNumber());
                    System.out.println("bad high is " + high.getCombinedAddressNumber());
                }
                this.m_varyingField = 5;
                this.setVaryingStringLow(tmplow);
                this.setVaryingStringHigh(tmphigh);
            } else {
                this.m_fixedTrailer = low.getAddressTrailer();
            }
        } else if (this.bPrintDebug && (tmplow != null && tmplow.length() != 0 || tmphigh != null && tmphigh.length() != 0)) {
            System.out.println("bad low is " + low.getCombinedAddressNumber());
            System.out.println("bad high is " + high.getCombinedAddressNumber());
        }
    }

    private void setupPointRange(ParsedNumber singleNumber) {
        String tmp;
        if (singleNumber.getPrefixSeparator() != null && singleNumber.getPrefixSeparator().length() > 0 && (singleNumber.getAddressPrefix() == null || singleNumber.getAddressPrefix().length() == 0) && singleNumber.getPrefixSeparator().charAt(0) == '-') {
            singleNumber.setPrefixSeparator(null);
            singleNumber.setAddressNumberExists(true);
            singleNumber.setPureNumeric();
        }
        this.m_low = singleNumber;
        this.m_high = singleNumber;
        this.bPointRange = true;
        if (singleNumber.isHyphenatedNumber()) {
            this.setIsHyphenated(true);
            this.m_unhyphenatedHighValue = this.m_unhyphenatedLowValue = ParsedNumber.computeUnhyphenatedNumber(singleNumber, singleNumber, singleNumber);
        }
        if ((tmp = singleNumber.getAddressPrefix()) != null && tmp.length() != 0) {
            this.bHasPrefix = true;
            this.m_fixedPrefix = tmp;
            if (singleNumber.hasPrefixSeparator()) {
                this.bHasPrefixSeparator = true;
            }
        }
        if (singleNumber.getAddressNumberExists()) {
            this.bHasNumber = true;
            this.m_fixedNumber = singleNumber.getAddressNumber();
            if (singleNumber.hasNumberSeparator()) {
                this.bHasNumSeparator = true;
            }
        }
        if ((tmp = singleNumber.getAddressSuffix()) != null && tmp.length() != 0) {
            this.bHasSuffix = true;
            this.m_fixedSuffix = tmp;
            if (singleNumber.hasSuffixSeparator()) {
                this.bHasSuffixSeparator = true;
            }
        }
        if (singleNumber.getSuffixNumberExists()) {
            this.bHasSuffixNumber = true;
            this.m_fixedSuffixNumber = singleNumber.getSuffixNumber();
        }
        if ((tmp = singleNumber.getAddressTrailer()) != null && tmp.length() != 0) {
            this.bHasTrailer = true;
            this.m_fixedTrailer = tmp;
            if (singleNumber.hasTrailerSeparator()) {
                this.bHasTrailerSeparator = true;
            }
        }
        if (!(singleNumber.getNumFields() != 1 || this.bHasPrefix || this.bHasNumber || this.bHasSuffix || this.bHasSuffixNumber || this.bHasTrailer || !"-".equalsIgnoreCase(singleNumber.getPrefixSeparator()))) {
            this.bHasNumber = true;
        }
    }

    public ParsedRangeScore scoreQueryNumber(ParsedNumber queryNum) {
        if (queryNum == null) {
            ParsedRangeScore queryScore = new ParsedRangeScore(queryNum);
            queryScore.setValid(false);
            queryScore.setNumberFieldsMatched(0);
            this.setQueryScore(queryScore);
            return queryScore;
        }
        if (this.bPointRange) {
            return this.scorePointRangeQueryNumber(queryNum);
        }
        int numFieldsMatched = 0;
        ParsedRangeScore queryScore = new ParsedRangeScore(queryNum);
        if (this.m_bMismatchedFractionalTrailers) {
            queryScore.setSourceRangeHasMismatchedFractionalTrailers(true);
            queryScore.setLowTrailer(this.m_low.getAddressTrailer());
            queryScore.setHighTrailer(this.m_high.getAddressTrailer());
        }
        if (queryNum.isHyphenatedNumber()) {
            queryScore.setHyphenated(true);
            queryScore.setUnhyphenatedValue(ParsedNumber.computeUnhyphenatedNumber(queryNum, this.m_low, this.m_high));
            if (!this.isHyphenated() && this.m_low.isPureNumeric() && queryNum.getNumFields() == 3) {
                queryScore.setNumVaries(true);
                queryScore.setNumberMatched(true);
                queryScore.setSuffixNumberMatched(true);
                queryScore.setVaryNum(queryScore.getUnhyphenatedValue());
                queryScore.setVaryNumLow(this.m_low.getAddressNumber());
                queryScore.setVaryNumHigh(this.m_high.getAddressNumber());
                queryScore.setUseUnhyphenatedValue(true);
                queryScore.setScoringNumber(new ParsedNumber(queryScore.getVaryNum()));
                queryScore.getScoringNumber().setPureNumeric();
                queryScore.getScoringNumber().setHyphenatedNumber();
                this.setQueryScore(queryScore);
                return queryScore;
            }
        } else if (this.isHyphenated() && queryNum.isPureNumeric()) {
            if (this.bHasPrefix || this.bHasSuffix || this.bHasTrailer) {
                queryScore.setValid(false);
            } else {
                queryScore.setNumVaries(true);
                ParsedNumber tmpNum = new ParsedNumber(queryNum.getAddressNumber());
                ParsedNumber.computeHyphenatedNumber(tmpNum, queryNum, this.m_low, this.m_high);
                long num = ParsedNumber.computeUnhyphenatedNumber(tmpNum, this.m_low, this.m_high);
                queryScore.setNumberMatched(true);
                queryScore.setVaryNum(num);
                queryScore.setVaryNumLow(this.m_unhyphenatedLowValue);
                queryScore.setVaryNumHigh(this.m_unhyphenatedHighValue);
                queryScore.setScoringNumber(tmpNum);
            }
            this.setQueryScore(queryScore);
            return queryScore;
        }
        boolean bRemovePrefixSep = false;
        String tmp = queryNum.getAddressPrefix();
        if (tmp != null && tmp.length() != 0) {
            if (!this.bHasPrefix) {
                String suf = queryNum.getAddressSuffix();
                if (this.bHasSuffix && (suf == null || suf.length() == 0)) {
                    if (this.m_varyingField == 3) {
                        queryScore.setPrefixMatched(true);
                        queryScore.setStringVaries(true);
                        queryScore.setVaryString(tmp);
                        queryScore.setVaryStringLow(this.getVaryingStringLow());
                        queryScore.setVaryStringHigh(this.getVaryingStringHigh());
                        queryScore.setCheckSwappedPrefix(true);
                        queryScore.getScoringNumber().setAddressPrefix(suf);
                        queryScore.getScoringNumber().setAddressSuffix(null);
                    } else if (tmp.equalsIgnoreCase(this.m_fixedSuffix)) {
                        queryScore.setCheckSwappedPrefix(true);
                        ++numFieldsMatched;
                        queryScore.setPrefixMatched(true);
                        queryScore.getScoringNumber().setAddressPrefix(suf);
                        queryScore.getScoringNumber().setAddressSuffix(null);
                    }
                } else {
                    queryScore.setValid(false);
                }
            } else if (this.m_varyingField == 1) {
                queryScore.setStringVaries(true);
                queryScore.setVaryString(tmp);
                queryScore.setVaryStringLow(this.getVaryingStringLow());
                queryScore.setVaryStringHigh(this.getVaryingStringHigh());
                queryScore.setPrefixMatched(true);
            } else if (this.m_fixedPrefix != null && !this.m_fixedPrefix.equalsIgnoreCase(tmp)) {
                queryScore.setValid(false);
            } else {
                queryScore.setPrefixMatched(true);
                ++numFieldsMatched;
            }
        } else if (this.bHasPrefix && !this.setAbsentStringForParsedRangeScore(queryScore, queryNum, true)) {
            queryScore.setValid(false);
        }
        if (queryNum.getAddressNumberExists()) {
            if (!this.bHasNumber && queryNum.getAddressNumber() == 0L && queryNum.getPrefixSeparator().length() == 0 && this.m_high.getPrefixSeparator().equals("-")) {
                bRemovePrefixSep = true;
                queryScore.setNumberMatched(true);
            } else if (!this.bHasNumber) {
                queryScore.setValid(false);
            } else if (this.m_varyingField == 2) {
                queryScore.setNumberMatched(true);
                queryScore.setNumVaries(true);
                queryScore.setVaryNum(queryNum.getAddressNumber());
                queryScore.setVaryNumLow(this.getVaryingNumLow());
                queryScore.setVaryNumHigh(this.getVaryingNumHigh());
            } else if (this.m_fixedNumber != queryNum.getAddressNumber()) {
                queryScore.setValid(false);
            } else {
                queryScore.setNumberMatched(true);
                ++numFieldsMatched;
            }
        } else if (this.bHasNumber) {
            queryScore.setValid(false);
        }
        tmp = queryNum.getAddressSuffix();
        if (tmp != null && tmp.length() != 0) {
            if (!this.bHasSuffix) {
                if (this.bHasSuffixNumber || this.bHasTrailer) {
                    queryScore.setValid(false);
                } else {
                    queryScore.setAddsSuffix(true);
                    queryScore.setAddedString(tmp);
                }
            } else if (this.m_varyingField == 3) {
                queryScore.setSuffixMatched(true);
                queryScore.setStringVaries(true);
                queryScore.setVaryString(tmp);
                queryScore.setVaryStringLow(this.getVaryingStringLow());
                queryScore.setVaryStringHigh(this.getVaryingStringHigh());
            } else if (this.m_fixedSuffix == null) {
                queryScore.setValid(false);
            } else if (!this.m_fixedSuffix.equalsIgnoreCase(tmp)) {
                if (tmp.length() == this.m_fixedSuffix.length() + 1) {
                    if (this.isPointRange()) {
                        queryScore.setValid(false);
                    } else if (!tmp.startsWith(this.m_fixedSuffix)) {
                        queryScore.setValid(false);
                    }
                } else {
                    queryScore.setValid(false);
                }
            } else {
                queryScore.setSuffixMatched(true);
                ++numFieldsMatched;
            }
        } else if (this.bHasSuffix && !this.setAbsentStringForParsedRangeScore(queryScore, queryNum, false) && !queryScore.isCheckSwappedPrefix()) {
            queryScore.setValid(false);
        }
        if (queryNum.getSuffixNumberExists()) {
            if (!this.bHasSuffixNumber) {
                if (!this.isHyphenated() && queryScore.isHyphenated()) {
                    if (this.m_low.isPureNumeric() && this.m_high.isPureNumeric()) {
                        String prefix = queryNum.getAddressPrefix();
                        String trailer = queryNum.getAddressTrailer();
                        if (!(queryScore.isAddsSuffix() || prefix != null && prefix.length() != 0 || trailer != null && trailer.length() != 0)) {
                            queryScore.setUseUnhyphenatedValue(true);
                        } else {
                            queryScore.setValid(false);
                        }
                    } else {
                        queryScore.setValid(false);
                    }
                } else {
                    queryScore.setValid(false);
                }
            } else if (this.m_varyingField == 4) {
                queryScore.setSuffixNumberMatched(true);
                queryScore.setNumVaries(true);
                queryScore.setVaryNum(queryNum.getSuffixNumber());
                queryScore.setVaryNumLow(this.getVaryingNumLow());
                queryScore.setVaryNumHigh(this.getVaryingNumHigh());
            } else if (this.m_fixedSuffixNumber != queryNum.getSuffixNumber()) {
                queryScore.setValid(false);
            } else {
                queryScore.setSuffixNumberMatched(true);
                ++numFieldsMatched;
            }
        } else if (this.bHasSuffixNumber) {
            queryScore.setValid(false);
        }
        tmp = queryNum.getAddressTrailer();
        if (tmp != null && tmp.length() != 0) {
            if (queryNum.isFractionalTrailer()) {
                queryScore.setHasTrailingFraction(true);
            }
            if (!this.bHasTrailer) {
                queryScore.setAddsTrailer(true);
                queryScore.setAddedString(tmp);
            } else if (this.m_varyingField == 5) {
                queryScore.setTrailerMatched(true);
                queryScore.setStringVaries(true);
                queryScore.setVaryString(tmp);
                queryScore.setVaryStringLow(this.getVaryingStringLow());
                queryScore.setVaryStringHigh(this.getVaryingStringHigh());
            } else if (!this.m_bMismatchedFractionalTrailers && !this.m_fixedTrailer.equalsIgnoreCase(tmp)) {
                queryScore.setValid(false);
            } else {
                queryScore.setTrailerMatched(true);
                ++numFieldsMatched;
            }
        } else if (this.bHasTrailer && !this.isMismatchedFractionalTrailers()) {
            queryScore.setValid(false);
        }
        queryScore.checkValid();
        String tmpSep = queryNum.getPrefixSeparator();
        String rangeSep = this.m_low.getPrefixSeparator();
        if (tmpSep != null && tmpSep.length() != 0) {
            if (tmpSep.equals(rangeSep)) {
                ++numFieldsMatched;
            } else if (rangeSep == null || rangeSep.length() == 0) {
                queryScore.getScoringNumber().setPrefixSeparator(rangeSep);
            }
        } else if (rangeSep != null && rangeSep.length() != 0 && !bRemovePrefixSep) {
            queryScore.getScoringNumber().setPrefixSeparator(rangeSep);
        }
        tmpSep = queryNum.getSuffixSeparator();
        rangeSep = this.m_low.getSuffixSeparator();
        if (tmpSep != null && tmpSep.length() != 0) {
            if (tmpSep.equals(rangeSep)) {
                ++numFieldsMatched;
            } else if (rangeSep == null || rangeSep.length() == 0) {
                queryScore.getScoringNumber().setSuffixSeparator(rangeSep);
            }
        } else if (rangeSep != null && rangeSep.length() != 0) {
            queryScore.getScoringNumber().setSuffixSeparator(rangeSep);
        }
        tmpSep = queryNum.getNumberSeparator();
        rangeSep = this.m_low.getNumberSeparator();
        if (tmpSep != null && tmpSep.length() != 0) {
            if (tmpSep.equals(rangeSep)) {
                ++numFieldsMatched;
            } else if (rangeSep == null || rangeSep.length() == 0) {
                queryScore.getScoringNumber().setNumberSeparator(rangeSep);
            }
        } else if (rangeSep != null && rangeSep.length() != 0) {
            queryScore.getScoringNumber().setNumberSeparator(rangeSep);
        }
        tmpSep = queryNum.getTrailerSeparator();
        rangeSep = this.m_low.getTrailerSeparator();
        if (tmpSep != null && tmpSep.length() != 0) {
            if (tmpSep.equals(rangeSep)) {
                ++numFieldsMatched;
            } else if (rangeSep == null || rangeSep.length() == 0) {
                queryScore.getScoringNumber().setTrailerSeparator(rangeSep);
            }
        } else if (rangeSep != null && rangeSep.length() != 0) {
            queryScore.getScoringNumber().setTrailerSeparator(rangeSep);
        }
        queryScore.setNumberFieldsMatched(numFieldsMatched);
        this.setQueryScore(queryScore);
        return queryScore;
    }

    protected ParsedRangeScore scorePointRangeQueryNumber(ParsedNumber queryNumber) {
        ParsedNumber low;
        ParsedRangeScore score = new ParsedRangeScore(queryNumber);
        score.setSourcePointRange(true);
        if (queryNumber.isFractionalTrailer()) {
            score.setHasTrailingFraction(true);
        }
        if ((low = this.getLowEndpoint()).equals(queryNumber)) {
            score.setValid(true);
            score.setNumberFieldsMatched(low.getNumFields());
            score.setNumberMatched(low.getAddressNumberExists());
            score.setPrefixMatched(low.hasAddressPrefix());
            score.setSuffixMatched(low.hasAddressSuffix());
            score.setSuffixNumberMatched(low.getSuffixNumberExists());
            score.setTrailerMatched(low.hasAddressTrailer());
            score.setHyphenated(low.isHyphenatedNumber());
            this.setQueryScore(score);
            return score;
        }
        if (low.isPureNumeric() && queryNumber.isPureNumeric()) {
            if (low.getAddressNumber() == queryNumber.getAddressNumber()) {
                score.setValid(true);
                score.setNumberFieldsMatched(low.getNumFields());
                score.setNumberMatched(low.getAddressNumberExists());
                score.setPrefixMatched(low.hasAddressPrefix());
                score.setSuffixMatched(low.hasAddressSuffix());
                score.setSuffixNumberMatched(low.getSuffixNumberExists());
                score.setTrailerMatched(low.hasAddressTrailer());
                score.setHyphenated(low.isHyphenatedNumber());
                this.setQueryScore(score);
                return score;
            }
            score.setValid(true);
            score.setNumVaries(true);
            score.setVaryNumHigh(low.getAddressNumber());
            score.setVaryNumLow(low.getAddressNumber());
            score.setVaryNum(queryNumber.getAddressNumber());
            this.setQueryScore(score);
            return score;
        }
        if (queryNumber.isHyphenatedNumber()) {
            score.setHyphenated(true);
            score.setUnhyphenatedValue(ParsedNumber.computeUnhyphenatedNumber(queryNumber, this.m_low, this.m_high));
            if (!this.isHyphenated() && this.m_low.isPureNumeric() && queryNumber.getNumFields() == 3) {
                score.setNumVaries(true);
                score.setNumberMatched(true);
                score.setSuffixNumberMatched(true);
                score.setVaryNum(score.getUnhyphenatedValue());
                score.setVaryNumLow(this.m_low.getAddressNumber());
                score.setVaryNumHigh(this.m_high.getAddressNumber());
                score.setUseUnhyphenatedValue(true);
                score.setScoringNumber(new ParsedNumber(score.getVaryNum()));
                score.getScoringNumber().setPureNumeric();
                score.getScoringNumber().setHyphenatedNumber();
                this.setQueryScore(score);
                return score;
            }
        } else if (this.isHyphenated() && queryNumber.isPureNumeric()) {
            if (this.bHasPrefix || this.bHasSuffix || this.bHasTrailer) {
                score.setValid(false);
            } else {
                score.setNumVaries(true);
                ParsedNumber tmpNum = new ParsedNumber(queryNumber.getAddressNumber());
                ParsedNumber.computeHyphenatedNumber(tmpNum, queryNumber, this.m_low, this.m_high);
                long num = ParsedNumber.computeUnhyphenatedNumber(tmpNum, this.m_low, this.m_high);
                score.setNumberMatched(true);
                score.setVaryNum(num);
                score.setVaryNumLow(this.m_unhyphenatedLowValue);
                score.setVaryNumHigh(this.m_unhyphenatedHighValue);
                score.setScoringNumber(tmpNum);
            }
            this.setQueryScore(score);
            return score;
        }
        boolean bValidPrefix = true;
        boolean bValidNumber = true;
        boolean bValidSuffixNumber = true;
        boolean bValidSuffix = true;
        boolean bValidTrailer = true;
        int invalidFieldCount = 0;
        if (this.bHasNumber ^ queryNumber.getAddressNumberExists()) {
            bValidNumber = false;
            ++invalidFieldCount;
        }
        if (this.bHasSuffixNumber ^ queryNumber.getSuffixNumberExists()) {
            bValidSuffixNumber = false;
            ++invalidFieldCount;
        }
        if (this.bHasPrefix ^ queryNumber.hasAddressPrefix()) {
            bValidPrefix = false;
            ++invalidFieldCount;
        }
        if (this.bHasSuffix ^ queryNumber.hasAddressSuffix()) {
            bValidSuffix = false;
            ++invalidFieldCount;
        }
        if (this.bHasTrailer ^ queryNumber.hasAddressTrailer()) {
            bValidTrailer = false;
            ++invalidFieldCount;
        }
        boolean bMatchedPrefix = true;
        boolean bMatchedAddressNumber = true;
        boolean bMatchedSuffixNumber = true;
        boolean bMatchedSuffix = true;
        boolean bMatchedTrailer = true;
        boolean bMatchedPrefixSep = true;
        boolean bMatchedNumberSep = true;
        boolean bMatchedSuffixSep = true;
        boolean bMatchedTrailerSep = true;
        boolean bValidPrefixSep = true;
        boolean bValidNumberSep = true;
        boolean bValidSuffixSep = true;
        boolean bValidTrailerSep = true;
        if (this.bHasNumSeparator ^ queryNumber.hasNumberSeparator()) {
            bValidNumberSep = false;
            ++invalidFieldCount;
        }
        if (this.bHasPrefixSeparator ^ queryNumber.hasPrefixSeparator()) {
            bValidPrefixSep = false;
            ++invalidFieldCount;
        }
        if (this.bHasSuffixSeparator ^ queryNumber.hasSuffixSeparator()) {
            bValidSuffixSep = false;
            ++invalidFieldCount;
        }
        if (this.bHasTrailerSeparator ^ queryNumber.hasTrailerSeparator()) {
            bValidTrailerSep = false;
            ++invalidFieldCount;
        }
        int numberFieldsmatched = 0;
        boolean SepNotValid = !bValidNumberSep || !bValidPrefixSep || !bValidSuffixSep || !bValidTrailerSep;
        int fieldsNotMatchedCount = 0;
        if (low.getAddressNumber() != queryNumber.getAddressNumber()) {
            bMatchedAddressNumber = false;
            ++fieldsNotMatchedCount;
        }
        if (low.getSuffixNumber() != queryNumber.getSuffixNumber()) {
            bMatchedSuffixNumber = false;
            ++fieldsNotMatchedCount;
        }
        if (this.bHasPrefix && bValidPrefix && !StringUtilities.equalStrings(low.getAddressPrefix(), queryNumber.getAddressPrefix())) {
            bMatchedPrefix = false;
            ++fieldsNotMatchedCount;
        }
        if (this.bHasPrefixSeparator && bValidPrefixSep && !StringUtilities.equalStrings(low.getPrefixSeparator(), queryNumber.getPrefixSeparator())) {
            bMatchedPrefixSep = false;
            ++fieldsNotMatchedCount;
        }
        if (this.bHasSuffix && bValidSuffix && !StringUtilities.equalStrings(low.getAddressSuffix(), queryNumber.getAddressSuffix())) {
            bMatchedSuffix = false;
            ++fieldsNotMatchedCount;
        }
        if (this.bHasSuffixSeparator && bValidSuffixSep && !StringUtilities.equalStrings(low.getSuffixSeparator(), queryNumber.getSuffixSeparator())) {
            bMatchedSuffixSep = false;
            ++fieldsNotMatchedCount;
        }
        if (this.bHasTrailer && bValidTrailer && !StringUtilities.equalStrings(low.getAddressTrailer(), queryNumber.getAddressTrailer())) {
            bMatchedTrailer = false;
            ++fieldsNotMatchedCount;
        }
        if (this.bHasTrailerSeparator && bValidTrailerSep && !StringUtilities.equalStrings(low.getTrailerSeparator(), queryNumber.getTrailerSeparator())) {
            bMatchedTrailerSep = false;
            ++fieldsNotMatchedCount;
        }
        if (invalidFieldCount == 0) {
            if (fieldsNotMatchedCount != 0) {
                if (fieldsNotMatchedCount == 1) {
                    if (!bMatchedAddressNumber) {
                        score.setVaryNum(queryNumber.getAddressNumber());
                        score.setVaryNumLow(low.getAddressNumber());
                        score.setVaryNumHigh(low.getAddressNumber());
                        score.setNumVaries(true);
                    } else if (!bMatchedSuffixNumber) {
                        score.setVaryNum(queryNumber.getSuffixNumber());
                        score.setVaryNumLow(low.getSuffixNumber());
                        score.setVaryNumHigh(low.getSuffixNumber());
                        score.setNumVaries(true);
                    } else if (!bMatchedPrefix) {
                        score.setVaryString(queryNumber.getAddressPrefix());
                        score.setVaryStringLow(low.getAddressPrefix());
                        score.setVaryStringHigh(low.getAddressPrefix());
                        score.setStringVaries(true);
                    } else if (!bMatchedSuffix) {
                        score.setVaryString(queryNumber.getAddressSuffix());
                        score.setVaryStringLow(low.getAddressSuffix());
                        score.setVaryStringHigh(low.getAddressSuffix());
                        score.setStringVaries(true);
                    } else if (!bMatchedTrailer) {
                        score.setVaryString(queryNumber.getAddressTrailer());
                        score.setVaryStringLow(low.getAddressTrailer());
                        score.setVaryStringHigh(low.getAddressTrailer());
                        score.setStringVaries(true);
                    }
                    if (bMatchedAddressNumber) {
                        score.setNumberMatched(true);
                        ++numberFieldsmatched;
                    }
                    this.setQueryScore(score);
                    score.setNumberFieldsMatched(numberFieldsmatched);
                    return score;
                }
                score.setValid(false);
                return score;
            }
        } else if (invalidFieldCount == 1 || invalidFieldCount == 2 && SepNotValid) {
            if (fieldsNotMatchedCount == 0) {
                boolean bInvalid2OK = false;
                if (invalidFieldCount == 2 && queryNumber.hasNumberSeparator()) {
                    bInvalid2OK = true;
                }
                if (!(invalidFieldCount != 1 && !bInvalid2OK || this.bHasSuffixNumber || this.bHasTrailer || bValidSuffix || this.bHasSuffix)) {
                    score.setAddsSuffix(true);
                    score.setAddedString(queryNumber.getAddressSuffix());
                    this.setQueryScore(score);
                    if (invalidFieldCount == 2) {
                        ++numberFieldsmatched;
                    }
                } else if (!bValidTrailer && !this.bHasTrailer) {
                    score.setAddsTrailer(true);
                    score.setAddedString(queryNumber.getAddressTrailer());
                    this.setQueryScore(score);
                } else if (invalidFieldCount == 1 && !StringUtilities.equalStrings(low.getNumberSeparator(), queryNumber.getNumberSeparator())) {
                    if (this.bHasNumSeparator) {
                        score.getScoringNumber().setNumberSeparator(low.getSuffixSeparator());
                        score.getScoringNumber().setNumFields(low.getNumFields());
                        score.setNumberMatched(true);
                    } else {
                        score.getScoringNumber().setNumberSeparator(low.getNumberSeparator());
                        score.getScoringNumber().setNumFields(low.getNumFields());
                        score.setNumberMatched(true);
                    }
                } else if (invalidFieldCount == 1 && !StringUtilities.equalStrings(low.getPrefixSeparator(), queryNumber.getPrefixSeparator())) {
                    if (this.bHasPrefixSeparator) {
                        score.getScoringNumber().setPrefixSeparator(low.getPrefixSeparator());
                        score.getScoringNumber().setNumFields(low.getNumFields());
                        score.setPrefixMatched(true);
                    } else {
                        score.getScoringNumber().setPrefixSeparator(null);
                        score.getScoringNumber().setNumFields(low.getNumFields());
                        score.setPrefixMatched(true);
                    }
                } else if (invalidFieldCount == 1 && !StringUtilities.equalStrings(low.getSuffixSeparator(), queryNumber.getSuffixSeparator())) {
                    if (this.bHasSuffixSeparator) {
                        score.getScoringNumber().setSuffixSeparator(low.getSuffixSeparator());
                        score.getScoringNumber().setNumFields(low.getNumFields());
                        score.setSuffixMatched(true);
                    } else {
                        score.getScoringNumber().setSuffixSeparator(null);
                        score.getScoringNumber().setNumFields(low.getNumFields());
                        score.setSuffixMatched(true);
                    }
                } else if (!(invalidFieldCount != 1 || bValidPrefix && bValidSuffix)) {
                    if (this.setAbsentStringForParsedRangeScore(score, queryNumber, !bValidPrefix)) {
                        if (score.isPrefixAbsentFromInputNumber()) {
                            bMatchedPrefix = false;
                        }
                        if (score.isSuffixAbsentFromInputNumber()) {
                            bMatchedSuffix = false;
                        }
                    } else {
                        score.setValid(false);
                    }
                } else {
                    score.setValid(false);
                }
            } else {
                score.setValid(false);
            }
        } else if (invalidFieldCount == 2) {
            if (!bValidPrefix && !bValidSuffix) {
                if (this.bHasSuffix && queryNumber.hasAddressPrefix()) {
                    if (StringUtilities.equalStrings(low.getAddressSuffix(), queryNumber.getAddressPrefix())) {
                        if (fieldsNotMatchedCount == 0) {
                            score.setCheckSwappedPrefix(true);
                            score.getScoringNumber().setAddressSuffix(score.getScoringNumber().getAddressPrefix());
                            score.getScoringNumber().setAddressPrefix(null);
                        } else if (fieldsNotMatchedCount == 1) {
                            if (!bMatchedAddressNumber) {
                                score.setVaryNum(queryNumber.getAddressNumber());
                                score.setVaryNumLow(low.getAddressNumber());
                                score.setVaryNumHigh(low.getAddressNumber());
                                score.setNumVaries(true);
                            } else if (!bMatchedSuffixNumber) {
                                score.setVaryNum(queryNumber.getSuffixNumber());
                                score.setVaryNumLow(low.getSuffixNumber());
                                score.setVaryNumHigh(low.getSuffixNumber());
                                score.setNumVaries(true);
                            } else if (!bMatchedPrefix) {
                                score.setVaryString(queryNumber.getAddressPrefix());
                                score.setVaryStringLow(low.getAddressPrefix());
                                score.setVaryStringHigh(low.getAddressPrefix());
                                score.setStringVaries(true);
                            } else if (!bMatchedSuffix) {
                                score.setVaryString(queryNumber.getAddressSuffix());
                                score.setVaryStringLow(low.getAddressSuffix());
                                score.setVaryStringHigh(low.getAddressSuffix());
                                score.setStringVaries(true);
                            } else if (!bMatchedTrailer) {
                                score.setVaryString(queryNumber.getAddressTrailer());
                                score.setVaryStringLow(low.getAddressTrailer());
                                score.setVaryStringHigh(low.getAddressTrailer());
                                score.setStringVaries(true);
                            }
                        } else {
                            score.setValid(false);
                        }
                    } else {
                        if (fieldsNotMatchedCount == 0) {
                            score.setCheckSwappedPrefix(true);
                            score.getScoringNumber().setAddressSuffix(score.getScoringNumber().getAddressPrefix());
                            score.getScoringNumber().setAddressPrefix(null);
                            score.setVaryString(score.getScoringNumber().getAddressSuffix());
                            score.setVaryStringLow(low.getAddressSuffix());
                            score.setVaryStringHigh(low.getAddressSuffix());
                            score.setStringVaries(true);
                            if (bMatchedAddressNumber) {
                                score.setNumberMatched(true);
                                ++numberFieldsmatched;
                            }
                            this.setQueryScore(score);
                            score.setNumberFieldsMatched(numberFieldsmatched);
                            return score;
                        }
                        score.setValid(false);
                    }
                } else {
                    score.setValid(false);
                }
            } else {
                score.setValid(false);
            }
        } else {
            score.setValid(false);
        }
        if (bMatchedAddressNumber && this.bHasNumber) {
            score.setNumberMatched(true);
            ++numberFieldsmatched;
        }
        if (bMatchedPrefix && this.bHasPrefix) {
            score.setPrefixMatched(true);
            ++numberFieldsmatched;
        }
        if (bMatchedSuffix && this.bHasSuffix) {
            score.setSuffixMatched(true);
            ++numberFieldsmatched;
        }
        if (bMatchedSuffixNumber && this.bHasSuffixNumber) {
            score.setSuffixNumberMatched(true);
            ++numberFieldsmatched;
        }
        if (bMatchedTrailer && this.bHasTrailer) {
            score.setTrailerMatched(true);
            ++numberFieldsmatched;
        }
        if (score.isValid()) {
            this.setQueryScore(score);
        }
        score.setNumberFieldsMatched(numberFieldsmatched);
        return score;
    }

    public ParsedNumber getLowEndpoint() {
        return this.m_low;
    }

    public ParsedNumber getHighEndpoint() {
        return this.m_high;
    }

    public boolean isPointRange() {
        return this.bPointRange;
    }

    public boolean isHasPrefix() {
        return this.bHasPrefix;
    }

    public boolean isHasNumber() {
        return this.bHasNumber;
    }

    public boolean isHasSuffix() {
        return this.bHasSuffix;
    }

    public boolean isHasSuffixNumber() {
        return this.bHasSuffixNumber;
    }

    public boolean isHasTrailer() {
        return this.bHasTrailer;
    }

    public int getVaryingField() {
        return this.m_varyingField;
    }

    public String getVaryingStringLow() {
        return this.m_varyingStringLow;
    }

    public void setVaryingStringLow(String m_varyingStringLow) {
        this.m_varyingStringLow = m_varyingStringLow;
    }

    public String getVaryingStringHigh() {
        return this.m_varyingStringHigh;
    }

    public void setVaryingStringHigh(String m_varyingStringHigh) {
        this.m_varyingStringHigh = m_varyingStringHigh;
    }

    public long getVaryingNumLow() {
        return this.m_varyingNumLow;
    }

    public void setVaryingNumLow(long m_varyingNumLow) {
        this.m_varyingNumLow = m_varyingNumLow;
    }

    public long getVaryingNumHigh() {
        return this.m_varyingNumHigh;
    }

    public void setVaryingNumHigh(long m_varyingNumHigh) {
        this.m_varyingNumHigh = m_varyingNumHigh;
    }

    public boolean isMismatchedFractionalTrailers() {
        return this.m_bMismatchedFractionalTrailers;
    }

    public void setMismatchedFractionalTrailers(boolean m_bMismatchedFractionalTrailers) {
        this.m_bMismatchedFractionalTrailers = m_bMismatchedFractionalTrailers;
    }

    public boolean isHyphenated() {
        return this.bIsHyphenated;
    }

    public void setIsHyphenated(boolean bIsHyphenated) {
        this.bIsHyphenated = bIsHyphenated;
    }

    public long computeQueryDistance(ParsedNumber input) {
        return this.computeQueryDistance(input, true, true);
    }

    public long computeQueryDistance(ParsedNumber input, boolean bFromLow, boolean bFromHigh) {
        if (this.getQueryScore() == null || !this.getQueryScore().isValid()) {
            return Long.MAX_VALUE;
        }
        if (this.getQueryScore().isInRange()) {
            return 0L;
        }
        int field = this.getVaryingField();
        long lowOffset = 0L;
        long highOffset = 0L;
        long offsetFixed = 0L;
        int divisionFactor = 1;
        if (this.m_fixedPrefix != null && input.getAddressPrefix() != null) {
            offsetFixed = this.m_fixedPrefix.compareTo(input.getAddressPrefix());
        }
        if (this.m_fixedNumber != 0L && input.getAddressNumber() != 0L) {
            offsetFixed = this.m_fixedNumber - input.getAddressNumber();
        }
        if (this.m_fixedSuffix != null && input.getAddressSuffix() != null) {
            offsetFixed = this.m_fixedSuffix.compareTo(input.getAddressSuffix());
        }
        if (this.m_fixedSuffixNumber != 0L && input.getSuffixNumber() != 0L) {
            offsetFixed = this.m_fixedSuffixNumber - input.getSuffixNumber();
        }
        if (this.m_fixedTrailer != null && input.getAddressTrailer() != null) {
            offsetFixed = this.m_fixedTrailer.compareTo(input.getAddressTrailer());
        }
        switch (field) {
            case 1: {
                lowOffset = this.m_low.getAddressPrefix().compareTo(input.getAddressPrefix());
                highOffset = this.m_high.getAddressPrefix().compareTo(input.getAddressPrefix());
                break;
            }
            case 2: {
                lowOffset = (this.m_low.getAddressNumber() - input.getAddressNumber()) / (long)divisionFactor;
                highOffset = (this.m_high.getAddressNumber() - input.getAddressNumber()) / (long)divisionFactor;
                if (highOffset != 0L) break;
                if (this.getQueryScore().isAddsSuffix()) {
                    highOffset = "".compareTo(input.getAddressSuffix());
                    break;
                }
                if (!this.getQueryScore().isAddsTrailer()) break;
                if (input.isFractionalTrailer()) {
                    highOffset = 1L;
                    break;
                }
                highOffset = "".compareTo(input.getAddressTrailer());
                break;
            }
            case 3: {
                lowOffset = this.m_low.getAddressSuffix().compareTo(input.getAddressSuffix());
                highOffset = this.m_high.getAddressSuffix().compareTo(input.getAddressSuffix());
                break;
            }
            case 4: {
                lowOffset = (this.m_low.getSuffixNumber() - input.getSuffixNumber()) / (long)divisionFactor;
                highOffset = (this.m_high.getSuffixNumber() - input.getSuffixNumber()) / (long)divisionFactor;
                break;
            }
            case 5: {
                lowOffset = this.m_low.getAddressTrailer().compareTo(input.getAddressTrailer());
                highOffset = this.m_high.getAddressTrailer().compareTo(input.getAddressTrailer());
                break;
            }
            case 0: {
                if (this.getQueryScore().isNumVaries()) {
                    lowOffset = (this.getQueryScore().getVaryNumLow() - this.getQueryScore().getVaryNum()) / (long)divisionFactor;
                    highOffset = (this.getQueryScore().getVaryNumHigh() - this.getQueryScore().getVaryNum()) / (long)divisionFactor;
                    break;
                }
                if (this.getQueryScore().isStringVaries()) {
                    lowOffset = this.getQueryScore().getVaryStringLow().compareTo(this.getQueryScore().getVaryString());
                    highOffset = this.getQueryScore().getVaryStringHigh().compareTo(this.getQueryScore().getVaryString());
                    break;
                }
                if (offsetFixed != 0L) break;
                return 0L;
            }
        }
        if (lowOffset < 0L) {
            lowOffset *= -1L;
        }
        if (highOffset < 0L) {
            highOffset *= -1L;
        }
        if (offsetFixed < 0L) {
            offsetFixed *= -1L;
        }
        long value = 0L;
        if (bFromLow && bFromHigh) {
            value = Math.min(lowOffset, highOffset);
        } else if (bFromLow) {
            value = lowOffset;
        } else if (bFromHigh) {
            value = highOffset;
        }
        if (offsetFixed > value) {
            value = offsetFixed;
        }
        if (value == 0L) {
            return Long.MAX_VALUE;
        }
        return value;
    }

    public ParsedRangeScore getQueryScore() {
        return this.m_queryScore;
    }

    public void setQueryScore(ParsedRangeScore m_queryScore) {
        this.m_queryScore = m_queryScore;
    }

    private boolean setAbsentStringForParsedRangeScore(ParsedRangeScore rangeScore, ParsedNumber queryNumber, boolean bPrefix) {
        if (queryNumber.getNumFields() == this.m_low.getNumFields() - 1) {
            String absentStr;
            String string = absentStr = bPrefix ? this.m_fixedPrefix : this.m_fixedSuffix;
            if (StringUtilities.isEmpty(absentStr)) {
                absentStr = bPrefix ? this.m_low.getAddressPrefix() : this.m_low.getAddressSuffix();
            }
            rangeScore.setAbsentStringForInputNumber(absentStr);
            if (bPrefix) {
                rangeScore.setPrefixAbsentFromInputNumber(true);
                rangeScore.setPrefixMatched(false);
            } else {
                rangeScore.setSuffixAbsentFromInputNumber(true);
                rangeScore.setSuffixMatched(false);
            }
            return true;
        }
        return false;
    }
}

