/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common;

import com.mapinfo.mapmarker.CandidateRangeUnit;
import com.mapinfo.mapmarker.common.ParsedNumber;
import com.mapinfo.mapmarker.common.ParsedRange;
import com.mapinfo.mapmarker.common.ParsedRangeScore;
import com.mapinfo.mapmarker.common.ScoringAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class RangeUnit {
    private String m_lowUnit;
    private ParsedNumber m_parsedLowUnit;
    private String m_highUnit;
    private ParsedNumber m_parsedHighUnit;
    private ParsedRange m_parsedRange;
    private ParsedRangeScore m_parsedRangeScore;
    private String m_unitType;
    private String m_placeName;
    private boolean m_typeMatched;
    private long m_offset;
    private Map<String, String> m_additionalFields;

    public RangeUnit() {
        this.m_lowUnit = "";
        this.m_highUnit = "";
        this.m_unitType = "";
        this.m_placeName = null;
        this.m_parsedLowUnit = null;
        this.m_parsedHighUnit = null;
        this.m_typeMatched = false;
        this.m_offset = Long.MAX_VALUE;
    }

    public RangeUnit(String lowUnit, String highUnit, String unitType) {
        this.m_lowUnit = lowUnit;
        this.m_highUnit = highUnit;
        this.m_unitType = unitType;
        this.m_typeMatched = false;
        this.m_offset = Long.MAX_VALUE;
        this.m_placeName = null;
    }

    public RangeUnit(RangeUnit unit) {
        this();
        if (unit != null) {
            this.m_lowUnit = unit.m_lowUnit;
            this.m_highUnit = unit.m_highUnit;
            this.m_unitType = unit.m_unitType;
            this.m_typeMatched = unit.m_typeMatched;
            this.m_offset = unit.m_offset;
            this.m_placeName = unit.m_placeName;
        }
    }

    public void setParsedLowUnit(ParsedNumber unit) {
        this.m_parsedLowUnit = unit;
    }

    public void setParsedHighUnit(ParsedNumber unit) {
        this.m_parsedHighUnit = unit;
    }

    public void setLowUnit(String lowUnit) {
        this.m_lowUnit = lowUnit;
    }

    public void setLowUnit(int lowUnit) {
        this.m_lowUnit = Integer.toString(lowUnit);
        this.m_parsedLowUnit = new ParsedNumber(lowUnit);
    }

    public String getLowUnit() {
        return this.m_lowUnit;
    }

    public void setHighUnit(String highUnit) {
        this.m_highUnit = highUnit;
    }

    public void setHighUnit(int highUnit) {
        this.m_highUnit = Integer.toString(highUnit);
        this.m_parsedHighUnit = new ParsedNumber(highUnit);
    }

    public String getHighUnit() {
        return this.m_highUnit;
    }

    public void setUnitType(String unitType) {
        this.m_unitType = unitType;
    }

    public String getUnitType() {
        return this.m_unitType;
    }

    public void setPlaceName(String placeName) {
        this.m_placeName = placeName;
    }

    public String getPlaceName() {
        return this.m_placeName;
    }

    public void setTypeMatched() {
        this.m_typeMatched = true;
    }

    public boolean getTypeMatched() {
        return this.m_typeMatched;
    }

    public long getOffset() {
        return this.m_offset;
    }

    protected void setOffset(long offset) {
        this.m_offset = offset;
    }

    public long getNumberOfUnits() {
        ParsedNumber low = this.getParsedLowUnit();
        ParsedNumber high = this.getParsedHighUnit();
        if (high == null || low == null) {
            return 1L;
        }
        if (high.equals(low)) {
            return 1L;
        }
        return low.computeDifference(high, 1) + 1L;
    }

    public boolean isUnitInRange(ParsedNumber unitNumber, ParsedRangeScore rangeAddressScore) {
        if (this.getParsedRange() == null) {
            this.setParsedRange(new ParsedRange(this.getParsedLowUnit(), this.getParsedHighUnit()));
        }
        this.setParsedRangeScore(this.getParsedRange().scoreQueryNumber(unitNumber));
        if (this.getParsedRangeScore().isInRange() && !this.getParsedRangeScore().isCheckSwappedPrefix()) {
            this.m_offset = 0L;
            return true;
        }
        return false;
    }

    public long computeOffsetFromRangeUnit(ParsedNumber inputUnit, ScoringAddress parsedInputAddress, ParsedRangeScore rangeAddressScore) {
        if (this.getParsedRange() == null) {
            this.setParsedRange(new ParsedRange(this.getParsedLowUnit(), this.getParsedHighUnit()));
        }
        this.setParsedRangeScore(this.getParsedRange().scoreQueryNumber(inputUnit));
        this.m_offset = this.getParsedRange().computeQueryDistance(inputUnit);
        return this.getOffset();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("\n\tRangeUnit:\n");
        buffer.append("\t\tLow Unit: " + this.getLowUnit() + "\n");
        buffer.append("\t\tHigh Unit: " + this.getHighUnit() + "\n");
        buffer.append("\t\tUnit Type: " + this.getUnitType() + "\n");
        buffer.append("\t\tUnit PlaceName: " + this.getPlaceName() + "\n");
        buffer.append("\t\tOffset from input Unit: " + this.m_offset + "\n");
        return buffer.toString();
    }

    public CandidateRangeUnit toCandidateRangeUnit(ParsedNumber inputUnitNumber) {
        CandidateRangeUnit candRangeUnit = new CandidateRangeUnit();
        candRangeUnit.setLowUnitNumber(this.getParsedLowUnit() == null ? null : this.getParsedLowUnit().getCombinedAddressNumber());
        candRangeUnit.setHighUnitNumber(this.getParsedHighUnit() == null ? null : this.getParsedHighUnit().getCombinedAddressNumber());
        candRangeUnit.setUnitType(this.getUnitType());
        candRangeUnit.setPlaceName(this.getPlaceName());
        if (inputUnitNumber != null && this.isUnitInRange(inputUnitNumber, null)) {
            candRangeUnit.setOffset(0L);
        } else if (inputUnitNumber == null || inputUnitNumber.isEmpty()) {
            candRangeUnit.setOffset(Long.MIN_VALUE + this.getParsedLowUnit().getAddressNumber());
        } else {
            candRangeUnit.setOffset(this.computeOffsetFromRangeUnit(inputUnitNumber, null, null));
        }
        candRangeUnit.setUnitCount(this.getNumberOfUnits());
        HashMap<String, String> fields = candRangeUnit.getAdditionalFields();
        if (fields == null) {
            fields = new HashMap<String, String>();
            candRangeUnit.setAdditionalFields(fields);
        }
        fields.putAll(this.getAdditionalFields());
        return candRangeUnit;
    }

    public ParsedNumber getParsedLowUnit() {
        if (this.m_parsedLowUnit == null) {
            this.m_parsedLowUnit = new ParsedNumber(this.m_lowUnit);
        }
        return this.m_parsedLowUnit;
    }

    public ParsedNumber getParsedHighUnit() {
        if (this.m_parsedHighUnit == null) {
            this.m_parsedHighUnit = new ParsedNumber(this.m_highUnit);
        }
        return this.m_parsedHighUnit;
    }

    public ParsedRange getParsedRange() {
        return this.m_parsedRange;
    }

    public void setParsedRange(ParsedRange m_parsedRange) {
        this.m_parsedRange = m_parsedRange;
    }

    public ParsedRangeScore getParsedRangeScore() {
        return this.m_parsedRangeScore;
    }

    public void setParsedRangeScore(ParsedRangeScore m_parsedRangeScore) {
        this.m_parsedRangeScore = m_parsedRangeScore;
    }

    public void setAdditionalFields(Map<String, String> additionalFields) {
        this.m_additionalFields = additionalFields;
    }

    protected Map<String, String> getAdditionalFields() {
        if (this.m_additionalFields == null) {
            this.m_additionalFields = Collections.emptyMap();
        }
        return this.m_additionalFields;
    }
}

