/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common;

import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.AddressImpl;
import com.mapinfo.mapmarker.common.InternalBrowseAddress;
import com.mapinfo.mapmarker.common.ScoringAddress;
import com.mapinfo.mapmarker.common.StringScorer;
import com.mapinfo.mapmarker.utils.StringUtilities;

public class StreetCandidateAddress
extends AddressImpl {
    private boolean m_scored;
    private double m_countryScore;
    private double m_genericField1Score;
    private double m_genericField2Score;
    private double m_genericField3Score;
    private double m_genericField4Score;
    private double m_preAddressScore;
    private double m_preDirectionalScore;
    private double m_preThoroughfareTypeScore;
    private double m_mainAddressScore;
    private double m_postThoroughfareTypeScore;
    private double m_postDirectionalScore;
    private double m_postAddressScore;
    private int m_dictionaryNumber;
    private boolean m_fromUserDictionary;
    private long m_streetOffset;
    private long m_segmentBlockOffset;
    private static final StringScorer m_stringScorer = new StringScorer();
    private String m_charsToIgnore;
    private IConstraints m_constraints = null;
    private int m_matchingFlags;
    private int m_sac;
    private String m_vendorCode;

    public StreetCandidateAddress() {
    }

    public StreetCandidateAddress(Address addr) {
        super(addr);
        if (addr instanceof StreetCandidateAddress) {
            this.setIsScored(((StreetCandidateAddress)addr).isScored());
            this.setCountryScore(((StreetCandidateAddress)addr).getCountryScore());
            this.setGenericField1Score(((StreetCandidateAddress)addr).getGenericField1Score());
            this.setGenericField2Score(((StreetCandidateAddress)addr).getGenericField2Score());
            this.setGenericField3Score(((StreetCandidateAddress)addr).getGenericField3Score());
            this.setGenericField4Score(((StreetCandidateAddress)addr).getGenericField4Score());
            this.setPreAddressScore(((StreetCandidateAddress)addr).getPreAddressScore());
            this.setPreDirectionalScore(((StreetCandidateAddress)addr).getPreDirectionalScore());
            this.setPreThoroughfareTypeScore(((StreetCandidateAddress)addr).getPreThoroughfareTypeScore());
            this.setMainAddressScore(((StreetCandidateAddress)addr).getMainAddressScore());
            this.setPostThoroughfareTypeScore(((StreetCandidateAddress)addr).getPostThoroughfareTypeScore());
            this.setPostDirectionalScore(((StreetCandidateAddress)addr).getPostDirectionalScore());
            this.setPostAddressScore(((StreetCandidateAddress)addr).getPostAddressScore());
            this.setDictionaryNumber(((StreetCandidateAddress)addr).getDictionaryNumber());
            this.setFromUserDictionary(((StreetCandidateAddress)addr).fromUserDictionary());
            this.setStreetOffset(((StreetCandidateAddress)addr).getStreetOffset());
            this.setSegmentBlockOffset(((StreetCandidateAddress)addr).getSegmentBlockOffset());
            this.setCharsToIgnore(((StreetCandidateAddress)addr).getCharsToIgnore());
            this.setMatchingFlags(((StreetCandidateAddress)addr).getMatchingFlags());
            this.setConstraints(((StreetCandidateAddress)addr).getConstraints());
            this.setSAC(((StreetCandidateAddress)addr).getSAC());
        } else if (addr instanceof InternalBrowseAddress) {
            this.setVendorCode(((InternalBrowseAddress)addr).getVendorCode());
        }
    }

    public void setCountryScore(double score) {
        this.m_countryScore = score;
    }

    public double getCountryScore() {
        return this.m_countryScore;
    }

    public void setGenericField1Score(double score) {
        this.m_genericField1Score = score;
    }

    public double getGenericField1Score() {
        return this.m_genericField1Score;
    }

    public void setGenericField2Score(double score) {
        this.m_genericField2Score = score;
    }

    public double getGenericField2Score() {
        return this.m_genericField2Score;
    }

    public void setGenericField3Score(double score) {
        this.m_genericField3Score = score;
    }

    public double getGenericField3Score() {
        return this.m_genericField3Score;
    }

    public void setGenericField4Score(double score) {
        this.m_genericField4Score = score;
    }

    public double getGenericField4Score() {
        return this.m_genericField4Score;
    }

    public void setPreAddressScore(double score) {
        this.m_preAddressScore = score;
    }

    public double getPreAddressScore() {
        return this.m_preAddressScore;
    }

    public void setPreDirectionalScore(double score) {
        this.m_preDirectionalScore = score;
    }

    public double getPreDirectionalScore() {
        return this.m_preDirectionalScore;
    }

    public void setPreThoroughfareTypeScore(double score) {
        this.m_preThoroughfareTypeScore = score;
    }

    public double getPreThoroughfareTypeScore() {
        return this.m_preThoroughfareTypeScore;
    }

    public void setMainAddressScore(double score) {
        this.m_mainAddressScore = score;
    }

    public double getMainAddressScore() {
        return this.m_mainAddressScore;
    }

    public void setPostThoroughfareTypeScore(double score) {
        this.m_postThoroughfareTypeScore = score;
    }

    public double getPostThoroughfareTypeScore() {
        return this.m_postThoroughfareTypeScore;
    }

    public void setPostDirectionalScore(double score) {
        this.m_postDirectionalScore = score;
    }

    public double getPostDirectionalScore() {
        return this.m_postDirectionalScore;
    }

    public void setPostAddressScore(double score) {
        this.m_postAddressScore = score;
    }

    public double getPostAddressScore() {
        return this.m_postAddressScore;
    }

    public void setDictionaryNumber(int dictionaryNumber) {
        this.m_dictionaryNumber = dictionaryNumber;
    }

    public int getDictionaryNumber() {
        return this.m_dictionaryNumber;
    }

    public void setStreetOffset(long offset) {
        this.m_streetOffset = offset;
    }

    public long getStreetOffset() {
        return this.m_streetOffset;
    }

    public void setSegmentBlockOffset(long offset) {
        this.m_segmentBlockOffset = offset;
    }

    public long getSegmentBlockOffset() {
        return this.m_segmentBlockOffset;
    }

    public StringScorer getStringScorer() {
        return m_stringScorer;
    }

    public void setCharsToIgnore(String charsToIgnore) {
        this.m_charsToIgnore = charsToIgnore;
    }

    public String getCharsToIgnore() {
        return this.m_charsToIgnore;
    }

    public void score(ScoringAddress input) {
        this.setCountryScore(input.scoreCountry(this.getCountry()));
        this.setGenericField1Score(input.scoreGenericField1(this.getGenericField1()));
        this.setGenericField2Score(input.scoreGenericField2(this.getGenericField2()));
        this.setGenericField3Score(input.scoreGenericField3(this.getGenericField3()));
        this.setGenericField4Score(input.scoreGenericField4(this.getGenericField4()));
        this.setPreAddressScore(input.scorePreAddress(this.getPreAddress()));
        this.setPreDirectionalScore(input.getStringScorer().scoreString(input.getPreDirectional(), this.getPreDirectional(), this.getCharsToIgnore()));
        this.setPreThoroughfareTypeScore(input.scorePreThoroughfareType(this.getPreThoroughfareType()));
        this.setMainAddressScore(input.scoreMainAddress(this.getMainAddress()));
        this.setPostThoroughfareTypeScore(input.scorePostThoroughfareType(this.getPostThoroughfareType()));
        this.setPostDirectionalScore(input.getStringScorer().scoreString(input.getPostDirectional(), this.getPostDirectional(), this.getCharsToIgnore()));
        this.setPostAddressScore(input.scorePostAddress(this.getPostAddress()));
        this.setIsScored(true);
    }

    protected void setIsScored(boolean isScored) {
        this.m_scored = isScored;
    }

    public boolean isScored() {
        return this.m_scored;
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        String lineSeparator = System.getProperty("line.separator");
        buffer.append("StreetCandidateAddress:: ");
        buffer.append(lineSeparator);
        buffer.append(super.toString());
        buffer.append(lineSeparator);
        buffer.append("StreetOffset: ");
        buffer.append(this.getStreetOffset());
        buffer.append(lineSeparator);
        buffer.append("SegmentBlockOffset: ");
        buffer.append(this.getSegmentBlockOffset());
        buffer.append(lineSeparator);
        buffer.append(lineSeparator);
        if (this.isScored()) {
            buffer.append("Scores:");
            buffer.append(lineSeparator);
            buffer.append("\tCountry=");
            buffer.append(this.getCountryScore());
            buffer.append(lineSeparator);
            buffer.append("\tGenericFields:");
            buffer.append(lineSeparator);
            buffer.append("\t\t1=");
            buffer.append(this.getGenericField1Score());
            buffer.append(", 2=");
            buffer.append(this.getGenericField2Score());
            buffer.append(", 3=");
            buffer.append(this.getGenericField3Score());
            buffer.append(", 4=");
            buffer.append(this.getGenericField4Score());
            buffer.append(lineSeparator);
            buffer.append(lineSeparator);
            buffer.append("\tPreTypeScore=");
            buffer.append(this.getPreThoroughfareTypeScore());
            buffer.append(", PreDirScore=");
            buffer.append(this.getPreDirectionalScore());
            buffer.append(", PreAddressScore=");
            buffer.append(this.getPreAddressScore());
            buffer.append(lineSeparator);
            buffer.append("\tMainAddressScore=");
            buffer.append(this.getMainAddressScore());
            buffer.append(lineSeparator);
            buffer.append("\tPostTypeScore=");
            buffer.append(this.getPostThoroughfareTypeScore());
            buffer.append(", PostDirScore=");
            buffer.append(this.getPostDirectionalScore());
            buffer.append(", PostAddressScore=");
            buffer.append(this.getPostAddressScore());
            buffer.append(lineSeparator);
        } else {
            buffer.append("Not Scored.");
            buffer.append(lineSeparator);
        }
        buffer.append(lineSeparator);
        buffer.append("SAC: ");
        buffer.append(this.getSAC());
        buffer.append(lineSeparator);
        buffer.append(lineSeparator);
        buffer.append("From User Dictionary: ");
        buffer.append(this.fromUserDictionary());
        return buffer.toString();
    }

    public void setConstraints(IConstraints constraints) {
        this.m_constraints = constraints;
    }

    public IConstraints getConstraints() {
        return this.m_constraints;
    }

    public void setMatchingFlags(int flags) {
        this.m_matchingFlags = flags;
    }

    public void setMatchingFlag(int flag) {
        this.m_matchingFlags |= flag;
    }

    public int getMatchingFlags() {
        return this.m_matchingFlags;
    }

    public boolean isMatchingFlagSet(int flag) {
        return (this.m_matchingFlags & flag) == flag;
    }

    protected boolean fieldExists(String field) {
        return field != null && field.trim().length() != 0;
    }

    public void setFromUserDictionary(boolean fromUd) {
        this.m_fromUserDictionary = fromUd;
    }

    protected boolean fromUserDictionary() {
        return this.m_fromUserDictionary;
    }

    public void setSAC(int sac) {
        this.m_sac = sac;
    }

    public int getSAC() {
        return this.m_sac;
    }

    public boolean sameStreet(StreetCandidateAddress thatStreet) {
        if (!StringUtilities.equalStrings(this.getCountry(), thatStreet.getCountry())) {
            return false;
        }
        if (!StringUtilities.equalStrings(this.getGenericField1(), thatStreet.getGenericField1())) {
            return false;
        }
        if (!StringUtilities.equalStrings(this.getGenericField2(), thatStreet.getGenericField2())) {
            return false;
        }
        if (!StringUtilities.equalStrings(this.getGenericField3(), thatStreet.getGenericField3())) {
            return false;
        }
        if (!StringUtilities.equalStrings(this.getGenericField4(), thatStreet.getGenericField4())) {
            return false;
        }
        if (!StringUtilities.equalStrings(this.getPreAddress(), thatStreet.getPreAddress())) {
            return false;
        }
        if (!StringUtilities.equalStrings(this.getPreDirectional(), thatStreet.getPreDirectional())) {
            return false;
        }
        if (!StringUtilities.equalStrings(this.getPreThoroughfareType(), thatStreet.getPreThoroughfareType())) {
            return false;
        }
        if (!StringUtilities.equalStrings(this.getMainAddress(), thatStreet.getMainAddress())) {
            return false;
        }
        if (!StringUtilities.equalStrings(this.getPostThoroughfareType(), thatStreet.getPostThoroughfareType())) {
            return false;
        }
        if (!StringUtilities.equalStrings(this.getPostDirectional(), thatStreet.getPostDirectional())) {
            return false;
        }
        return StringUtilities.equalStrings(this.getPostAddress(), thatStreet.getPostAddress());
    }

    public String getVendorCode() {
        return this.m_vendorCode;
    }

    public void setVendorCode(String m_vendorCode) {
        this.m_vendorCode = m_vendorCode;
    }
}

