/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common;

import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.common.FieldScores;
import com.mapinfo.mapmarker.common.StreetCandidateAddress;

public class StreetCandidateAddressFilter {
    private FieldScores m_thresholds;

    public StreetCandidateAddressFilter(FieldScores thresholds) {
        this.m_thresholds = thresholds;
    }

    public boolean passes(StreetCandidateAddress address, IConstraints constraints) {
        if (!constraints.isReturnCloseCandidatesOnly()) {
            return this.meetsThresholds(address);
        }
        if ((constraints.isMustMatchMainAddress() || constraints.isMustMatchInput()) && (address.getPreDirectionalScore() != 1.0 || address.getPreThoroughfareTypeScore() != 1.0 || address.getMainAddressScore() != 1.0 || address.getPostThoroughfareTypeScore() != 1.0 || address.getPostDirectionalScore() != 1.0)) {
            return false;
        }
        return this.meetsThresholds(address);
    }

    protected boolean meetsThresholds(StreetCandidateAddress address) {
        if (this.getThresholds() == null) {
            return true;
        }
        if (address.getMainAddressScore() < this.getThresholds().getMainAddress()) {
            return false;
        }
        if (address.getPreDirectionalScore() < this.getThresholds().getPreDirectional()) {
            return false;
        }
        if (address.getPreThoroughfareTypeScore() < this.getThresholds().getPreThoroughfareType()) {
            return false;
        }
        if (address.getPostThoroughfareTypeScore() < this.getThresholds().getPostThoroughfareType()) {
            return false;
        }
        return !(address.getPostDirectionalScore() < this.getThresholds().getPostDirectional());
    }

    protected FieldScores getThresholds() {
        return this.m_thresholds;
    }
}

