/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp;

import com.mapinfo.mapmarker.utils.FileUtilities;
import java.io.IOException;
import java.util.HashMap;
import java.util.Properties;

public final class DataManagerSettingsProvider {
    public static final String CORE_SETTINGS = "CORE_SETTINGS";
    private static final String CORE_SETTINGS_FILE = "DataManagerSettings.properties";
    private static final String SETTINGS_FILE_BASE = "_DataManagerSettings.properties";
    public static final String DICTIONARY_COUNT_KEY = "DICTIONARY_COUNT";
    public static final String PARTIAL_DICTIONARY_PATH_KEY = "DICTIONARY_PATH";
    public static final String DO_NOT_PRE_INIT_PROPERTY = "DO_NOT_PRE_INIT";
    private HashMap m_countrySettings = new HashMap();
    private static DataManagerSettingsProvider m_provider;

    private DataManagerSettingsProvider() {
    }

    public static DataManagerSettingsProvider getInstance() {
        if (m_provider == null) {
            m_provider = new DataManagerSettingsProvider();
        }
        return m_provider;
    }

    public Properties getSettingsForCountry(String country) throws IOException {
        if (this.m_countrySettings.containsKey(country)) {
            return (Properties)this.m_countrySettings.get(country);
        }
        return this.loadSettingsForCountry(country);
    }

    public void setSettingsForCountry(String country, Properties dataSettings) {
        this.m_countrySettings.put(country, dataSettings);
    }

    private Properties loadSettingsForCountry(String country) throws IOException {
        Properties props = DataManagerSettingsProvider.getSettingsFileProperties(country);
        this.m_countrySettings.put(country, props);
        return props;
    }

    public static Properties convertPathsToSettings(String[] paths) {
        Properties props = new Properties();
        int dictCount = paths.length;
        props.put(DICTIONARY_COUNT_KEY, String.valueOf(dictCount));
        for (int i = 0; i < dictCount; ++i) {
            props.put(PARTIAL_DICTIONARY_PATH_KEY + (i + 1), paths[i]);
        }
        return props;
    }

    public static Properties getSettingsFileProperties(String country) throws IOException {
        if (CORE_SETTINGS.equalsIgnoreCase(country)) {
            return FileUtilities.loadProperties(CORE_SETTINGS_FILE);
        }
        return FileUtilities.loadProperties(country + SETTINGS_FILE_BASE);
    }

    public HashMap getSettingsForAllCountries() {
        return this.m_countrySettings;
    }
}

