/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp;

import com.mapinfo.mapmarker.common.dp.binary.ExceptionCodeToStringItem;
import com.mapinfo.mapmarker.utils.MapMarkerResourceLoader;
import java.util.Locale;

public class DataSourceException
extends Exception {
    public static final int UNKNOWN = -1;
    public static final int BOOLEAN = 0;
    public static final int BYTE = 1;
    public static final int CHAR = 2;
    public static final int DOUBLE = 3;
    public static final int FLOAT = 4;
    public static final int INT = 5;
    public static final int SHORT = 6;
    public static final int STRING = 7;
    public static final int GEOMETRY = 8;
    public static final int BAD_FIELD = 9;
    public static final int OPEN = 10;
    public static final int SETUP = 11;
    public static final int CLOSE = 12;
    public static final int ACCESS = 13;
    public static final int INTERMEDIATE = 14;
    public static final int METADATA = 15;
    public static final int UNMATCHED_FROM_TO = 16;
    public static final int INVALID_STATUS = 17;
    private ExceptionCodeToStringItem[] m_exceptionMap = new ExceptionCodeToStringItem[]{new ExceptionCodeToStringItem(-1, "err_unknown"), new ExceptionCodeToStringItem(0, "err_boolean"), new ExceptionCodeToStringItem(1, "err_byte"), new ExceptionCodeToStringItem(2, "err_char"), new ExceptionCodeToStringItem(3, "err_double"), new ExceptionCodeToStringItem(4, "err_float"), new ExceptionCodeToStringItem(5, "err_int"), new ExceptionCodeToStringItem(6, "err_short"), new ExceptionCodeToStringItem(7, "err_string"), new ExceptionCodeToStringItem(8, "err_geometry"), new ExceptionCodeToStringItem(9, "err_bad_field"), new ExceptionCodeToStringItem(10, "err_open"), new ExceptionCodeToStringItem(11, "err_setup"), new ExceptionCodeToStringItem(12, "err_close"), new ExceptionCodeToStringItem(13, "err_access"), new ExceptionCodeToStringItem(14, "err_intermediate"), new ExceptionCodeToStringItem(15, "err_metadata"), new ExceptionCodeToStringItem(16, "err_unmatched_from_to"), new ExceptionCodeToStringItem(17, "err_invalid_status")};
    private int m_code;
    protected String m_messageStringFile = "com.mapinfo.mapmarker.common.dp.DataSourceExceptionMessages";

    public DataSourceException(String exceptionCause) {
        this(-1, exceptionCause);
    }

    public DataSourceException(String exceptionCause, Throwable e) {
        this(-1, exceptionCause, e);
    }

    public DataSourceException(int exceptionCode) {
        this(exceptionCode, (String)null);
    }

    public DataSourceException(int exceptionCode, Throwable e) {
        this(exceptionCode, null, e);
    }

    public DataSourceException(int exceptionCode, String exceptionCause) {
        super(exceptionCause);
        this.m_code = exceptionCode;
    }

    public DataSourceException(int exceptionCode, String exceptionCause, Throwable e) {
        super(exceptionCause, e);
        this.m_code = exceptionCode;
    }

    public int getExceptionCode() {
        return this.m_code;
    }

    @Override
    public String getMessage() {
        String message = super.getMessage();
        String codeMessage = this.buildMessageFromExceptionCode();
        if (message != null) {
            if (codeMessage != null) {
                return codeMessage + ":\t" + message;
            }
            return message;
        }
        return codeMessage;
    }

    protected String buildMessageFromExceptionCode() {
        String messageKey = this.getMessageKeyFromCode();
        if (messageKey == null) {
            return "" + this.m_code;
        }
        String message = this.getMessageFromMessageKey(messageKey);
        if (message != null && message.trim().length() > 0) {
            return message;
        }
        return messageKey;
    }

    protected String getMessageKeyFromCode() {
        for (int i = 0; i < this.m_exceptionMap.length; ++i) {
            if (!this.m_exceptionMap[i].equals(this.m_code)) continue;
            return this.m_exceptionMap[i].getString();
        }
        return null;
    }

    protected String getMessageFromMessageKey(String messageKey) {
        return MapMarkerResourceLoader.loadForLocale(Locale.getDefault(), this.m_messageStringFile).getString(messageKey);
    }
}

