/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.binary;

import com.mapinfo.mapmarker.EngineInitModel;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.ISoundexKey;
import com.mapinfo.mapmarker.common.InternalCandidateAddress;
import com.mapinfo.mapmarker.common.InternalPBKeyCandidate;
import com.mapinfo.mapmarker.common.MiSoundexKey;
import com.mapinfo.mapmarker.common.dp.DataAccessException;
import com.mapinfo.mapmarker.common.dp.DataAccessRuntimeException;
import com.mapinfo.mapmarker.common.dp.binary.AlternateSearchTypeKey;
import com.mapinfo.mapmarker.common.dp.binary.DataDictionaryIntializationException;
import com.mapinfo.mapmarker.common.dp.binary.GenericAddressFetcher;
import com.mapinfo.mapmarker.common.dp.binary.GeoInfoFetcherImpl;
import com.mapinfo.mapmarker.common.dp.binary.IAddressFetcher;
import com.mapinfo.mapmarker.common.dp.binary.IDataDictionary;
import com.mapinfo.mapmarker.common.dp.binary.IGeoBase;
import com.mapinfo.mapmarker.common.dp.binary.IGeoInfoFetcher;
import com.mapinfo.mapmarker.common.dp.binary.IPostInfoFetcher;
import com.mapinfo.mapmarker.common.dp.binary.IPostalBase;
import com.mapinfo.mapmarker.common.dp.binary.IReverseGeocodeDataDictionary;
import com.mapinfo.mapmarker.common.dp.binary.MMJComplexDataFileMetadata;
import com.mapinfo.mapmarker.common.dp.binary.MMJDataFileMetadata;
import com.mapinfo.mapmarker.common.dp.binary.MMJEDataCorruptedException;
import com.mapinfo.mapmarker.common.dp.binary.MMJGeo2SacData;
import com.mapinfo.mapmarker.common.dp.binary.MMJGeo2SacRecord;
import com.mapinfo.mapmarker.common.dp.binary.MMJPost2SacData;
import com.mapinfo.mapmarker.common.dp.binary.MMJPost2SacRecord;
import com.mapinfo.mapmarker.common.dp.binary.MMJSac2FnData;
import com.mapinfo.mapmarker.common.dp.binary.PostInfoFetcherImpl;
import com.mapinfo.mapmarker.common.dp.binary.QuickInitMMJGeo2SacData;
import com.mapinfo.mapmarker.common.dp.binary.QuickInitMMJPost2SacData;
import com.mapinfo.mapmarker.common.dp.binary.SacData;
import com.mapinfo.mapmarker.common.dp.binary.SacFileData;
import com.mapinfo.mapmarker.common.dp.binary.SacMetadata;
import com.mapinfo.mapmarker.common.dp.binary.StandardGeo2SacRecord;
import com.mapinfo.mapmarker.common.dp.binary.StandardPost2SacRecord;
import com.mapinfo.mapmarker.common.dp.binary.StreetMetaDataCache;
import com.mapinfo.mapmarker.common.dp.binary.index.IMapMarkerReadOnlyIndexFile;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerAlternateIndexFileHelper;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerMultiLevelReadOnlyIndexFile;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerStreetBrowseIndexFileHelper;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerStreetIndexFileHelper;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerStreetMultiLevelIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.PBKeyReadOnlyIndexFile;
import com.mapinfo.mapmarker.common.dp.index.spatial.IRGIndex;
import com.mapinfo.mapmarker.common.dp.index.spatial.IRGIterator;
import com.mapinfo.mapmarker.common.dp.index.spatial.IndexUtils;
import com.mapinfo.mapmarker.common.dp.index.spatial.binary.CompositeRGIndex;
import com.mapinfo.mapmarker.common.dp.index.spatial.binary.DiskRGIndex;
import com.mapinfo.mapmarker.common.dp.index.spatial.binary.SpatialIndexValue;
import com.mapinfo.mapmarker.common.dp.index.spatial.binary.SpatialIndexValueEnvelopeDecorator;
import com.mapinfo.mapmarker.common.dp.index.spatial.binary.SpatialIndexValuePersistenceDecorator;
import com.mapinfo.mapmarker.utils.IntArray;
import com.mapinfo.mapmarker.utils.LRUHashMapCache;
import com.mapinfo.mapmarker.utils.SeekableDataInput;
import com.mapinfo.mapmarker.utils.StringUtilities;
import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.unit.Length;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.FilterInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public abstract class AbstractDataDictionary
implements IDataDictionary,
IReverseGeocodeDataDictionary {
    private static final String NO_DICTIONARY_PATH = "exception.no.data.path";
    private static final String NO_POST2SAC_FILE = "exception.no.post2sac";
    private static final String POST2SAC_FILE_OPEN = "exception.open.post2sac";
    private static final String NO_SAC2FN_FILE = "exception.no.sac2fn";
    private static final String SAC2FN_FILE_OPEN = "exception.open.sac2fn";
    protected static final String NO_GEO2SAC_FILE = "exception.no.geo2sac";
    protected static final String GEO2SAC_FILE_OPEN = "exception.open.geo2sac";
    protected static final String PBKEY_INDEX_OPEN = "exception.open.pbkey";
    private static final String PARTIAL_DICTIONARY_PATH_KEY = "DICTIONARY_PATH";
    protected static final String STREET_DATA_FILE_CACHE_COUNT = "setting.street.data.cache.count";
    private static final int DEFAULT_STREET_DATA_FILE_CACHE_COUNT = 10;
    protected static final String STREET_INDEX_FILE_CACHE_COUNT = "setting.street.index.cache.count";
    private static final int DEFAULT_STREET_INDEX_FILE_CACHE_COUNT = 10;
    private static final int USER_DICTIONARY_DEFAULT_STREET_DATA_FILE_CACHE_COUNT = 1;
    private static final int USER_DICTIONARY_DEFAULT_STREET_INDEX_FILE_CACHE_COUNT = 1;
    private int m_dictionaryNumber;
    private Properties m_dataManagerSettings;
    private String m_dictionaryPath;
    private boolean m_isUserDictionary;
    private MMJSac2FnData m_sac2fnData;
    private MMJPost2SacData m_post2sacData;
    private MMJGeo2SacData m_geo2sacData;
    private IGeoInfoFetcher m_geoInfoFetcher;
    private IPostInfoFetcher m_postInfoFetcher;
    private IAddressFetcher m_addressFetcher;
    private byte[] m_alternateSearchTypes;
    private byte[] m_alternateBrowseTypes;
    private StreetMetaDataCache m_streetCache;
    private LRUHashMapCache m_streetIndexCache;
    private LRUHashMapCache m_streetBrowseIndexCache;
    private LRUHashMapCache m_alternateStreetBrowseIndexCache;
    private LRUHashMapCache m_alternateStreetSearchIndexCache;
    private IRGIndex<SpatialIndexValue> m_streetRGIndex;
    private IMapMarkerReadOnlyIndexFile m_pbKeyIndex;
    protected static int FAKE_SAC = Integer.MAX_VALUE;
    public static final String ALT_DATA_FILE_NAME = "alt.mmj";

    public AbstractDataDictionary(int dictionaryNumber, Properties dataManagerSettings) throws DataDictionaryIntializationException {
        this.m_dictionaryNumber = dictionaryNumber;
        this.m_dataManagerSettings = dataManagerSettings;
        this.m_isUserDictionary = false;
        String path = this.m_dataManagerSettings.getProperty(PARTIAL_DICTIONARY_PATH_KEY + (this.m_dictionaryNumber + 1));
        if (path == null || path.trim().length() == 0) {
            throw new DataDictionaryIntializationException(NO_DICTIONARY_PATH);
        }
        this.m_dictionaryPath = StringUtilities.appendToPath(path, null);
        this.m_sac2fnData = this.initSac2FnData();
        this.m_post2sacData = this.initPost2SacData();
        this.m_geo2sacData = this.initGeo2SacData();
        this.initAlternateIndexTypes();
        this.m_geoInfoFetcher = this.initGeoInfoFetcher();
        this.m_postInfoFetcher = this.initPostInfoFetcher();
        this.m_addressFetcher = this.initAddressFetcher();
        this.initStreetDataFileCache();
        this.initStreetIndexFileCaches();
        this.m_streetRGIndex = this.initStreetRGIndex();
        this.m_pbKeyIndex = this.initPBKeyIndex();
    }

    protected final Properties getDataManagerSettings() {
        return this.m_dataManagerSettings;
    }

    @Override
    public final String getDictionaryPath() {
        return this.m_dictionaryPath;
    }

    protected MMJGeo2SacData getGeo2sacData() {
        return this.m_geo2sacData;
    }

    protected MMJPost2SacRecord getPost2SacRecordType() {
        return new StandardPost2SacRecord();
    }

    protected boolean isPost2SacRequired() {
        return true;
    }

    protected MMJPost2SacData initPost2SacData() throws DataDictionaryIntializationException {
        MMJPost2SacData data = null;
        try {
            data = EngineInitModel.useQuickInit() ? new QuickInitMMJPost2SacData(this.getPost2SacRecordType(), new SacMetadata(), this.m_dictionaryPath) : new MMJPost2SacData(this.getPost2SacRecordType(), new SacMetadata(), this.m_dictionaryPath);
        }
        catch (FileNotFoundException e) {
            if (this.isPost2SacRequired()) {
                throw new DataDictionaryIntializationException(NO_POST2SAC_FILE, e);
            }
        }
        catch (IOException e) {
            throw new DataDictionaryIntializationException(POST2SAC_FILE_OPEN, e);
        }
        catch (MMJEDataCorruptedException e) {
            throw new DataDictionaryIntializationException(POST2SAC_FILE_OPEN, e);
        }
        return data;
    }

    protected MMJGeo2SacRecord getGeo2SacRecordType() {
        return new StandardGeo2SacRecord();
    }

    protected boolean isGeo2SacRequired() {
        return true;
    }

    protected MMJGeo2SacData initGeo2SacData() throws DataDictionaryIntializationException {
        MMJGeo2SacData data = null;
        try {
            data = EngineInitModel.useQuickInit() ? new QuickInitMMJGeo2SacData(this.getGeo2SacRecordType(), new SacMetadata(), this.m_dictionaryPath) : new MMJGeo2SacData(this.getGeo2SacRecordType(), new SacMetadata(), this.m_dictionaryPath);
        }
        catch (FileNotFoundException e) {
            if (this.isGeo2SacRequired()) {
                throw new DataDictionaryIntializationException(NO_GEO2SAC_FILE, e);
            }
        }
        catch (IOException e) {
            throw new DataDictionaryIntializationException(GEO2SAC_FILE_OPEN, e);
        }
        catch (MMJEDataCorruptedException e) {
            throw new DataDictionaryIntializationException(GEO2SAC_FILE_OPEN, e);
        }
        return data;
    }

    protected boolean isSac2FnRequired() {
        return true;
    }

    protected MMJSac2FnData initSac2FnData() throws DataDictionaryIntializationException {
        MMJSac2FnData data = null;
        try {
            data = new MMJSac2FnData(this.m_dictionaryPath);
            if (data.forUserDictionary()) {
                this.m_isUserDictionary = true;
            }
        }
        catch (FileNotFoundException e) {
            if (this.isSac2FnRequired()) {
                throw new DataDictionaryIntializationException(NO_SAC2FN_FILE, e);
            }
        }
        catch (IOException e) {
            throw new DataDictionaryIntializationException(SAC2FN_FILE_OPEN, e);
        }
        return data;
    }

    protected IMapMarkerReadOnlyIndexFile initPBKeyIndex() throws DataDictionaryIntializationException {
        PBKeyReadOnlyIndexFile index = null;
        String pbKeyIndexFileName = this.getPBKeyIndexFileName();
        if (pbKeyIndexFileName == null) {
            return null;
        }
        try {
            index = new PBKeyReadOnlyIndexFile();
            index.open(StringUtilities.appendToPath(this.m_dictionaryPath, pbKeyIndexFileName));
            return index;
        }
        catch (FileNotFoundException FNFEx) {
            return null;
        }
        catch (IOException IOEx) {
            throw new DataDictionaryIntializationException(PBKEY_INDEX_OPEN, IOEx);
        }
    }

    protected String getPBKeyIndexFileName() {
        return null;
    }

    @Override
    public IMapMarkerReadOnlyIndexFile getPBKeyIndex() {
        return this.m_pbKeyIndex;
    }

    @Override
    public InternalPBKeyCandidate makePBKeyCandidate(InternalCandidateAddress address) {
        return new InternalPBKeyCandidate(address);
    }

    protected final void setAlternateBrowseTypes(byte[] alternateBrowseTypes) {
        this.m_alternateBrowseTypes = alternateBrowseTypes;
    }

    protected final void setAlternateSearchTypes(byte[] alternateSearchTypes) {
        this.m_alternateSearchTypes = alternateSearchTypes;
    }

    protected void initAlternateIndexTypes() throws DataDictionaryIntializationException {
        FilterInputStream altTypesFile = null;
        try {
            int altSearchCount;
            altTypesFile = new DataInputStream(new BufferedInputStream(new FileInputStream(StringUtilities.appendToPath(this.m_dictionaryPath, ALT_DATA_FILE_NAME))));
            int altBrowseCount = ((DataInputStream)altTypesFile).readInt();
            if (altBrowseCount > 0) {
                byte[] altBrowseTypes = new byte[altBrowseCount];
                ((DataInputStream)altTypesFile).readFully(altBrowseTypes);
                this.setAlternateBrowseTypes(altBrowseTypes);
            }
            if ((altSearchCount = ((DataInputStream)altTypesFile).readInt()) > 0) {
                byte[] altSearchTypes = new byte[altSearchCount];
                ((DataInputStream)altTypesFile).readFully(altSearchTypes);
                this.setAlternateSearchTypes(altSearchTypes);
            }
        }
        catch (FileNotFoundException altBrowseCount) {
        }
        catch (IOException e) {
            throw new DataDictionaryIntializationException(e);
        }
        finally {
            if (altTypesFile != null) {
                try {
                    altTypesFile.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected IGeoInfoFetcher initGeoInfoFetcher() throws DataDictionaryIntializationException {
        return new GeoInfoFetcherImpl(this.getDictionaryPath(), this.getDataManagerSettings(), null);
    }

    protected IPostInfoFetcher initPostInfoFetcher() throws DataDictionaryIntializationException {
        return new PostInfoFetcherImpl(this.getDictionaryPath(), this.getDataManagerSettings(), null);
    }

    protected IAddressFetcher initAddressFetcher() {
        return new GenericAddressFetcher(this.getDataManagerSettings(), null);
    }

    protected final void setStreetDataFileCache(StreetMetaDataCache cache) {
        this.m_streetCache = cache;
    }

    protected void initStreetDataFileCache() {
        int cacheCount;
        block6: {
            String cacheCountString = this.getDataManagerSettings().getProperty(STREET_DATA_FILE_CACHE_COUNT);
            cacheCount = 10;
            if (cacheCountString != null) {
                try {
                    cacheCount = Integer.parseInt(cacheCountString);
                }
                catch (NumberFormatException NFEx) {
                    if (!this.m_isUserDictionary) {
                        cacheCount = 10;
                        break block6;
                    }
                    cacheCount = 1;
                }
            } else if (this.m_isUserDictionary) {
                cacheCount = 1;
            }
        }
        this.setStreetDataFileCache(new StreetMetaDataCache(cacheCount));
    }

    protected final void setStreetIndexFileCache(LRUHashMapCache cache) {
        this.m_streetIndexCache = cache;
    }

    protected final void setStreetBrowseIndexFileCache(LRUHashMapCache cache) {
        this.m_streetBrowseIndexCache = cache;
    }

    protected final void setAlternateStreetBrowseIndexCache(LRUHashMapCache cache) {
        this.m_alternateStreetBrowseIndexCache = cache;
    }

    protected final void setAlternateStreetSearchIndexCache(LRUHashMapCache cache) {
        this.m_alternateStreetSearchIndexCache = cache;
    }

    protected void initStreetIndexFileCaches() {
        int cacheCount;
        boolean supportsAlternateSearch;
        boolean supportsAlternateBrowse;
        block10: {
            supportsAlternateBrowse = this.getAlternateBrowseTypesSupported() != null;
            supportsAlternateSearch = this.getAlternateSearchTypesSupported() != null;
            String cacheCountString = this.getDataManagerSettings().getProperty(STREET_INDEX_FILE_CACHE_COUNT);
            cacheCount = 10;
            if (cacheCountString != null) {
                try {
                    cacheCount = Integer.parseInt(cacheCountString);
                }
                catch (NumberFormatException NFEx) {
                    if (!this.m_isUserDictionary) {
                        cacheCount = 10;
                        break block10;
                    }
                    cacheCount = 1;
                }
            } else if (this.m_isUserDictionary) {
                cacheCount = 1;
            }
        }
        this.setStreetIndexFileCache(new LRUHashMapCache(cacheCount));
        this.setStreetBrowseIndexFileCache(new LRUHashMapCache(cacheCount));
        if (supportsAlternateBrowse) {
            this.setAlternateStreetBrowseIndexCache(new LRUHashMapCache(cacheCount));
        } else {
            this.setAlternateStreetBrowseIndexCache(null);
        }
        if (supportsAlternateSearch) {
            this.setAlternateStreetSearchIndexCache(new LRUHashMapCache(cacheCount));
        } else {
            this.setAlternateStreetSearchIndexCache(null);
        }
    }

    protected IRGIndex<SpatialIndexValue> initStreetRGIndex() {
        File dataDir = new File(this.getDictionaryPath());
        String[] streetRGIndexFiles = dataDir.list(new StreetRGIndexFilenameFilter());
        if (streetRGIndexFiles != null && streetRGIndexFiles.length > 0) {
            SpatialIndexValueEnvelopeDecorator geometryDecorator = new SpatialIndexValueEnvelopeDecorator();
            ArrayList<IRGIndex<DiskRGIndex<SpatialIndexValue>>> indexes = new ArrayList<IRGIndex<DiskRGIndex<SpatialIndexValue>>>(streetRGIndexFiles.length);
            for (String fileName : streetRGIndexFiles) {
                File f = new File(StringUtilities.appendToPath(this.getDictionaryPath(), fileName));
                String dataFileBaseName = fileName.substring(0, fileName.length() - 1 - "spx".length());
                SpatialIndexValuePersistenceDecorator fileDecorator = new SpatialIndexValuePersistenceDecorator(dataFileBaseName);
                try {
                    indexes.add(new DiskRGIndex<SpatialIndexValue>(f, fileDecorator, geometryDecorator));
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
            }
            return new CompositeRGIndex<SpatialIndexValue>(indexes);
        }
        return null;
    }

    protected final void setIsUserDictionary(boolean flag) {
        this.m_isUserDictionary = flag;
    }

    @Override
    public final boolean isUserDictionary() {
        return this.m_isUserDictionary;
    }

    @Override
    public final int getDictionaryNumber() {
        return this.m_dictionaryNumber;
    }

    @Override
    public final IGeoInfoFetcher getGeoInfoFetcher() {
        return this.m_geoInfoFetcher;
    }

    @Override
    public final IPostInfoFetcher getPostInfoFetcher() {
        return this.m_postInfoFetcher;
    }

    @Override
    public final IAddressFetcher getAddressFetcher() {
        return this.m_addressFetcher;
    }

    protected final byte[] getAlternateBrowseTypesSupported() {
        return this.m_alternateBrowseTypes;
    }

    protected MapMarkerIndexKey[] getAlternateBrowseBases(byte alternateType, Address addr, IConstraints constraints) {
        return null;
    }

    @Override
    public AlternateSearchTypeKey[] getAlternateBrowseTypeKeys(Address addr, IConstraints constraints) {
        ArrayList<AlternateSearchTypeKey> alternateBrowseKeys = new ArrayList<AlternateSearchTypeKey>();
        byte[] alternateBrowseTypes = this.getAlternateBrowseTypesSupported();
        if (alternateBrowseTypes != null) {
            int alternateBrowseTypesCount = alternateBrowseTypes.length;
            for (int i = 0; i < alternateBrowseTypesCount; ++i) {
                MapMarkerIndexKey[] altBrowseBases = this.getAlternateBrowseBases(alternateBrowseTypes[i], addr, constraints);
                if (altBrowseBases == null) continue;
                int altBaseCount = altBrowseBases.length;
                for (int j = 0; j < altBaseCount; ++j) {
                    AlternateSearchTypeKey key = new AlternateSearchTypeKey((byte)i, altBrowseBases[j]);
                    alternateBrowseKeys.add(key);
                }
            }
        }
        AlternateSearchTypeKey[] retArray = new AlternateSearchTypeKey[alternateBrowseKeys.size()];
        return alternateBrowseKeys.toArray(retArray);
    }

    protected final byte[] getAlternateSearchTypesSupported() {
        return this.m_alternateSearchTypes;
    }

    protected MapMarkerIndexKey[] getAlternateSearchBases(byte alternateType, Address addr, IConstraints constraints) {
        return null;
    }

    @Override
    public AlternateSearchTypeKey[] getAlternateSearchTypeKeys(Address addr, IConstraints constraints) {
        ArrayList<AlternateSearchTypeKey> alternateSearchKeys = new ArrayList<AlternateSearchTypeKey>();
        byte[] alternateSearchTypes = this.getAlternateSearchTypesSupported();
        if (alternateSearchTypes != null) {
            int alternateSearchTypesCount = alternateSearchTypes.length;
            for (int i = 0; i < alternateSearchTypesCount; ++i) {
                MapMarkerIndexKey[] altSearchBases = this.getAlternateSearchBases(alternateSearchTypes[i], addr, constraints);
                if (altSearchBases == null) continue;
                int altBaseCount = altSearchBases.length;
                for (int j = 0; j < altBaseCount; ++j) {
                    AlternateSearchTypeKey key = new AlternateSearchTypeKey((byte)i, altSearchBases[j]);
                    alternateSearchKeys.add(key);
                }
            }
        }
        if (!alternateSearchKeys.isEmpty()) {
            AlternateSearchTypeKey[] retArray = new AlternateSearchTypeKey[alternateSearchKeys.size()];
            return alternateSearchKeys.toArray(retArray);
        }
        return null;
    }

    @Override
    public MMJDataFileMetadata getStreetMetadataObject() {
        return new MMJComplexDataFileMetadata();
    }

    @Override
    public final SeekableDataInput getStreetDataFile(String fileName, MMJDataFileMetadata metadata) throws IOException {
        return this.m_streetCache.getDataFile(StringUtilities.appendToPath(this.m_dictionaryPath, fileName, ".jdr"), metadata);
    }

    protected IMapMarkerReadOnlyIndexFile getStreetIndexFileType() {
        return new MapMarkerMultiLevelReadOnlyIndexFile(new MapMarkerStreetIndexFileHelper());
    }

    protected IMapMarkerReadOnlyIndexFile getStreetBrowseIndexFileType() {
        return new MapMarkerMultiLevelReadOnlyIndexFile(new MapMarkerStreetBrowseIndexFileHelper());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IMapMarkerReadOnlyIndexFile getStreetIndexFile(String dataFileBaseName) throws IOException {
        IMapMarkerReadOnlyIndexFile index;
        String path = StringUtilities.appendToPath(this.getDictionaryPath(), dataFileBaseName, ".jdx");
        LRUHashMapCache lRUHashMapCache = this.m_streetIndexCache;
        synchronized (lRUHashMapCache) {
            index = (IMapMarkerReadOnlyIndexFile)this.m_streetIndexCache.get(path);
            if (index == null) {
                index = this.getStreetIndexFileType();
                index.open(path);
                this.m_streetIndexCache.put(path, index);
            }
        }
        return index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IMapMarkerReadOnlyIndexFile getStreetBrowseIndexFile(String dataFileBaseName) throws IOException {
        IMapMarkerReadOnlyIndexFile index;
        String path = StringUtilities.appendToPath(this.getDictionaryPath(), dataFileBaseName, ".bdx");
        LRUHashMapCache lRUHashMapCache = this.m_streetBrowseIndexCache;
        synchronized (lRUHashMapCache) {
            index = (IMapMarkerReadOnlyIndexFile)this.m_streetBrowseIndexCache.get(path);
            if (index == null) {
                index = this.getStreetBrowseIndexFileType();
                index.open(path);
                this.m_streetBrowseIndexCache.put(path, index);
            }
        }
        return index;
    }

    protected String getAlternateStreetBrowseIndexExtension(byte alternateBrowseType) {
        return null;
    }

    protected IMapMarkerReadOnlyIndexFile getAlternateStreetBrowseIndexFileType(byte alternateBrowseType) {
        return new MapMarkerMultiLevelReadOnlyIndexFile(new MapMarkerStreetBrowseIndexFileHelper());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IMapMarkerReadOnlyIndexFile getAlternateStreetBrowseIndexFile(byte alternateBrowseType, String dataFileBaseName) throws IOException {
        IMapMarkerReadOnlyIndexFile index;
        String indexExtension = this.getAlternateStreetBrowseIndexExtension(alternateBrowseType);
        if (indexExtension == null) {
            return null;
        }
        String indexFileName = StringUtilities.appendToPath(this.getDictionaryPath(), dataFileBaseName, indexExtension);
        LRUHashMapCache lRUHashMapCache = this.m_alternateStreetBrowseIndexCache;
        synchronized (lRUHashMapCache) {
            index = (IMapMarkerReadOnlyIndexFile)this.m_alternateStreetBrowseIndexCache.get(indexFileName);
            if (index == null) {
                index = this.getAlternateStreetBrowseIndexFileType(alternateBrowseType);
                index.open(indexFileName);
                this.m_alternateStreetBrowseIndexCache.put(indexFileName, index);
            }
        }
        return index;
    }

    protected String getAlternateStreetSearchIndexExtension(byte alternateSearchType) {
        return null;
    }

    protected IMapMarkerReadOnlyIndexFile getAlternateStreetSearchIndexFileType(byte alternateSearchType) {
        return new MapMarkerMultiLevelReadOnlyIndexFile(new MapMarkerAlternateIndexFileHelper());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IMapMarkerReadOnlyIndexFile getAlternateStreetSearchIndexFile(byte alternateSearchType, String dataFileBaseName) throws IOException {
        IMapMarkerReadOnlyIndexFile index;
        String indexExtension = this.getAlternateStreetSearchIndexExtension(alternateSearchType);
        if (indexExtension == null) {
            return null;
        }
        String indexFileName = StringUtilities.appendToPath(this.getDictionaryPath(), dataFileBaseName, indexExtension);
        LRUHashMapCache lRUHashMapCache = this.m_alternateStreetSearchIndexCache;
        synchronized (lRUHashMapCache) {
            index = (IMapMarkerReadOnlyIndexFile)this.m_alternateStreetSearchIndexCache.get(indexFileName);
            if (index == null) {
                index = this.getAlternateStreetSearchIndexFileType(alternateSearchType);
                index.open(indexFileName);
                this.m_alternateStreetSearchIndexCache.put(indexFileName, index);
            }
        }
        return index;
    }

    protected abstract IPostalBase[] getPostalBases(Address var1, IConstraints var2);

    protected abstract IGeoBase[] getGeoBases(Address var1, IConstraints var2);

    protected List getPostalSacs(Address addr, IConstraints constraints) {
        IPostalBase[] postalBases;
        ArrayList<SacData> sacList = new ArrayList<SacData>();
        if (this.m_post2sacData != null && (postalBases = this.getPostalBases(addr, constraints)) != null && postalBases.length != 0) {
            for (int i = 0; i < postalBases.length; ++i) {
                SacData sacData = this.m_post2sacData.getSacForPostalBase(postalBases[i]);
                if (sacData == null) continue;
                sacList.add(sacData);
            }
        }
        return sacList;
    }

    protected IGeoBase[] getAlternateGeoBases(Address addr, IConstraints constraints, int alternateType) {
        return null;
    }

    protected List getGeoSacs(Address addr, IConstraints constraints) {
        ArrayList<SacData> sacList = new ArrayList<SacData>();
        if (this.m_geo2sacData != null) {
            int alternateType = 0;
            IGeoBase[] geoBases = this.getGeoBases(addr, constraints);
            while (geoBases != null && geoBases.length != 0) {
                for (int i = 0; i < geoBases.length; ++i) {
                    SacData sacData = this.m_geo2sacData.getSacForGeoBase(geoBases[i]);
                    if (sacData == null) continue;
                    sacList.add(sacData);
                }
                if (!sacList.isEmpty()) break;
                geoBases = this.getAlternateGeoBases(addr, constraints, alternateType++);
            }
        }
        return sacList;
    }

    @Override
    public int[] getSacList(Address addr, IConstraints constraints, boolean bDoIntersectionOnly) {
        int[] sacs;
        SacData sacData;
        IntArray sacList = new IntArray();
        List postalSacs = this.getPostalSacs(addr, constraints);
        List geoSacs = this.getGeoSacs(addr, constraints);
        int postalSacCount = postalSacs.size();
        for (int i = 0; i < postalSacCount; ++i) {
            sacData = (SacData)postalSacs.get(i);
            if (sacData == null) continue;
            sacs = sacData.getSacs();
            int sacCount = sacs.length;
            for (int j = 0; j < sacCount; ++j) {
                if (sacList.contains(sacs[j])) continue;
                sacList.add(sacs[j]);
            }
        }
        if (this.isUserDictionary() && !sacList.contains(FAKE_SAC)) {
            sacList.add(FAKE_SAC);
        }
        IntArray intersectionList = null;
        if (bDoIntersectionOnly) {
            intersectionList = new IntArray();
        }
        int geoSacCount = geoSacs.size();
        for (int i = 0; i < geoSacCount; ++i) {
            sacData = (SacData)geoSacs.get(i);
            if (sacData == null) continue;
            sacs = sacData.getSacs();
            int sacCount = sacs.length;
            for (int j = 0; j < sacCount; ++j) {
                if (bDoIntersectionOnly) {
                    if (!sacList.contains(sacs[j]) || intersectionList.contains(sacs[j])) continue;
                    intersectionList.add(sacs[j]);
                    continue;
                }
                if (sacList.contains(sacs[j])) continue;
                sacList.add(sacs[j]);
            }
        }
        if (bDoIntersectionOnly) {
            return intersectionList.asArray();
        }
        return sacList.asArray();
    }

    @Override
    public SacFileData getSearchAreaFiles(int sac) {
        if (this.m_sac2fnData == null) {
            return null;
        }
        return this.m_sac2fnData.getFnForSac(sac);
    }

    protected String[] getStreetDataFileNames() {
        return this.m_sac2fnData.getStreetDataFileNames();
    }

    @Override
    public MapMarkerIndexKey makeStreetIndexKey(ISoundexKey key, int sac) {
        return new MapMarkerStreetMultiLevelIndexKey(sac, (MiSoundexKey)key);
    }

    protected byte getMaximumAlternateType(byte[] alternateTypes) {
        byte max = -1;
        if (alternateTypes != null) {
            for (int i = 0; i < alternateTypes.length; ++i) {
                if (alternateTypes[i] <= max) continue;
                max = alternateTypes[i];
            }
        }
        return max;
    }

    @Override
    public void close() throws DataAccessException {
        if (this.m_postInfoFetcher != null) {
            this.m_postInfoFetcher.close();
            this.m_postInfoFetcher = null;
        }
        if (this.m_geoInfoFetcher != null) {
            this.m_geoInfoFetcher.close();
            this.m_geoInfoFetcher = null;
        }
    }

    @Override
    public IRGIterator<SpatialIndexValue> getStreetRGIterator(DirectPosition position, Length searchDistance) throws DataAccessRuntimeException {
        if (this.m_streetRGIndex == null) {
            return new EmptyRGIterator();
        }
        return this.m_streetRGIndex.search(IndexUtils.createRect(position, searchDistance));
    }

    private static class StreetRGIndexFilenameFilter
    implements FilenameFilter {
        private StreetRGIndexFilenameFilter() {
        }

        @Override
        public boolean accept(File dir, String filename) {
            return filename != null && filename.endsWith(".spx");
        }
    }

    protected static class EmptyRGIterator
    implements IRGIterator<SpatialIndexValue> {
        protected EmptyRGIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public SpatialIndexValue next() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void close() {
        }
    }
}

