/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.binary;

import com.mapinfo.mapmarker.Constraints;
import com.mapinfo.mapmarker.DictionaryUsagePreference;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.ICountryGeographyInfo;
import com.mapinfo.mapmarker.common.IDictionarySearchOrder;
import com.mapinfo.mapmarker.common.ISoundexKey;
import com.mapinfo.mapmarker.common.InternalBrowseAddress;
import com.mapinfo.mapmarker.common.InternalCandidateAddress;
import com.mapinfo.mapmarker.common.InternalPBKeyCandidate;
import com.mapinfo.mapmarker.common.ScoringAddress;
import com.mapinfo.mapmarker.common.StreetCandidateAddress;
import com.mapinfo.mapmarker.common.StreetCandidateAddressFilter;
import com.mapinfo.mapmarker.common.dp.DataAccessException;
import com.mapinfo.mapmarker.common.dp.DataAccessRuntimeException;
import com.mapinfo.mapmarker.common.dp.FatalDataAccessException;
import com.mapinfo.mapmarker.common.dp.FatalDataAccessRuntimeException;
import com.mapinfo.mapmarker.common.dp.IDataManager;
import com.mapinfo.mapmarker.common.dp.IReverseGeocodeDataManager;
import com.mapinfo.mapmarker.common.dp.binary.AlternateDataRecord;
import com.mapinfo.mapmarker.common.dp.binary.AlternateSearchTypeKey;
import com.mapinfo.mapmarker.common.dp.binary.IDataDictionary;
import com.mapinfo.mapmarker.common.dp.binary.IReverseGeocodeDataDictionary;
import com.mapinfo.mapmarker.common.dp.binary.LocalizationException;
import com.mapinfo.mapmarker.common.dp.binary.MMJDataFileMetadata;
import com.mapinfo.mapmarker.common.dp.binary.MMJEDataCorruptedException;
import com.mapinfo.mapmarker.common.dp.binary.SacFileData;
import com.mapinfo.mapmarker.common.dp.binary.index.IMapMarkerReadOnlyIndexFile;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerBrowseMultiLevelIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexMultiValue;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexValue;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerStreetMultiLevelIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MiStringIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.PBKeyIndexValue;
import com.mapinfo.mapmarker.common.dp.binary.index.StreetDataIndexValue;
import com.mapinfo.mapmarker.common.dp.index.spatial.IRGIterator;
import com.mapinfo.mapmarker.common.dp.index.spatial.binary.SpatialIndexValue;
import com.mapinfo.mapmarker.core.CoreRetrievedCandidates;
import com.mapinfo.mapmarker.core.IRetrievedCandidates;
import com.mapinfo.mapmarker.core.reverseGeocode.ReverseGeocodeUtils;
import com.mapinfo.mapmarker.licensing.LicenseFilter;
import com.mapinfo.mapmarker.user.ReverseGeocodeLocation;
import com.mapinfo.mapmarker.utils.CoordConvertor;
import com.mapinfo.mapmarker.utils.DebugLevel;
import com.mapinfo.mapmarker.utils.FileProviderFactory;
import com.mapinfo.mapmarker.utils.MMJLog;
import com.mapinfo.mapmarker.utils.MapMarkerResourceLoader;
import com.mapinfo.mapmarker.utils.SeekableDataInput;
import com.mapinfo.mapmarker.utils.StringUtilities;
import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.unit.Length;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;

public abstract class AbstractDataManager
implements IDataManager,
IReverseGeocodeDataManager {
    public static final String LSTRING_FILE = "com.mapinfo.mapmarker.common.dp.binary.DataManagerMessageStrings";
    public static final String LSETTING_FILE = "DataManagerSettings.properties";
    public static final String NO_SACS_FOR_LOCATION_MSG = "exception.data.no.sacs.for.location";
    public static final String NO_DATA_FOR_SAC_MSG = "exception.data.no.data.for.sac";
    public static final String NO_STREET_BASES_FOR_STREET_MSG = "exception.address.no.base.for.street";
    public static final String NO_POSTAL_BASES_FOR_PCENT_MSG = "exception.centroid.no.base.for.postal";
    public static final String NO_GEO_BASES_FOR_GCENT_MSG = "exception.centroid.no.base.for.geo";
    public static final String FILE_ACCESS_DENIED_MSG = "warning.file.access.denied";
    public static final String INFO_RETURNINGCANDIDATES_MSG = "info.returning.candidates";
    public static final String INFO_CHECKINGFILE_MSG = "info.checking.file";
    public static final String TYPE_ARRAY_SIZE_EXCEEDED_MSG = "exception.type.array.size.exceeded";
    public static final String NO_GEOINFO_FILES = "exception.centroid.no.geoinfo";
    public static final String NO_POSTINFO_FILES = "exception.centroid.no.postinfo";
    public static final String NO_GEO_INDEX_MATCHES = "exception.centroid.no.geoinfo.index.entry";
    public static final String NO_DICTIONARIES_FOUND = "message.no.dictionaries.found";
    public static final String NO_USER_DICTIONARIES_FOUND = "message.no.user.dictionaries.found";
    public static final String NO_ADDRESS_DICTIONARIES_FOUND = "message.no.address.dictionaries.found";
    public static final String KEY_SAC_MUSTMATCH_GEO_AND_POSTAL = "KEY_SAC_MUSTMATCH_GEO_AND_POSTAL";
    public static final int INDEX_NOT_FOUND = -1;
    private StreetCandidateAddressFilter m_streetFilter;

    public abstract IDataDictionary getDictionary(int var1);

    public abstract int getDictionaryCount();

    protected DictionaryIterator getDictionariesIterator(IConstraints constraints) {
        ArrayList<Dictionary> dictionaries = new ArrayList<Dictionary>();
        IDictionarySearchOrder order = constraints.getDictionarySearchOrder();
        DictionaryUsagePreference usage = constraints.getDictionaryUsage();
        for (int i = 0; i < this.getDictionaryCount(); ++i) {
            IDataDictionary dictionary;
            if (order != null && !order.isDictionaryAvailableForSearch(i + 1) || (dictionary = this.getDictionary(i)).isUserDictionary() && usage == DictionaryUsagePreference.AD_ONLY || !dictionary.isUserDictionary() && usage == DictionaryUsagePreference.UD_ONLY) continue;
            if (order == null) {
                dictionaries.add(new Dictionary(i, i + 1, dictionary));
                continue;
            }
            dictionaries.add(new Dictionary(i, order.getSearchOrderForDictionary(i + 1), dictionary));
        }
        Collections.sort(dictionaries);
        return new DictionaryIterator(dictionaries.iterator());
    }

    @Override
    public IRetrievedCandidates retrieveCandidates(Address pa, ScoringAddress scoringAddress, IConstraints preferences) throws DataAccessException, FatalDataAccessException {
        LicenseFilter filter;
        IRetrievedCandidates result;
        boolean foundStreetBase = true;
        boolean foundStreetSac = true;
        DataAccessException streetCandidateException = null;
        DataAccessException altStreetCandidateException = null;
        ResourceBundle rb = null;
        int[] saclist = null;
        boolean bSacsMustmatchGeoAndPostal = "true".equalsIgnoreCase(preferences.getCustomString(KEY_SAC_MUSTMATCH_GEO_AND_POSTAL));
        ArrayList candList = new ArrayList();
        int numDicts = this.getDictionaryCount();
        int debugLevel = DebugLevel.getDebugLevel(3);
        boolean foundUsableDictionary = false;
        IDictionarySearchOrder order = preferences.getDictionarySearchOrder();
        IDataDictionary dict = null;
        for (int dictNum = 0; dictNum < numDicts; ++dictNum) {
            if (order != null && !order.isDictionaryAvailableForSearch(dictNum + 1) || (!(dict = this.getDictionary(dictNum)).isUserDictionary() || preferences.getDictionaryUsage() == DictionaryUsagePreference.AD_ONLY) && (dict.isUserDictionary() || preferences.getDictionaryUsage() == DictionaryUsagePreference.UD_ONLY)) continue;
            foundUsableDictionary = true;
            ISoundexKey[] streetbases = dict.makeStreetBases(pa, preferences);
            AlternateSearchTypeKey[] alternateBases = dict.getAlternateSearchTypeKeys(pa, preferences);
            if (streetbases == null && alternateBases == null) {
                foundStreetBase = false;
                continue;
            }
            saclist = dict.getSacList(pa, preferences, bSacsMustmatchGeoAndPostal);
            if (saclist.length == 0) {
                foundStreetSac = false;
                continue;
            }
            if (streetbases != null) {
                try {
                    candList.addAll(this.getStreetCandidates(streetbases, saclist, preferences, dict, debugLevel, scoringAddress));
                }
                catch (DataAccessException e) {
                    streetCandidateException = e;
                }
            }
            if (alternateBases == null) continue;
            try {
                candList.addAll(this.getAlternateStreetCandidates(alternateBases, saclist, preferences, dict, debugLevel, scoringAddress));
                continue;
            }
            catch (DataAccessException e) {
                altStreetCandidateException = e;
            }
        }
        if (candList == null || candList.isEmpty()) {
            if (streetCandidateException != null) {
                throw streetCandidateException;
            }
            if (altStreetCandidateException != null) {
                throw altStreetCandidateException;
            }
            if (!foundUsableDictionary) {
                throw new DataAccessException(2103);
            }
        }
        if (debugLevel >= 3) {
            if (rb == null) {
                rb = AbstractDataManager.loadBundleForLocale(preferences, LSTRING_FILE);
            }
            MMJLog.getLog().debug(rb.getString(INFO_RETURNINGCANDIDATES_MSG) + candList.size());
        }
        if ((result = this.buildRetrievedCandidates(candList)).getCandidates().size() > 0 && (filter = this.getLicenseFilter()) != null && (result = filter.filterCandidates(result, 0)).getCandidates().size() == 0) {
            result.setDataLicensed(false);
        }
        return result;
    }

    @Override
    public IRetrievedCandidates retrieveBrowseAddresses(Address pa, IConstraints preferences) throws DataAccessException, FatalDataAccessException {
        LicenseFilter filter;
        IRetrievedCandidates result;
        boolean foundStreetBaseForStreet = true;
        boolean foundStreetSac = true;
        DataAccessException browseException = null;
        DataAccessException altBrowseException = null;
        int[] sacList = null;
        boolean bSacsMustmatchGeoAndPostal = "true".equalsIgnoreCase(preferences.getCustomString(KEY_SAC_MUSTMATCH_GEO_AND_POSTAL));
        ArrayList browseList = new ArrayList();
        int debugLevel = DebugLevel.getDebugLevel(3);
        boolean foundUsableDictionary = false;
        DictionaryIterator dictIterator = this.getDictionariesIterator(preferences);
        while (dictIterator.hasNext()) {
            foundUsableDictionary = true;
            IDataDictionary dict = dictIterator.next().getDictionary();
            MapMarkerIndexKey[] browseBases = dict.makeBrowseBases(pa, preferences);
            AlternateSearchTypeKey[] alternateBases = dict.getAlternateBrowseTypeKeys(pa, preferences);
            if (browseBases == null && alternateBases == null) {
                foundStreetBaseForStreet = false;
                continue;
            }
            sacList = dict.getSacList(pa, preferences, bSacsMustmatchGeoAndPostal);
            if (sacList.length == 0) {
                foundStreetSac = false;
                continue;
            }
            if (browseBases != null) {
                try {
                    browseList.addAll(this.getBrowseAddresses(browseBases, sacList, preferences, dict, debugLevel));
                }
                catch (DataAccessException e) {
                    browseException = e;
                }
            }
            if (alternateBases == null) continue;
            try {
                browseList.addAll(this.getAlternateBrowseAddresses(alternateBases, sacList, preferences, dict, debugLevel));
            }
            catch (DataAccessException e) {
                altBrowseException = e;
            }
        }
        if (browseList == null || browseList.size() == 0) {
            if (browseException != null) {
                throw browseException;
            }
            if (altBrowseException != null) {
                throw altBrowseException;
            }
            if (!foundStreetBaseForStreet) {
                throw new DataAccessException(2105);
            }
            if (!foundUsableDictionary) {
                throw new DataAccessException(2103);
            }
        }
        if ((result = this.buildRetrievedCandidates(browseList)).getCandidates().size() > 0 && (filter = this.getLicenseFilter()) != null && (result = filter.filterCandidates(result, 1)).getCandidates().size() == 0) {
            result.setDataLicensed(false);
        }
        return result;
    }

    /*
     * Exception decompiling
     */
    @Override
    public IRetrievedCandidates retrievePostalCentroids(Address pa, IConstraints preferences) throws DataAccessException, FatalDataAccessException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public IRetrievedCandidates retrieveGeographicCentroids(Address pa, IConstraints preferences) throws FatalDataAccessException, DataAccessException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public ICountryGeographyInfo getCountryGeographyInfo() {
        ICountryGeographyInfo infos = this.getCountryGeographyInfoObject();
        int dictionaryCount = this.getDictionaryCount();
        for (int i = 0; i < dictionaryCount; ++i) {
            infos.addDictionaryGeographicInfo(this.getDictionary(i).getDictionaryGeographyInfo());
        }
        return infos;
    }

    @Override
    public IRetrievedCandidates getPBKeyCandidates(Address addr, IConstraints constraints) throws DataAccessException, FatalDataAccessException {
        IRetrievedCandidates candidates = this.buildRetrievedCandidates(null);
        String pbKey = addr.getGenericField1();
        if (StringUtilities.isEmpty(pbKey)) {
            return candidates;
        }
        MiStringIndexKey key = new MiStringIndexKey(pbKey);
        DictionaryIterator dictIterator = this.getDictionariesIterator(constraints);
        IDataDictionary dictionary = null;
        PBKeyIndexValue value = null;
        while (dictIterator.hasNext()) {
            SeekableDataInput dataFile;
            dictionary = dictIterator.next().getDictionary();
            IMapMarkerReadOnlyIndexFile index = dictionary.getPBKeyIndex();
            if (index == null) continue;
            try {
                value = (PBKeyIndexValue)index.search(key);
            }
            catch (IOException IOEx) {
                throw new FatalDataAccessException(2102, (Throwable)IOEx);
            }
            if (value == null) continue;
            MMJDataFileMetadata metadata = dictionary.getStreetMetadataObject();
            try {
                dataFile = dictionary.getStreetDataFile(value.getFileName(), metadata);
            }
            catch (IOException IOEx) {
                throw new FatalDataAccessException(2102, (Throwable)IOEx);
            }
            ArrayList<InternalPBKeyCandidate> candList = null;
            try {
                List altStreetResults = this.getAlternateStreetData(dictionary, dataFile, value, metadata);
                if (altStreetResults == null || altStreetResults.isEmpty()) continue;
                candList = new ArrayList<InternalPBKeyCandidate>();
                for (AlternateStreetResult altResult : altStreetResults) {
                    StreetCandidateAddress street = altResult.getStreet();
                    street.setConstraints(constraints);
                    street.setFromUserDictionary(dictionary.isUserDictionary());
                    List altCandidates = dictionary.getAddressFetcher().makeAlternateStreetCandidates(street, dataFile, altResult.getAlternateRecord(), metadata, dictionary, constraints);
                    if (altCandidates == null || altCandidates.isEmpty()) continue;
                    Iterator altsIterator = altCandidates.iterator();
                    while (altsIterator.hasNext()) {
                        candList.add(dictionary.makePBKeyCandidate((InternalCandidateAddress)altsIterator.next()));
                    }
                }
            }
            catch (LocalizationException LEx) {
                throw new FatalDataAccessException(2101, (Throwable)LEx);
            }
            catch (MMJEDataCorruptedException MMJEDCEx) {
                throw new FatalDataAccessException(2101, (Throwable)MMJEDCEx);
            }
            catch (IOException IOEx) {
                throw new FatalDataAccessException(2102, (Throwable)IOEx);
            }
            finally {
                try {
                    FileProviderFactory.getFileProvider().release(dataFile);
                    continue;
                }
                catch (IOException iOException) {}
            }
            candidates = this.buildRetrievedCandidates(candList);
            LicenseFilter filter = this.getLicenseFilter();
            if (filter == null || (candidates = filter.filterCandidates(candidates, 0)).getCandidates().size() != 0) break;
            candidates.setDataLicensed(false);
            break;
        }
        return candidates;
    }

    protected abstract LicenseFilter getLicenseFilter();

    protected void setStreetFilter(StreetCandidateAddressFilter streetFilter) {
        this.m_streetFilter = streetFilter;
    }

    protected StreetCandidateAddressFilter getStreetFilter() {
        if (this.m_streetFilter == null) {
            this.m_streetFilter = new StreetCandidateAddressFilter(null);
        }
        return this.m_streetFilter;
    }

    protected IRetrievedCandidates buildRetrievedCandidates(List candidates) {
        return new CoreRetrievedCandidates(candidates);
    }

    protected List getStreetCandidates(ISoundexKey[] streetBases, int[] sacList, IConstraints preferences, IDataDictionary dict, int debugLevel, ScoringAddress scoringAddress) throws DataAccessException, FatalDataAccessException {
        boolean foundStreetDataForSac = true;
        int missingDataSac = -1;
        boolean foundData = true;
        FileNotFoundException missingDataException = null;
        ArrayList candList = new ArrayList();
        MMJDataFileMetadata metadata = null;
        block18: for (int n = 0; n < sacList.length; ++n) {
            SacFileData sac2FnEntry = dict.getSearchAreaFiles(sacList[n]);
            if (debugLevel >= 3) {
                MMJLog.getLog().debug("sac is " + sacList[n]);
                MMJLog.getLog().debug("files is " + sac2FnEntry);
            }
            if (sac2FnEntry == null) {
                if (dict.isUserDictionary()) continue;
                foundStreetDataForSac = false;
                missingDataSac = sacList[n];
                continue;
            }
            String streetfile = sac2FnEntry.getStreetFileName();
            metadata = dict.getStreetMetadataObject();
            if (debugLevel >= 3) {
                MMJLog.getLog().debug("street file name is " + streetfile);
            }
            int totalStreetBases = streetBases.length;
            for (int i = 0; i < totalStreetBases; ++i) {
                long ptr;
                if (debugLevel >= 3) {
                    MMJLog.getLog().debug("streetBase is " + streetBases[i].toString());
                }
                try {
                    ptr = this.getStreetDataLocation(dict, sacList[n], streetBases[i], streetfile, dict.getDictionaryPath());
                }
                catch (FileNotFoundException e) {
                    if (debugLevel >= 1) {
                        MMJLog.getLog().debug("Unable to find index file for: " + streetfile, (Throwable)e);
                    }
                    foundData = false;
                    continue block18;
                }
                catch (IOException e) {
                    throw new FatalDataAccessException(2102, (Throwable)e);
                }
                if (ptr == -1L) continue;
                List streets = null;
                SeekableDataInput file = null;
                try {
                    int streetCount;
                    file = dict.getStreetDataFile(streetfile, metadata);
                    streets = dict.getAddressFetcher().getStreetData(file, ptr, metadata);
                    int n2 = streetCount = streets == null ? 0 : streets.size();
                    if (debugLevel >= 1) {
                        MMJLog.getLog().debug("Found " + streetCount + " street(s) for input.");
                    }
                    for (int str = 0; str < streetCount; ++str) {
                        StreetCandidateAddress street = (StreetCandidateAddress)streets.get(str);
                        street.setSAC(sacList[n]);
                        if (debugLevel >= 3) {
                            MMJLog.getLog().debug("PreScored: " + street.toString());
                        }
                        street.setConstraints(preferences);
                        street.score(scoringAddress);
                        if (debugLevel >= 2) {
                            MMJLog.getLog().debug(street.toString());
                            MMJLog.getLog().debug("Scored against: " + scoringAddress.toString());
                        }
                        if (this.getStreetFilter().passes(street, preferences)) {
                            street.setFromUserDictionary(dict.isUserDictionary());
                            candList.addAll(dict.getAddressFetcher().makeStreetCandidates(street, file, metadata, dict, preferences));
                            continue;
                        }
                        if (debugLevel < 1) continue;
                        MMJLog.getLog().debug("StreetCandidateAddress does not pass filter.");
                        MMJLog.getLog().debug(street.toString());
                        MMJLog.getLog().debug("Scored against: " + scoringAddress.toString());
                    }
                    continue;
                }
                catch (FileNotFoundException FNFex) {
                    foundData = false;
                    missingDataException = FNFex;
                    continue block18;
                }
                catch (IOException noDataEx) {
                    throw new FatalDataAccessException(2102, (Throwable)noDataEx);
                }
                catch (LocalizationException LEx) {
                    throw new FatalDataAccessException(2100, (Throwable)LEx);
                }
                catch (MMJEDataCorruptedException MMJEDCEx) {
                    throw new FatalDataAccessException(2101, (Throwable)MMJEDCEx);
                }
                finally {
                    if (file != null) {
                        try {
                            FileProviderFactory.getFileProvider().release(file);
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        }
        if (candList == null || candList.isEmpty()) {
            if (!foundData && missingDataException != null) {
                throw new DataAccessException(2107, missingDataException);
            }
        } else {
            int dictNum = dict.getDictionaryNumber();
            IDictionarySearchOrder order = preferences.getDictionarySearchOrder();
            for (InternalCandidateAddress cand : candList) {
                cand.setDictionaryPriority(dictNum);
                if (order != null) {
                    cand.setUserDictionaryPriority(order.getSearchOrderForDictionary(dictNum + 1));
                    continue;
                }
                cand.setUserDictionaryPriority(dictNum + 1);
            }
        }
        return candList;
    }

    protected long getStreetDataLocation(IDataDictionary dict, int sac, ISoundexKey base, String streetFileName, String path) throws IOException {
        MapMarkerIndexKey key;
        IMapMarkerReadOnlyIndexFile indexFile = dict.getStreetIndexFile(streetFileName);
        StreetDataIndexValue indexValue = (StreetDataIndexValue)indexFile.search(key = dict.makeStreetIndexKey(base, sac));
        if (indexValue != null) {
            return indexValue.getStreetOffset();
        }
        return -1L;
    }

    protected MapMarkerIndexValue getStreetDataLocation(IDataDictionary dict, int sac, MapMarkerIndexKey key, String streetFileName) throws IOException {
        IMapMarkerReadOnlyIndexFile indexFile = dict.getStreetBrowseIndexFile(streetFileName);
        ((MapMarkerBrowseMultiLevelIndexKey)key).replaceSac(sac);
        return indexFile.search(key);
    }

    protected List getBrowseAddresses(MapMarkerIndexKey[] browseBases, int[] sacList, IConstraints preferences, IDataDictionary dict, int debugLevel) throws DataAccessException, FatalDataAccessException {
        ArrayList<InternalBrowseAddress> browseList = new ArrayList<InternalBrowseAddress>();
        MMJDataFileMetadata metadata = null;
        int dictNum = dict.getDictionaryNumber();
        block18: for (int n = 0; n < sacList.length; ++n) {
            SacFileData sac2FnEntry = dict.getSearchAreaFiles(sacList[n]);
            if (debugLevel >= 3) {
                MMJLog.getLog().debug("sac is " + sacList[n]);
                MMJLog.getLog().debug("files is " + sac2FnEntry);
            }
            if (sac2FnEntry == null) continue;
            String streetfile = sac2FnEntry.getStreetFileName();
            metadata = dict.getStreetMetadataObject();
            if (debugLevel >= 3) {
                MMJLog.getLog().debug("street file name is " + streetfile);
            }
            int totalBrowseBases = browseBases.length;
            for (int i = 0; i < totalBrowseBases; ++i) {
                if (debugLevel >= 3) {
                    MMJLog.getLog().debug("streetbase is " + browseBases[i].toString());
                }
                MapMarkerIndexValue value = null;
                try {
                    value = this.getStreetDataLocation(dict, sacList[n], browseBases[i], streetfile);
                }
                catch (FileNotFoundException e) {
                    if (debugLevel < 1) continue block18;
                    MMJLog.getLog().debug("Unable to find index file for: " + streetfile, (Throwable)e);
                    continue block18;
                }
                catch (IOException e) {
                    throw new FatalDataAccessException(2102, (Throwable)e);
                }
                if (value == null) continue;
                SeekableDataInput file = null;
                try {
                    file = dict.getStreetDataFile(streetfile, metadata);
                    ArrayList<StreetCandidateAddress> streets = new ArrayList<StreetCandidateAddress>();
                    int numStreets = ((MapMarkerIndexMultiValue)value).getValueCount();
                    for (int j = 0; j < numStreets; ++j) {
                        streets.add(dict.getAddressFetcher().getSingleStreet(file, ((MapMarkerIndexMultiValue)value).getOffsetAt((short)j), metadata));
                    }
                    int streetCount = streets == null ? 0 : streets.size();
                    for (int str = 0; str < streetCount; ++str) {
                        StreetCandidateAddress street = (StreetCandidateAddress)streets.get(str);
                        street.setSAC(sacList[n]);
                        street.setFromUserDictionary(dict.isUserDictionary());
                        street.setDictionaryNumber(dictNum);
                        if (debugLevel >= 2) {
                            MMJLog.getLog().debug(street.toString());
                        }
                        browseList.add(dict.getAddressFetcher().makeBrowseAddress(street, file, metadata, dict, preferences));
                    }
                    continue;
                }
                catch (FileNotFoundException FNFex) {
                    if (debugLevel < 1) continue block18;
                    MMJLog.getLog().debug("Unable to find street file for: " + streetfile, (Throwable)FNFex);
                    continue block18;
                }
                catch (IOException noDataEx) {
                    throw new FatalDataAccessException(2102, (Throwable)noDataEx);
                }
                catch (LocalizationException LEx) {
                    throw new FatalDataAccessException(2100, (Throwable)LEx);
                }
                catch (MMJEDataCorruptedException MMJEDCEx) {
                    throw new FatalDataAccessException(2101, (Throwable)MMJEDCEx);
                }
                finally {
                    if (file != null) {
                        try {
                            FileProviderFactory.getFileProvider().release(file);
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        }
        return browseList;
    }

    protected List getAlternateStreetData(IDataDictionary dict, SeekableDataInput file, MapMarkerIndexValue value, MMJDataFileMetadata metadata) throws IOException, DataAccessException, FatalDataAccessException {
        MapMarkerIndexMultiValue indexValue = (MapMarkerIndexMultiValue)value;
        ArrayList<AlternateStreetResult> returnList = new ArrayList<AlternateStreetResult>();
        int numAlternateRecords = indexValue.getValueCount();
        for (int i = 0; i < numAlternateRecords; ++i) {
            AlternateDataRecord record = dict.getAddressFetcher().getAlternateData(file, indexValue.getOffsetAt((short)i), metadata);
            record.setDataRecordSource(indexValue.getOffsetAt((short)i));
            try {
                returnList.add(new AlternateStreetResult(dict.getAddressFetcher().getSingleStreet(file, record.getStreetOffset(), metadata), record));
                continue;
            }
            catch (LocalizationException LEx) {
                throw new FatalDataAccessException(2100, (Throwable)LEx);
            }
            catch (MMJEDataCorruptedException MMJEDCEx) {
                throw new FatalDataAccessException(2101, (Throwable)MMJEDCEx);
            }
        }
        return returnList;
    }

    protected MapMarkerIndexValue getAlternateSearchLocation(IDataDictionary dict, int sac, AlternateSearchTypeKey key, String streetFileName) throws IOException {
        IMapMarkerReadOnlyIndexFile indexFile = dict.getAlternateStreetSearchIndexFile(key.getSearchType(), streetFileName);
        MapMarkerStreetMultiLevelIndexKey indexKey = (MapMarkerStreetMultiLevelIndexKey)key.getSearchKey();
        indexKey.replaceSac(sac);
        return indexFile.search(indexKey);
    }

    protected List getAlternateStreetCandidates(AlternateSearchTypeKey[] alternateBases, int[] sacList, IConstraints preferences, IDataDictionary dict, int debugLevel, ScoringAddress scoringAddress) throws DataAccessException, FatalDataAccessException {
        boolean foundData = true;
        FileNotFoundException missingDataException = null;
        ArrayList candList = new ArrayList();
        MMJDataFileMetadata metadata = null;
        block18: for (int n = 0; n < sacList.length; ++n) {
            SacFileData sac2FnEntry = dict.getSearchAreaFiles(sacList[n]);
            if (debugLevel >= 3) {
                MMJLog.getLog().debug("sac is " + sacList[n]);
                MMJLog.getLog().debug("files is " + sac2FnEntry);
            }
            if (sac2FnEntry == null) continue;
            String streetfile = sac2FnEntry.getStreetFileName();
            metadata = dict.getStreetMetadataObject();
            if (debugLevel >= 3) {
                MMJLog.getLog().debug("street file name is " + streetfile);
            }
            MapMarkerIndexValue indexValue = null;
            int totalBases = alternateBases.length;
            for (int i = 0; i < totalBases; ++i) {
                if (debugLevel >= 1) {
                    MMJLog.getLog().debug("alternateBase is " + alternateBases[i].toString());
                }
                try {
                    indexValue = this.getAlternateSearchLocation(dict, sacList[n], alternateBases[i], streetfile);
                }
                catch (FileNotFoundException e) {
                    if (debugLevel >= 1) {
                        MMJLog.getLog().debug("Unable to find index file for: " + streetfile, (Throwable)e);
                    }
                    foundData = false;
                    continue block18;
                }
                catch (IOException e) {
                    throw new FatalDataAccessException(2102, (Throwable)e);
                }
                if (indexValue == null) continue;
                SeekableDataInput file = null;
                try {
                    file = dict.getStreetDataFile(streetfile, metadata);
                    List altStreetResults = this.getAlternateStreetData(dict, file, indexValue, metadata);
                    int resultCount = altStreetResults == null ? 0 : altStreetResults.size();
                    for (int str = 0; str < resultCount; ++str) {
                        AlternateStreetResult altResult = (AlternateStreetResult)altStreetResults.get(str);
                        StreetCandidateAddress street = altResult.getStreet();
                        street.setSAC(sacList[n]);
                        street.setConstraints(preferences);
                        street.score(scoringAddress);
                        street.setFromUserDictionary(dict.isUserDictionary());
                        candList.addAll(dict.getAddressFetcher().makeAlternateStreetCandidates(street, file, altResult.getAlternateRecord(), metadata, dict, preferences));
                    }
                    continue;
                }
                catch (FileNotFoundException FNFex) {
                    foundData = false;
                    missingDataException = FNFex;
                    continue block18;
                }
                catch (IOException noDataEx) {
                    throw new FatalDataAccessException(2102, (Throwable)noDataEx);
                }
                catch (LocalizationException LEx) {
                    throw new FatalDataAccessException(2100, (Throwable)LEx);
                }
                catch (MMJEDataCorruptedException MMJEDCEx) {
                    throw new FatalDataAccessException(2101, (Throwable)MMJEDCEx);
                }
                finally {
                    if (file != null) {
                        try {
                            FileProviderFactory.getFileProvider().release(file);
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        }
        if (candList == null || candList.isEmpty()) {
            if (!foundData && missingDataException != null) {
                throw new DataAccessException(2107, missingDataException);
            }
        } else {
            int dictNum = dict.getDictionaryNumber();
            IDictionarySearchOrder order = preferences.getDictionarySearchOrder();
            for (InternalCandidateAddress cand : candList) {
                cand.setDictionaryPriority(dictNum);
                if (order != null) {
                    cand.setUserDictionaryPriority(order.getSearchOrderForDictionary(dictNum + 1));
                    continue;
                }
                cand.setUserDictionaryPriority(dictNum + 1);
            }
        }
        return candList;
    }

    protected MapMarkerIndexValue getAlternateBrowseLocation(IDataDictionary dict, int sac, AlternateSearchTypeKey key, String streetFileName) throws IOException {
        IMapMarkerReadOnlyIndexFile indexFile = dict.getAlternateStreetBrowseIndexFile(key.getSearchType(), streetFileName);
        MapMarkerBrowseMultiLevelIndexKey indexKey = (MapMarkerBrowseMultiLevelIndexKey)key.getSearchKey();
        indexKey.replaceSac(sac);
        return indexFile.search(indexKey);
    }

    protected List getAlternateBrowseAddresses(AlternateSearchTypeKey[] alternateBases, int[] sacList, IConstraints preferences, IDataDictionary dict, int debugLevel) throws DataAccessException, FatalDataAccessException {
        ArrayList<InternalBrowseAddress> browseList = new ArrayList<InternalBrowseAddress>();
        MMJDataFileMetadata metadata = null;
        int dictNum = dict.getDictionaryNumber();
        block18: for (int n = 0; n < sacList.length; ++n) {
            SacFileData sac2FnEntry = dict.getSearchAreaFiles(sacList[n]);
            if (debugLevel >= 3) {
                MMJLog.getLog().debug("sac is " + sacList[n]);
                MMJLog.getLog().debug("files is " + sac2FnEntry);
            }
            if (sac2FnEntry == null) continue;
            String streetfile = sac2FnEntry.getStreetFileName();
            metadata = dict.getStreetMetadataObject();
            if (debugLevel >= 3) {
                MMJLog.getLog().debug("street file name is " + streetfile);
            }
            int totalAlternateBases = alternateBases.length;
            for (int i = 0; i < totalAlternateBases; ++i) {
                if (debugLevel >= 3) {
                    MMJLog.getLog().debug("streetbase is " + alternateBases[i].toString());
                }
                MapMarkerIndexValue value = null;
                try {
                    value = this.getAlternateBrowseLocation(dict, sacList[n], alternateBases[i], streetfile);
                }
                catch (FileNotFoundException e) {
                    if (debugLevel < 1) continue block18;
                    MMJLog.getLog().debug("Unable to find index file for: " + streetfile, (Throwable)e);
                    continue block18;
                }
                catch (IOException e) {
                    throw new FatalDataAccessException(2102, (Throwable)e);
                }
                if (value == null) continue;
                SeekableDataInput file = null;
                try {
                    file = dict.getStreetDataFile(streetfile, metadata);
                    List altStreetResults = this.getAlternateStreetData(dict, file, value, metadata);
                    int resultCount = altStreetResults == null ? 0 : altStreetResults.size();
                    for (int str = 0; str < resultCount; ++str) {
                        AlternateStreetResult altResult = (AlternateStreetResult)altStreetResults.get(str);
                        StreetCandidateAddress street = altResult.getStreet();
                        street.setSAC(sacList[n]);
                        street.setFromUserDictionary(dict.isUserDictionary());
                        street.setDictionaryNumber(dictNum);
                        browseList.add(dict.getAddressFetcher().makeAlternateBrowseAddress(street, altResult.getAlternateRecord(), file, metadata, dict, preferences));
                    }
                    continue;
                }
                catch (FileNotFoundException FNFex) {
                    if (debugLevel < 1) continue block18;
                    MMJLog.getLog().debug("Unable to find street file for: " + streetfile, (Throwable)FNFex);
                    continue block18;
                }
                catch (IOException noDataEx) {
                    throw new FatalDataAccessException(2102, (Throwable)noDataEx);
                }
                catch (LocalizationException LEx) {
                    throw new FatalDataAccessException(2100, (Throwable)LEx);
                }
                catch (MMJEDataCorruptedException MMJEDCEx) {
                    throw new FatalDataAccessException(2101, (Throwable)MMJEDCEx);
                }
                finally {
                    if (file != null) {
                        try {
                            FileProviderFactory.getFileProvider().release(file);
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        }
        return browseList;
    }

    protected int getDebugLevel(IConstraints constraints) {
        return DebugLevel.getDebugLevel(3);
    }

    protected static ResourceBundle loadBundleForLocale(IConstraints preferences, String file) {
        if (preferences == null) {
            return MapMarkerResourceLoader.loadForLocale(null, file);
        }
        return MapMarkerResourceLoader.loadForLocale(preferences.getClientLocale(), file);
    }

    protected abstract ICountryGeographyInfo getCountryGeographyInfoObject();

    @Override
    public IRetrievedCandidates retrieveReverseGeocodeCandidates(ReverseGeocodeLocation location, IConstraints constraints) throws DataAccessRuntimeException, FatalDataAccessRuntimeException {
        LicenseFilter filter;
        DirectPosition position = CoordConvertor.transformPointToWGS84(location.getCoordSysObject(), location.getPositionPoint());
        ArrayList<InternalCandidateAddress> candidates = new ArrayList<InternalCandidateAddress>();
        DictionaryIterator dictIterator = this.getDictionariesIterator(constraints);
        while (dictIterator.hasNext()) {
            WrappedSpatialIndexValue wrappedSpatialIndexValue;
            Dictionary dict = dictIterator.next();
            if (!(dict.getDictionary() instanceof IReverseGeocodeDataDictionary)) continue;
            double closestCandidateDistance = Double.MAX_VALUE;
            IDataDictionary dictionary = dict.getDictionary();
            List<SpatialIndexValue> indexValues = this.getSpatialIndexValues((IReverseGeocodeDataDictionary)((Object)dict.getDictionary()), position, location.getDistanceAsLength());
            ArrayList<WrappedSpatialIndexValue> wrappedValues = new ArrayList<WrappedSpatialIndexValue>(indexValues.size());
            for (SpatialIndexValue spatialIndexValue : indexValues) {
                wrappedValues.add(new WrappedSpatialIndexValue(spatialIndexValue, position));
            }
            Collections.sort(wrappedValues);
            Iterator<SpatialIndexValue> iterator = wrappedValues.iterator();
            while (iterator.hasNext() && !((wrappedSpatialIndexValue = (WrappedSpatialIndexValue)((Object)iterator.next())).getDistance() > closestCandidateDistance + 1.0)) {
                SeekableDataInput dataFile;
                MMJDataFileMetadata metadata = dictionary.getStreetMetadataObject();
                try {
                    dataFile = dictionary.getStreetDataFile(wrappedSpatialIndexValue.getValue().getDataFileBaseName(), metadata);
                }
                catch (IOException IOEx) {
                    throw new FatalDataAccessRuntimeException(new FatalDataAccessException(2102, (Throwable)IOEx));
                }
                try {
                    List<AlternateDataRecord> alternateDataRecords = wrappedSpatialIndexValue.getValue().toAlternateDataRecords();
                    for (AlternateDataRecord record : alternateDataRecords) {
                        AlternateStreetResult altStreetResult = this.getReverseGeocodeStreetData(dictionary, dataFile, record, metadata);
                        if (altStreetResult == null) continue;
                        StreetCandidateAddress street = altStreetResult.getStreet();
                        street.setConstraints(new Constraints());
                        street.setFromUserDictionary(dictionary.isUserDictionary());
                        List altCandidates = dictionary.getAddressFetcher().makeAlternateStreetCandidates(street, dataFile, altStreetResult.getAlternateRecord(), metadata, dictionary, constraints);
                        if (altCandidates == null || altCandidates.isEmpty()) continue;
                        for (InternalCandidateAddress candidate : altCandidates) {
                            candidate.setVendorCode(String.valueOf(metadata.getVendorCode()));
                            candidate.computeDistance(position);
                            candidates.add(candidate);
                            if (!(closestCandidateDistance > candidate.getDistance())) continue;
                            closestCandidateDistance = candidate.getDistance();
                        }
                    }
                }
                catch (LocalizationException LEx) {
                    throw new FatalDataAccessRuntimeException(new FatalDataAccessException(2101, (Throwable)LEx));
                }
                catch (MMJEDataCorruptedException MMJEDCEx) {
                    throw new FatalDataAccessRuntimeException(new FatalDataAccessException(2101, (Throwable)MMJEDCEx));
                }
                catch (IOException IOEx) {
                    throw new FatalDataAccessRuntimeException(new FatalDataAccessException(2102, (Throwable)IOEx));
                }
                catch (DataAccessException DAEx) {
                    throw new DataAccessRuntimeException(DAEx);
                }
                catch (FatalDataAccessException FDAEx) {
                    throw new FatalDataAccessRuntimeException(FDAEx);
                }
                finally {
                    try {
                        FileProviderFactory.getFileProvider().release(dataFile);
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        Collections.sort(candidates, new InternalCandidateAddress.ReverseGeococodeCandidateComparator());
        IRetrievedCandidates result = this.buildRetrievedCandidates(candidates);
        if (result.getCandidates().size() > 1 && (filter = this.getLicenseFilter()) != null && (result = filter.filterCandidates(result, 0)).getCandidates().size() == 0) {
            result.setDataLicensed(false);
        }
        return result;
    }

    protected AlternateStreetResult getReverseGeocodeStreetData(IDataDictionary dict, SeekableDataInput file, AlternateDataRecord altRecord, MMJDataFileMetadata metadata) throws IOException, DataAccessException, FatalDataAccessException {
        try {
            return new AlternateStreetResult(dict.getAddressFetcher().getSingleStreet(file, altRecord.getStreetOffset(), metadata), altRecord);
        }
        catch (LocalizationException LEx) {
            throw new FatalDataAccessException(2100, (Throwable)LEx);
        }
        catch (MMJEDataCorruptedException MMJEDCEx) {
            throw new FatalDataAccessException(2101, (Throwable)MMJEDCEx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<SpatialIndexValue> getSpatialIndexValues(IReverseGeocodeDataDictionary dict, DirectPosition position, Length distance) {
        IRGIterator<SpatialIndexValue> rgIterator = null;
        boolean bIteratorComplete = false;
        try {
            rgIterator = dict.getStreetRGIterator(position, distance);
            if (!rgIterator.hasNext()) {
                List<SpatialIndexValue> list = Collections.emptyList();
                return list;
            }
            ArrayList<SpatialIndexValue> values = new ArrayList<SpatialIndexValue>();
            while (rgIterator.hasNext()) {
                values.add(rgIterator.next());
            }
            bIteratorComplete = true;
            ArrayList<SpatialIndexValue> arrayList = values;
            return arrayList;
        }
        finally {
            block13: {
                if (rgIterator != null) {
                    try {
                        rgIterator.close();
                    }
                    catch (IOException IOEx) {
                        if (!bIteratorComplete) break block13;
                        throw new DataAccessRuntimeException(new DataAccessException(2102, (Throwable)IOEx));
                    }
                }
            }
        }
    }

    private static class WrappedSpatialIndexValue
    implements Comparable {
        private SpatialIndexValue m_value;
        private double m_distance;

        public WrappedSpatialIndexValue(SpatialIndexValue value, DirectPosition point) {
            this.m_value = value;
            this.m_distance = ReverseGeocodeUtils.getDistance(point, value.getBounds());
        }

        public SpatialIndexValue getValue() {
            return this.m_value;
        }

        public double getDistance() {
            return this.m_distance;
        }

        public int compareTo(Object that) {
            WrappedSpatialIndexValue thatValue = (WrappedSpatialIndexValue)that;
            if (this.m_distance < thatValue.m_distance) {
                return -1;
            }
            if (this.m_distance > thatValue.m_distance) {
                return 1;
            }
            return 0;
        }
    }

    protected final class DictionaryIterator {
        private Iterator m_iterator;

        private DictionaryIterator(Iterator iterator) {
            this.m_iterator = iterator;
        }

        public boolean hasNext() {
            return this.m_iterator.hasNext();
        }

        public Dictionary next() {
            return (Dictionary)this.m_iterator.next();
        }
    }

    protected final class Dictionary
    implements Comparable {
        private int m_dictionaryNumber;
        private int m_priority;
        private IDataDictionary m_dictionary;

        private Dictionary(int dictionaryNumber, int priority, IDataDictionary dictionary) {
            this.m_dictionaryNumber = dictionaryNumber;
            this.m_priority = priority;
            this.m_dictionary = dictionary;
        }

        public int getDictionaryNumber() {
            return this.m_dictionaryNumber;
        }

        public int getPriority() {
            return this.m_priority;
        }

        public IDataDictionary getDictionary() {
            return this.m_dictionary;
        }

        public int compareTo(Object that) {
            Dictionary thatDictionary = (Dictionary)that;
            return this.m_priority - thatDictionary.m_priority;
        }
    }

    protected final class AlternateStreetResult {
        private StreetCandidateAddress m_street;
        private AlternateDataRecord m_record;

        private AlternateStreetResult(StreetCandidateAddress street, AlternateDataRecord record) {
            this.m_street = street;
            this.m_record = record;
        }

        public StreetCandidateAddress getStreet() {
            return this.m_street;
        }

        public AlternateDataRecord getAlternateRecord() {
            return this.m_record;
        }
    }
}

