/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.binary;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class BlobAdditionalFieldsFactory {
    private BlobAdditionalFieldsFactory() {
    }

    public static Map<String, String> createAdditionalFields(byte[] contents) throws IOException {
        if (contents == null || contents.length == 0) {
            throw new IllegalArgumentException();
        }
        DataInputStream stream = new DataInputStream(new ByteArrayInputStream(contents));
        int count = stream.readShort();
        if (count <= 0) {
            throw new IllegalStateException();
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < count; ++i) {
            map.put(stream.readUTF(), stream.readUTF());
        }
        return Collections.unmodifiableMap(map);
    }

    public static byte[] createBlob(Map<String, String> contents) throws IOException {
        if (contents == null || contents.isEmpty()) {
            throw new IllegalArgumentException();
        }
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        DataOutputStream stream = new DataOutputStream(byteStream);
        stream.writeShort(contents.size());
        for (Map.Entry<String, String> entry : contents.entrySet()) {
            stream.writeUTF(entry.getKey());
            stream.writeUTF(entry.getValue());
        }
        return byteStream.toByteArray();
    }
}

