/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.binary;

import com.mapinfo.mapmarker.common.dp.binary.ICustomDataHandler;
import com.mapinfo.mapmarker.common.dp.binary.IDataItem;
import com.mapinfo.mapmarker.common.dp.binary.InternalCandidateConstants;
import com.mapinfo.mapmarker.common.dp.binary.InvalidCustomDataTypeException;
import com.mapinfo.mapmarker.common.dp.binary.MMJEDataCorruptedException;
import com.mapinfo.mapmarker.common.dp.binary.MMJETypeArraySizeExceededException;
import com.mapinfo.mapmarker.common.dp.binary.TypeMask;
import com.mapinfo.mapmarker.utils.DataInputUtilities;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.NoSuchElementException;

public class GenericDataItem
implements InternalCandidateConstants {
    private boolean[] m_booleans;
    private byte[] m_bytes;
    private char[] m_chars;
    private double[] m_doubles;
    private float[] m_floats;
    private int[] m_integers;
    private long[] m_longs;
    private short[] m_shorts;
    private String[] m_strings;
    private byte[][] m_blobs;
    private short[] m_unsignedBytes;
    private int[] m_unsignedShorts;
    private IDataItem[][] m_customDatums;
    private long m_boolHash;
    private long m_byteHash;
    private long m_charHash;
    private long m_doubleHash;
    private long m_floatHash;
    private long m_intHash;
    private long m_longHash;
    private long m_shortHash;
    private long m_stringHash;
    private long m_blobHash;
    private long m_unsignedByteHash;
    private long m_unsignedShortHash;
    private long[] m_customDatumHash;
    private ICustomDataHandler m_handler;
    private static final int MAX_HASH_KEYS = 63;
    public static final int MAX_UNSIGNED_BYTE = 255;
    public static final int MAX_UNSIGNED_SHORT = 65535;

    public GenericDataItem() {
        this(null);
    }

    public GenericDataItem(ICustomDataHandler handler) {
        this.m_handler = handler;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(100);
        if (this.m_booleans != null) {
            sb.append("Bools:");
            sb.append(this.m_booleans.toString());
        }
        if (this.m_bytes != null) {
            sb.append("Bytes:");
            sb.append(this.m_bytes.toString());
        }
        if (this.m_chars != null) {
            sb.append("Chars:");
            sb.append(this.m_chars.toString());
        }
        if (this.m_doubles != null) {
            sb.append("Doubles:");
            sb.append(this.m_doubles.toString());
        }
        if (this.m_floats != null) {
            sb.append("m_floats:");
            sb.append(this.m_floats.toString());
        }
        if (this.m_integers != null) {
            sb.append("ints:");
            sb.append(this.m_integers.toString());
        }
        if (this.m_longs != null) {
            sb.append("m_longs:");
            sb.append(this.m_longs.toString());
        }
        if (this.m_shorts != null) {
            sb.append("m_shorts:");
            sb.append(this.m_shorts.toString());
        }
        if (this.m_strings != null) {
            sb.append("m_strings:");
            sb.append(this.m_strings.toString());
        }
        if (this.m_blobs != null) {
            sb.append("m_blobs:");
            sb.append(this.m_blobs.toString());
        }
        if (this.m_unsignedBytes != null) {
            sb.append("m_unsignedBytes:");
            sb.append(this.m_unsignedBytes.toString());
        }
        if (this.m_unsignedShorts != null) {
            sb.append("m_unsignedShorts:");
            sb.append(this.m_unsignedShorts.toString());
        }
        if (this.m_customDatums != null) {
            sb.append("m_customDatums:");
            for (int i = 0; i <= 2; i = (int)((byte)(i + 1))) {
                if (this.m_customDatums[i] == null) continue;
                sb.append("CustomType " + i + ":");
                sb.append(this.m_customDatums[i].toString());
            }
        }
        return sb.toString();
    }

    public boolean hasBoolean(int maskIndex) {
        long maskKey = 1L << maskIndex;
        return (maskKey & this.m_boolHash) != 0L;
    }

    public boolean hasByte(int maskIndex) {
        long maskKey = 1L << maskIndex;
        return (maskKey & this.m_byteHash) != 0L;
    }

    public boolean hasChar(int maskIndex) {
        long maskKey = 1L << maskIndex;
        return (maskKey & this.m_charHash) != 0L;
    }

    public boolean hasDouble(int maskIndex) {
        long maskKey = 1L << maskIndex;
        return (maskKey & this.m_doubleHash) != 0L;
    }

    public boolean hasFloat(int maskIndex) {
        long maskKey = 1L << maskIndex;
        return (maskKey & this.m_floatHash) != 0L;
    }

    public boolean hasInteger(int maskIndex) {
        long maskKey = 1L << maskIndex;
        return (maskKey & this.m_intHash) != 0L;
    }

    public boolean hasLong(int maskIndex) {
        long maskKey = 1L << maskIndex;
        return (maskKey & this.m_longHash) != 0L;
    }

    public boolean hasShort(int maskIndex) {
        long maskKey = 1L << maskIndex;
        return (maskKey & this.m_shortHash) != 0L;
    }

    public boolean hasString(int maskIndex) {
        long maskKey = 1L << maskIndex;
        return (maskKey & this.m_stringHash) != 0L;
    }

    public boolean hasBlob(int maskIndex) {
        long maskKey = 1L << maskIndex;
        return (maskKey & this.m_blobHash) != 0L;
    }

    public boolean hasUnsignedByte(int maskIndex) {
        long maskKey = 1L << maskIndex;
        return (maskKey & this.m_unsignedByteHash) != 0L;
    }

    public boolean hasUnsignedShort(int maskIndex) {
        long maskKey = 1L << maskIndex;
        return (maskKey & this.m_unsignedShortHash) != 0L;
    }

    public boolean hasCustomData(byte customDataType, int maskIndex) throws InvalidCustomDataTypeException {
        if (this.isValidCustomDataType(customDataType)) {
            if (this.m_customDatumHash != null) {
                long maskKey = 1L << maskIndex;
                return (maskKey & this.m_customDatumHash[customDataType]) != 0L;
            }
            return false;
        }
        throw new InvalidCustomDataTypeException("Invalid custom data type: " + customDataType);
    }

    public void putBoolean(int maskIndex, boolean value) throws MMJETypeArraySizeExceededException {
        if (maskIndex >= 63) {
            throw new MMJETypeArraySizeExceededException("Invalid mask index: " + maskIndex);
        }
        if (this.m_booleans == null) {
            this.m_booleans = new boolean[63];
        }
        this.m_booleans[maskIndex] = value;
        this.m_boolHash |= 1L << maskIndex;
    }

    public void putByte(int maskIndex, byte value) throws MMJETypeArraySizeExceededException {
        if (maskIndex >= 63) {
            throw new MMJETypeArraySizeExceededException("Invalid mask index: " + maskIndex);
        }
        if (this.m_bytes == null) {
            this.m_bytes = new byte[63];
        }
        this.m_bytes[maskIndex] = value;
        this.m_byteHash |= 1L << maskIndex;
    }

    public void putChar(int maskIndex, char value) throws MMJETypeArraySizeExceededException {
        if (maskIndex >= 63) {
            throw new MMJETypeArraySizeExceededException("Invalid mask index: " + maskIndex);
        }
        if (this.m_chars == null) {
            this.m_chars = new char[63];
        }
        this.m_chars[maskIndex] = value;
        this.m_charHash |= 1L << maskIndex;
    }

    public void putDouble(int maskIndex, double value) throws MMJETypeArraySizeExceededException {
        if (maskIndex >= 63) {
            throw new MMJETypeArraySizeExceededException("Invalid mask index: " + maskIndex);
        }
        if (this.m_doubles == null) {
            this.m_doubles = new double[63];
        }
        this.m_doubles[maskIndex] = value;
        this.m_doubleHash |= 1L << maskIndex;
    }

    public void putFloat(int maskIndex, float value) throws MMJETypeArraySizeExceededException {
        if (maskIndex >= 63) {
            throw new MMJETypeArraySizeExceededException("Invalid mask index: " + maskIndex);
        }
        if (this.m_floats == null) {
            this.m_floats = new float[63];
        }
        this.m_floats[maskIndex] = value;
        this.m_floatHash |= 1L << maskIndex;
    }

    public void putInt(int maskIndex, int value) throws MMJETypeArraySizeExceededException {
        if (maskIndex >= 63) {
            throw new MMJETypeArraySizeExceededException("Invalid mask index: " + maskIndex);
        }
        if (this.m_integers == null) {
            this.m_integers = new int[63];
        }
        this.m_integers[maskIndex] = value;
        this.m_intHash |= 1L << maskIndex;
    }

    public void putLong(int maskIndex, long value) throws MMJETypeArraySizeExceededException {
        if (maskIndex >= 63) {
            throw new MMJETypeArraySizeExceededException("Invalid mask index: " + maskIndex);
        }
        if (this.m_longs == null) {
            this.m_longs = new long[63];
        }
        this.m_longs[maskIndex] = value;
        this.m_longHash |= 1L << maskIndex;
    }

    public void putShort(int maskIndex, short value) throws MMJETypeArraySizeExceededException {
        if (maskIndex >= 63) {
            throw new MMJETypeArraySizeExceededException("Invalid mask index: " + maskIndex);
        }
        if (this.m_shorts == null) {
            this.m_shorts = new short[63];
        }
        this.m_shorts[maskIndex] = value;
        this.m_shortHash |= 1L << maskIndex;
    }

    public void putString(int maskIndex, String value) throws MMJETypeArraySizeExceededException {
        if (maskIndex >= 63) {
            throw new MMJETypeArraySizeExceededException("Invalid mask index: " + maskIndex);
        }
        if (this.m_strings == null) {
            this.m_strings = new String[63];
        }
        this.m_strings[maskIndex] = value;
        this.m_stringHash |= 1L << maskIndex;
    }

    public void putBlob(int maskIndex, byte[] value) throws MMJETypeArraySizeExceededException {
        if (maskIndex >= 63) {
            throw new MMJETypeArraySizeExceededException("Invalid mask index: " + maskIndex);
        }
        if (this.m_blobs == null) {
            this.m_blobs = new byte[63][];
        }
        this.m_blobs[maskIndex] = value;
        this.m_blobHash |= 1L << maskIndex;
    }

    public void putUnsignedByte(int maskIndex, short unsignedByteValue) throws MMJETypeArraySizeExceededException {
        if (maskIndex >= 63) {
            throw new MMJETypeArraySizeExceededException("Invalid mask index: " + maskIndex);
        }
        if (this.m_unsignedBytes == null) {
            this.m_unsignedBytes = new short[63];
        }
        this.m_unsignedBytes[maskIndex] = unsignedByteValue;
        this.m_unsignedByteHash |= 1L << maskIndex;
    }

    public void putUnsignedShort(int maskIndex, int unsignedShortValue) throws MMJETypeArraySizeExceededException {
        if (maskIndex >= 63) {
            throw new MMJETypeArraySizeExceededException("Invalid mask index: " + maskIndex);
        }
        if (this.m_unsignedShorts == null) {
            this.m_unsignedShorts = new int[63];
        }
        this.m_unsignedShorts[maskIndex] = unsignedShortValue;
        this.m_unsignedShortHash |= 1L << maskIndex;
    }

    public void putCustomData(byte customDataType, int maskIndex, IDataItem data) throws InvalidCustomDataTypeException, MMJETypeArraySizeExceededException {
        if (this.isValidCustomDataType(customDataType)) {
            if (maskIndex >= 63) {
                throw new MMJETypeArraySizeExceededException("Invalid mask index: " + maskIndex);
            }
            if (this.m_customDatums == null) {
                this.m_customDatums = new IDataItem[3][];
            }
            if (this.m_customDatumHash == null) {
                this.m_customDatumHash = new long[3];
            }
            if (this.m_customDatums[customDataType] == null) {
                this.m_customDatums[customDataType] = new IDataItem[63];
            }
        } else {
            throw new InvalidCustomDataTypeException("Invalid custom data type: " + customDataType);
        }
        this.m_customDatums[customDataType][maskIndex] = data;
        byte by = customDataType;
        this.m_customDatumHash[by] = this.m_customDatumHash[by] | 1L << maskIndex;
    }

    public boolean getBoolean(int maskIndex) throws MMJETypeArraySizeExceededException {
        if (maskIndex >= 63) {
            throw new MMJETypeArraySizeExceededException("Invalid mask index: " + maskIndex);
        }
        if (this.m_booleans == null || !this.hasBoolean(maskIndex)) {
            throw new NoSuchElementException("Invalid mask index: " + maskIndex);
        }
        return this.m_booleans[maskIndex];
    }

    public byte getByte(int maskIndex) throws MMJETypeArraySizeExceededException {
        if (maskIndex >= 63) {
            throw new MMJETypeArraySizeExceededException("Invalid mask index: " + maskIndex);
        }
        if (this.m_bytes == null || !this.hasByte(maskIndex)) {
            throw new NoSuchElementException("Invalid mask index: " + maskIndex);
        }
        return this.m_bytes[maskIndex];
    }

    public char getChar(int maskIndex) throws MMJETypeArraySizeExceededException {
        if (maskIndex >= 63) {
            throw new MMJETypeArraySizeExceededException("Invalid mask index: " + maskIndex);
        }
        if (this.m_chars == null || !this.hasChar(maskIndex)) {
            throw new NoSuchElementException("Invalid mask index: " + maskIndex);
        }
        return this.m_chars[maskIndex];
    }

    public double getDouble(int maskIndex) throws MMJETypeArraySizeExceededException {
        if (maskIndex >= 63) {
            throw new MMJETypeArraySizeExceededException("Invalid mask index: " + maskIndex);
        }
        if (this.m_doubles == null || !this.hasDouble(maskIndex)) {
            throw new NoSuchElementException("Invalid mask index: " + maskIndex);
        }
        return this.m_doubles[maskIndex];
    }

    public float getFloat(int maskIndex) throws MMJETypeArraySizeExceededException {
        if (maskIndex >= 63) {
            throw new MMJETypeArraySizeExceededException("Invalid mask index: " + maskIndex);
        }
        if (this.m_floats == null || !this.hasFloat(maskIndex)) {
            throw new NoSuchElementException("Invalid mask index: " + maskIndex);
        }
        return this.m_floats[maskIndex];
    }

    public int getInt(int maskIndex) throws MMJETypeArraySizeExceededException {
        if (maskIndex >= 63) {
            throw new MMJETypeArraySizeExceededException("Invalid mask index: " + maskIndex);
        }
        if (this.m_integers == null || !this.hasInteger(maskIndex)) {
            throw new NoSuchElementException("Invalid mask index: " + maskIndex);
        }
        return this.m_integers[maskIndex];
    }

    public long getLong(int maskIndex) throws MMJETypeArraySizeExceededException {
        if (maskIndex >= 63) {
            throw new MMJETypeArraySizeExceededException("Invalid mask index: " + maskIndex);
        }
        if (this.m_longs == null || !this.hasLong(maskIndex)) {
            throw new NoSuchElementException("Invalid mask index: " + maskIndex);
        }
        return this.m_longs[maskIndex];
    }

    public short getShort(int maskIndex) throws MMJETypeArraySizeExceededException {
        if (maskIndex >= 63) {
            throw new MMJETypeArraySizeExceededException("Invalid mask index: " + maskIndex);
        }
        if (this.m_shorts == null || !this.hasShort(maskIndex)) {
            throw new NoSuchElementException("Invalid mask index: " + maskIndex);
        }
        return this.m_shorts[maskIndex];
    }

    public String getString(int maskIndex) throws MMJETypeArraySizeExceededException {
        if (maskIndex >= 63) {
            throw new MMJETypeArraySizeExceededException("Invalid mask index: " + maskIndex);
        }
        if (this.m_strings == null || !this.hasString(maskIndex)) {
            throw new NoSuchElementException("Invalid mask index: " + maskIndex);
        }
        return this.m_strings[maskIndex];
    }

    public byte[] getBlob(int maskIndex) throws MMJETypeArraySizeExceededException {
        if (maskIndex >= 63) {
            throw new MMJETypeArraySizeExceededException("Invalid mask index: " + maskIndex);
        }
        if (this.m_blobs == null || !this.hasBlob(maskIndex)) {
            throw new NoSuchElementException("Invalid mask index: " + maskIndex);
        }
        return this.m_blobs[maskIndex];
    }

    public short getUnsignedByte(int maskIndex) throws MMJETypeArraySizeExceededException {
        if (maskIndex >= 63) {
            throw new MMJETypeArraySizeExceededException("Invalid mask index: " + maskIndex);
        }
        if (this.m_unsignedBytes == null || !this.hasUnsignedByte(maskIndex)) {
            throw new NoSuchElementException("Invalid mask index: " + maskIndex);
        }
        return this.m_unsignedBytes[maskIndex];
    }

    public int getUnsignedShort(int maskIndex) throws MMJETypeArraySizeExceededException {
        if (maskIndex >= 63) {
            throw new MMJETypeArraySizeExceededException("Invalid mask index: " + maskIndex);
        }
        if (this.m_unsignedShorts == null || !this.hasUnsignedShort(maskIndex)) {
            throw new NoSuchElementException("Invalid mask index: " + maskIndex);
        }
        return this.m_unsignedShorts[maskIndex];
    }

    public IDataItem getCustomData(byte customDataType, int maskIndex) throws InvalidCustomDataTypeException, MMJETypeArraySizeExceededException {
        if (this.isValidCustomDataType(customDataType)) {
            if (maskIndex > 63) {
                throw new MMJETypeArraySizeExceededException("Invalid mask index: " + maskIndex);
            }
            if (this.m_customDatums == null || !this.hasCustomData(customDataType, maskIndex)) {
                throw new NoSuchElementException("Invalid mask index: " + maskIndex);
            }
            return this.m_customDatums[customDataType][maskIndex];
        }
        throw new InvalidCustomDataTypeException("Invalid custom data type: " + customDataType);
    }

    private long removeBitFromHash(int maskIndex, long originalMask) {
        long positionMask = 1L << maskIndex;
        long bitMask = Long.MAX_VALUE ^ positionMask;
        return originalMask & bitMask;
    }

    protected boolean removeBoolean(int maskIndex) throws MMJETypeArraySizeExceededException {
        if (maskIndex >= 63) {
            throw new MMJETypeArraySizeExceededException("Invalid mask index: " + maskIndex);
        }
        if (this.m_booleans == null || !this.hasBoolean(maskIndex)) {
            throw new NoSuchElementException("Invalid mask index: " + maskIndex);
        }
        this.m_boolHash = this.removeBitFromHash(maskIndex, this.m_boolHash);
        return this.m_booleans[maskIndex];
    }

    public byte removeByte(int maskIndex) throws MMJETypeArraySizeExceededException {
        if (maskIndex >= 63) {
            throw new MMJETypeArraySizeExceededException("Invalid mask index: " + maskIndex);
        }
        if (this.m_bytes == null || !this.hasByte(maskIndex)) {
            throw new NoSuchElementException("Invalid mask index: " + maskIndex);
        }
        this.m_byteHash = this.removeBitFromHash(maskIndex, this.m_byteHash);
        return this.m_bytes[maskIndex];
    }

    public char removeChar(int maskIndex) throws MMJETypeArraySizeExceededException {
        if (maskIndex >= 63) {
            throw new MMJETypeArraySizeExceededException("Invalid mask index: " + maskIndex);
        }
        if (this.m_chars == null || !this.hasChar(maskIndex)) {
            throw new NoSuchElementException("Invalid mask index: " + maskIndex);
        }
        this.m_charHash = this.removeBitFromHash(maskIndex, this.m_charHash);
        return this.m_chars[maskIndex];
    }

    public double removeDouble(int maskIndex) throws MMJETypeArraySizeExceededException {
        if (maskIndex >= 63) {
            throw new MMJETypeArraySizeExceededException("Invalid mask index: " + maskIndex);
        }
        if (this.m_doubles == null || !this.hasDouble(maskIndex)) {
            throw new NoSuchElementException("Invalid mask index: " + maskIndex);
        }
        this.m_doubleHash = this.removeBitFromHash(maskIndex, this.m_doubleHash);
        return this.m_doubles[maskIndex];
    }

    public float removeFloat(int maskIndex) throws MMJETypeArraySizeExceededException {
        if (maskIndex >= 63) {
            throw new MMJETypeArraySizeExceededException("Invalid mask index: " + maskIndex);
        }
        if (this.m_floats == null || !this.hasFloat(maskIndex)) {
            throw new NoSuchElementException("Invalid mask index: " + maskIndex);
        }
        this.m_floatHash = this.removeBitFromHash(maskIndex, this.m_floatHash);
        return this.m_floats[maskIndex];
    }

    public int removeInt(int maskIndex) throws MMJETypeArraySizeExceededException {
        if (maskIndex >= 63) {
            throw new MMJETypeArraySizeExceededException("Invalid mask index: " + maskIndex);
        }
        if (this.m_integers == null || !this.hasInteger(maskIndex)) {
            throw new NoSuchElementException("Invalid mask index: " + maskIndex);
        }
        this.m_intHash = this.removeBitFromHash(maskIndex, this.m_intHash);
        return this.m_integers[maskIndex];
    }

    public long removeLong(int maskIndex) throws MMJETypeArraySizeExceededException {
        if (maskIndex >= 63) {
            throw new MMJETypeArraySizeExceededException("Invalid mask index: " + maskIndex);
        }
        if (this.m_longs == null || !this.hasLong(maskIndex)) {
            throw new NoSuchElementException("Invalid mask index: " + maskIndex);
        }
        this.m_longHash = this.removeBitFromHash(maskIndex, this.m_longHash);
        return this.m_longs[maskIndex];
    }

    public short removeShort(int maskIndex) throws MMJETypeArraySizeExceededException {
        if (maskIndex >= 63) {
            throw new MMJETypeArraySizeExceededException("Invalid mask index: " + maskIndex);
        }
        if (this.m_shorts == null || !this.hasShort(maskIndex)) {
            throw new NoSuchElementException("Invalid mask index: " + maskIndex);
        }
        this.m_shortHash = this.removeBitFromHash(maskIndex, this.m_shortHash);
        return this.m_shorts[maskIndex];
    }

    public String removeString(int maskIndex) throws MMJETypeArraySizeExceededException {
        if (maskIndex >= 63) {
            throw new MMJETypeArraySizeExceededException("Invalid mask index: " + maskIndex);
        }
        if (this.m_strings == null || !this.hasString(maskIndex)) {
            throw new NoSuchElementException("Invalid mask index: " + maskIndex);
        }
        this.m_stringHash = this.removeBitFromHash(maskIndex, this.m_stringHash);
        return this.m_strings[maskIndex];
    }

    public byte[] removeBlob(int maskIndex) throws MMJETypeArraySizeExceededException {
        if (maskIndex >= 63) {
            throw new MMJETypeArraySizeExceededException("Invalid mask index: " + maskIndex);
        }
        if (this.m_blobs == null || !this.hasBlob(maskIndex)) {
            throw new NoSuchElementException("Invalid mask index: " + maskIndex);
        }
        this.m_blobHash = this.removeBitFromHash(maskIndex, this.m_blobHash);
        return this.m_blobs[maskIndex];
    }

    public short removeUnsignedByte(int maskIndex) throws MMJETypeArraySizeExceededException {
        if (maskIndex >= 63) {
            throw new MMJETypeArraySizeExceededException("Invalid mask index: " + maskIndex);
        }
        if (this.m_unsignedBytes == null || !this.hasUnsignedByte(maskIndex)) {
            throw new NoSuchElementException("Invalid mask index: " + maskIndex);
        }
        this.m_unsignedByteHash = this.removeBitFromHash(maskIndex, this.m_unsignedByteHash);
        return this.m_unsignedBytes[maskIndex];
    }

    public int removeUnsignedShort(int maskIndex) throws MMJETypeArraySizeExceededException {
        if (maskIndex >= 63) {
            throw new MMJETypeArraySizeExceededException("Invalid mask index: " + maskIndex);
        }
        if (this.m_unsignedShorts == null || !this.hasUnsignedShort(maskIndex)) {
            throw new NoSuchElementException("Invalid mask index: " + maskIndex);
        }
        this.m_unsignedShortHash = this.removeBitFromHash(maskIndex, this.m_unsignedShortHash);
        return this.m_unsignedShorts[maskIndex];
    }

    public IDataItem removeCustomData(byte customDataType, int maskIndex) throws InvalidCustomDataTypeException, MMJETypeArraySizeExceededException {
        if (this.isValidCustomDataType(customDataType)) {
            if (maskIndex >= 63) {
                throw new MMJETypeArraySizeExceededException("Invalid mask index: " + maskIndex);
            }
            if (this.m_customDatums == null || !this.hasCustomData(customDataType, maskIndex)) {
                throw new NoSuchElementException("Invalid mask index: " + maskIndex);
            }
            this.m_customDatumHash[customDataType] = this.removeBitFromHash(maskIndex, this.m_customDatumHash[customDataType]);
            return this.m_customDatums[customDataType][maskIndex];
        }
        throw new InvalidCustomDataTypeException("Invalid custom data type: " + customDataType);
    }

    private boolean isValidCustomDataType(byte customDataType) {
        return this.m_handler != null && customDataType <= this.m_handler.getNumberOfSupportedTypes();
    }

    protected void read(DataInput in, TypeMask mask) throws IOException, MMJEDataCorruptedException {
        byte i;
        byte[] indexArray;
        if (mask == null) {
            mask = new TypeMask();
            mask.read(in);
        }
        this.m_boolHash = mask.getBoolHash();
        this.m_byteHash = mask.getByteHash();
        this.m_charHash = mask.getCharHash();
        this.m_doubleHash = mask.getDoubleHash();
        this.m_floatHash = mask.getFloatHash();
        this.m_intHash = mask.getIntHash();
        this.m_longHash = mask.getLongHash();
        this.m_shortHash = mask.getShortHash();
        this.m_stringHash = mask.getStringHash();
        this.m_blobHash = mask.getBlobHash();
        this.m_unsignedByteHash = mask.getUnsignedByteHash();
        this.m_unsignedShortHash = mask.getUnsignedShortHash();
        this.m_customDatumHash = mask.getCustomDatumHashes();
        int size = mask.getPrimitivesSize();
        byte[] tmpBlock = DataInputUtilities.readByteArray(in, size);
        int index = 0;
        if (this.m_boolHash != 0L) {
            indexArray = mask.getBoolHashArray();
            this.m_booleans = new boolean[63];
            for (i = 0; i < indexArray.length; ++i) {
                this.m_booleans[indexArray[i]] = tmpBlock[index] != 0;
                ++index;
            }
        }
        if (this.m_byteHash != 0L) {
            indexArray = mask.getByteHashArray();
            this.m_bytes = new byte[63];
            for (i = 0; i < indexArray.length; ++i) {
                this.m_bytes[indexArray[i]] = tmpBlock[index];
                ++index;
            }
        }
        if (this.m_charHash != 0L) {
            indexArray = mask.getCharHashArray();
            this.m_chars = new char[63];
            for (i = 0; i < indexArray.length; ++i) {
                this.m_chars[indexArray[i]] = DataInputUtilities.getCharFromByteArray(index, tmpBlock);
                index += 2;
            }
        }
        if (this.m_doubleHash != 0L) {
            indexArray = mask.getDoubleHashArray();
            this.m_doubles = new double[63];
            for (i = 0; i < indexArray.length; ++i) {
                this.m_doubles[indexArray[i]] = DataInputUtilities.getDoubleFromByteArray(index, tmpBlock);
                index += 8;
            }
        }
        if (this.m_floatHash != 0L) {
            indexArray = mask.getFloatHashArray();
            this.m_floats = new float[63];
            for (i = 0; i < indexArray.length; ++i) {
                this.m_floats[indexArray[i]] = DataInputUtilities.getFloatFromByteArray(index, tmpBlock);
                index += 4;
            }
        }
        if (this.m_intHash != 0L) {
            indexArray = mask.getIntHashArray();
            this.m_integers = new int[63];
            for (i = 0; i < indexArray.length; ++i) {
                this.m_integers[indexArray[i]] = DataInputUtilities.getIntFromByteArray(index, tmpBlock);
                index += 4;
            }
        }
        if (this.m_longHash != 0L) {
            indexArray = mask.getLongHashArray();
            this.m_longs = new long[63];
            for (i = 0; i < indexArray.length; ++i) {
                this.m_longs[indexArray[i]] = DataInputUtilities.getLongFromByteArray(index, tmpBlock);
                index += 8;
            }
        }
        if (this.m_shortHash != 0L) {
            indexArray = mask.getShortHashArray();
            this.m_shorts = new short[63];
            for (i = 0; i < indexArray.length; ++i) {
                this.m_shorts[indexArray[i]] = DataInputUtilities.getShortFromByteArray(index, tmpBlock);
                index += 2;
            }
        }
        if (this.m_unsignedByteHash != 0L) {
            indexArray = mask.getUnsignedByteHashArray();
            this.m_unsignedBytes = new short[63];
            for (i = 0; i < indexArray.length; i = (byte)((byte)(i + 1))) {
                this.m_unsignedBytes[indexArray[i]] = DataInputUtilities.getUnsignedByteFromByteArray(index, tmpBlock);
                ++index;
            }
        }
        if (this.m_unsignedShortHash != 0L) {
            indexArray = mask.getUnsignedShortHashArray();
            this.m_unsignedShorts = new int[63];
            for (i = 0; i < indexArray.length; i = (byte)((byte)(i + 1))) {
                this.m_unsignedShorts[indexArray[i]] = DataInputUtilities.getUnsignedShortFromByteArray(index, tmpBlock);
                index += 2;
            }
        }
        if (this.m_stringHash != 0L) {
            indexArray = mask.getStringHashArray();
            if (indexArray.length != 0 && this.m_strings == null) {
                this.m_strings = new String[63];
            }
            for (i = 0; i < indexArray.length; ++i) {
                this.m_strings[indexArray[i]] = in.readUTF();
            }
        }
        if (this.m_blobHash != 0L) {
            indexArray = mask.getBlobHashArray();
            if (indexArray.length != 0 && this.m_blobs == null) {
                this.m_blobs = new byte[63][];
            }
            for (int i2 = 0; i2 < indexArray.length; ++i2) {
                int blobSize = in.readInt();
                this.m_blobs[indexArray[i2]] = DataInputUtilities.readByteArray(in, blobSize);
            }
        }
        if (this.m_customDatumHash != null) {
            if (this.m_handler == null) {
                throw new MMJEDataCorruptedException("Unable to read custom data.");
            }
            this.m_customDatums = new IDataItem[3][];
            for (i = 0; i < this.m_handler.getNumberOfSupportedTypes(); i = (byte)(i + 1)) {
                if (this.m_customDatumHash[i] == 0L) continue;
                indexArray = mask.getCustomDatumHashArray(i);
                if (indexArray.length > 0 && this.m_customDatums[i] == null) {
                    this.m_customDatums[i] = new IDataItem[63];
                }
                for (int j = 0; j < indexArray.length; j = (int)((byte)(j + 1))) {
                    IDataItem item = this.m_handler.getCustomDataInstance(i);
                    if (item == null) {
                        throw new MMJEDataCorruptedException("Unable to read custom data.");
                    }
                    item.read(in);
                    this.m_customDatums[i][indexArray[j]] = item;
                }
            }
        }
    }

    protected TypeMask getMask() {
        TypeMask mask = new TypeMask();
        mask.setBoolHash(this.m_boolHash);
        mask.setByteHash(this.m_byteHash);
        mask.setCharHash(this.m_charHash);
        mask.setDoubleHash(this.m_doubleHash);
        mask.setFloatHash(this.m_floatHash);
        mask.setIntHash(this.m_intHash);
        mask.setLongHash(this.m_longHash);
        mask.setShortHash(this.m_shortHash);
        mask.setStringHash(this.m_stringHash);
        mask.setBlobHash(this.m_blobHash);
        mask.setUnsignedByteHash(this.m_unsignedByteHash);
        mask.setUnsignedShortHash(this.m_unsignedShortHash);
        mask.setCustomDatumsHash(this.m_customDatumHash);
        return mask;
    }

    protected void write(DataOutput out, TypeMask mask, boolean writeMask) throws IOException, MMJEDataCorruptedException {
        byte i;
        byte[] tmpArray;
        if (writeMask) {
            mask.write(out);
        }
        if ((tmpArray = mask.getBoolHashArray()) != null) {
            for (i = 0; i < tmpArray.length; ++i) {
                out.writeBoolean(this.m_booleans[tmpArray[i]]);
            }
        }
        if ((tmpArray = mask.getByteHashArray()) != null) {
            for (i = 0; i < tmpArray.length; ++i) {
                out.writeByte(this.m_bytes[tmpArray[i]]);
            }
        }
        if ((tmpArray = mask.getCharHashArray()) != null) {
            for (i = 0; i < tmpArray.length; ++i) {
                out.writeChar(this.m_chars[tmpArray[i]]);
            }
        }
        if ((tmpArray = mask.getDoubleHashArray()) != null) {
            for (i = 0; i < tmpArray.length; ++i) {
                out.writeDouble(this.m_doubles[tmpArray[i]]);
            }
        }
        if ((tmpArray = mask.getFloatHashArray()) != null) {
            for (i = 0; i < tmpArray.length; ++i) {
                out.writeFloat(this.m_floats[tmpArray[i]]);
            }
        }
        if ((tmpArray = mask.getIntHashArray()) != null) {
            for (i = 0; i < tmpArray.length; ++i) {
                out.writeInt(this.m_integers[tmpArray[i]]);
            }
        }
        if ((tmpArray = mask.getLongHashArray()) != null) {
            for (i = 0; i < tmpArray.length; ++i) {
                out.writeLong(this.m_longs[tmpArray[i]]);
            }
        }
        if ((tmpArray = mask.getShortHashArray()) != null) {
            for (i = 0; i < tmpArray.length; ++i) {
                out.writeShort(this.m_shorts[tmpArray[i]]);
            }
        }
        if ((tmpArray = mask.getUnsignedByteHashArray()) != null) {
            for (i = 0; i < tmpArray.length; i = (byte)((byte)(i + 1))) {
                out.writeByte(this.m_unsignedBytes[tmpArray[i]]);
            }
        }
        if ((tmpArray = mask.getUnsignedShortHashArray()) != null) {
            for (i = 0; i < tmpArray.length; i = (byte)((byte)(i + 1))) {
                out.writeShort(this.m_unsignedShorts[tmpArray[i]]);
            }
        }
        if ((tmpArray = mask.getStringHashArray()) != null) {
            for (i = 0; i < tmpArray.length; ++i) {
                out.writeUTF(this.m_strings[tmpArray[i]]);
            }
        }
        if ((tmpArray = mask.getBlobHashArray()) != null) {
            for (int i2 = 0; i2 < tmpArray.length; ++i2) {
                byte[] val = this.m_blobs[tmpArray[i2]];
                out.writeInt(val.length);
                for (int n = 0; n < val.length; ++n) {
                    out.writeByte(val[n]);
                }
            }
        }
        if (this.m_customDatums != null) {
            for (i = 0; i < this.m_handler.getNumberOfSupportedTypes(); i = (byte)(i + 1)) {
                tmpArray = mask.getCustomDatumHashArray(i);
                if (tmpArray == null) continue;
                for (int j = 0; j < tmpArray.length; j = (int)((byte)(j + 1))) {
                    this.m_customDatums[i][tmpArray[j]].write(out);
                }
            }
        }
    }

    protected void write(DataOutput out) throws IOException, MMJEDataCorruptedException {
        this.write(out, this.getMask(), true);
    }
}

