/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.binary;

import com.mapinfo.mapmarker.common.dp.binary.GenericDataItem;
import com.mapinfo.mapmarker.common.dp.binary.IDataItem;
import com.mapinfo.mapmarker.common.dp.binary.InvalidCustomDataTypeException;
import com.mapinfo.mapmarker.common.dp.binary.LocalizationException;
import com.mapinfo.mapmarker.common.dp.binary.MMJETypeArraySizeExceededException;
import java.util.NoSuchElementException;

public final class GenericDataItemAccessor {
    private GenericDataItemAccessor() {
    }

    public static boolean getDataBool(int code, GenericDataItem item) throws LocalizationException {
        try {
            return item.getBoolean(code);
        }
        catch (NoSuchElementException e) {
            return false;
        }
        catch (MMJETypeArraySizeExceededException e) {
            throw new LocalizationException(e);
        }
    }

    public static byte getDataByte(int code, GenericDataItem item) throws LocalizationException {
        try {
            return item.getByte(code);
        }
        catch (NoSuchElementException e) {
            return 0;
        }
        catch (MMJETypeArraySizeExceededException e) {
            throw new LocalizationException(e);
        }
    }

    public static char getDataChar(int code, GenericDataItem item) throws LocalizationException {
        try {
            return item.getChar(code);
        }
        catch (NoSuchElementException e) {
            return '\u0000';
        }
        catch (MMJETypeArraySizeExceededException e) {
            throw new LocalizationException(e);
        }
    }

    public static double getDataDouble(int code, GenericDataItem item) throws LocalizationException {
        try {
            return item.getDouble(code);
        }
        catch (NoSuchElementException e) {
            return 0.0;
        }
        catch (MMJETypeArraySizeExceededException e) {
            throw new LocalizationException(e);
        }
    }

    public static float getDataFloat(int code, GenericDataItem item) throws LocalizationException {
        try {
            return item.getFloat(code);
        }
        catch (NoSuchElementException e) {
            return 0.0f;
        }
        catch (MMJETypeArraySizeExceededException e) {
            throw new LocalizationException(e);
        }
    }

    public static int getDataInt(int code, GenericDataItem item) throws LocalizationException {
        try {
            return item.getInt(code);
        }
        catch (NoSuchElementException e) {
            return 0;
        }
        catch (MMJETypeArraySizeExceededException e) {
            throw new LocalizationException(e);
        }
    }

    public static long getDataLong(int code, GenericDataItem item) throws LocalizationException {
        try {
            return item.getLong(code);
        }
        catch (NoSuchElementException e) {
            return 0L;
        }
        catch (MMJETypeArraySizeExceededException e) {
            throw new LocalizationException(e);
        }
    }

    public static short getDataShort(int code, GenericDataItem item) throws LocalizationException {
        try {
            return item.getShort(code);
        }
        catch (NoSuchElementException e) {
            return 0;
        }
        catch (MMJETypeArraySizeExceededException e) {
            throw new LocalizationException(e);
        }
    }

    public static String getDataString(int code, GenericDataItem item) throws LocalizationException {
        try {
            return item.getString(code);
        }
        catch (NoSuchElementException e) {
            return null;
        }
        catch (MMJETypeArraySizeExceededException e) {
            throw new LocalizationException(e);
        }
    }

    public static short getDataUnsignedByte(int code, GenericDataItem item) throws LocalizationException {
        try {
            return item.getUnsignedByte(code);
        }
        catch (NoSuchElementException e) {
            return 0;
        }
        catch (MMJETypeArraySizeExceededException e) {
            throw new LocalizationException(e);
        }
    }

    public static int getDataUnsignedShort(int code, GenericDataItem item) throws LocalizationException {
        try {
            return item.getUnsignedShort(code);
        }
        catch (NoSuchElementException e) {
            return 0;
        }
        catch (MMJETypeArraySizeExceededException e) {
            throw new LocalizationException(e);
        }
    }

    public static byte[] getDataBlob(int code, GenericDataItem item) throws LocalizationException {
        try {
            return item.getBlob(code);
        }
        catch (NoSuchElementException e) {
            return null;
        }
        catch (MMJETypeArraySizeExceededException e) {
            throw new LocalizationException(e);
        }
    }

    public static IDataItem getDataCustomItem(byte type, int code, GenericDataItem item) throws LocalizationException {
        try {
            return item.getCustomData(type, code);
        }
        catch (NoSuchElementException e) {
            return null;
        }
        catch (MMJETypeArraySizeExceededException e) {
            throw new LocalizationException(e);
        }
        catch (InvalidCustomDataTypeException e) {
            throw new LocalizationException(e);
        }
    }
}

