/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.binary;

import com.mapinfo.mapmarker.common.dp.binary.DataFileMasks;
import com.mapinfo.mapmarker.common.dp.binary.DataFileStatistics;
import com.mapinfo.mapmarker.common.dp.binary.GenericDataItem;
import com.mapinfo.mapmarker.common.dp.binary.ICustomDataHandler;
import com.mapinfo.mapmarker.common.dp.binary.IDataFileDataItem;
import com.mapinfo.mapmarker.common.dp.binary.MMJDataFileMetadata;
import com.mapinfo.mapmarker.common.dp.binary.MMJEDataCorruptedException;
import com.mapinfo.mapmarker.common.dp.binary.TypeMask;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class GeoInfoDataItem
extends GenericDataItem
implements IDataFileDataItem {
    public GeoInfoDataItem() {
    }

    public GeoInfoDataItem(ICustomDataHandler handler) {
        super(handler);
    }

    @Override
    public void read(DataInput in, MMJDataFileMetadata metadata) throws IOException, MMJEDataCorruptedException {
        DataFileMasks masks = metadata.getDataFileMasks();
        short maskID = (short)in.readUnsignedByte();
        TypeMask mask = null;
        if (masks != null && maskID != 0) {
            mask = masks.getIndexedTypeMask((byte)4, maskID);
        }
        if (mask == null) {
            mask = new TypeMask();
            mask.read(in);
        }
        super.read(in, mask);
    }

    @Override
    public void write(DataOutput out, MMJDataFileMetadata metadata) throws IOException, MMJEDataCorruptedException {
        DataFileMasks masks = metadata.getDataFileMasks();
        short maskID = 0;
        TypeMask mask = super.getMask();
        if (masks != null) {
            maskID = masks.getTypeMaskIndex((byte)4, mask);
        }
        DataFileStatistics.getStatisticsInstance().logMask((byte)4, mask, maskID);
        out.writeByte(maskID);
        super.write(out, mask, maskID == 0);
    }
}

