/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.binary;

import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.ICandidate;
import com.mapinfo.mapmarker.common.InternalGeographicCandidate;
import com.mapinfo.mapmarker.common.dp.DataAccessException;
import com.mapinfo.mapmarker.common.dp.binary.AbstractDataItemFetcher;
import com.mapinfo.mapmarker.common.dp.binary.DataDictionaryIntializationException;
import com.mapinfo.mapmarker.common.dp.binary.GeoInfoPreLoadedDataHelper;
import com.mapinfo.mapmarker.common.dp.binary.GeoInfoRecord;
import com.mapinfo.mapmarker.common.dp.binary.IDataAccess;
import com.mapinfo.mapmarker.common.dp.binary.IDataAccessHelper;
import com.mapinfo.mapmarker.common.dp.binary.IGeoInfoFetcher;
import com.mapinfo.mapmarker.common.dp.binary.LocalizationException;
import com.mapinfo.mapmarker.common.dp.binary.MMJEDataCorruptedException;
import com.mapinfo.mapmarker.common.dp.binary.PreLoadedData;
import com.mapinfo.mapmarker.common.dp.binary.index.IMapMarkerIndex;
import com.mapinfo.mapmarker.common.dp.binary.index.IMapMarkerReadOnlyIndexFile;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexMultiValue;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexSingleValue;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexValue;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;

public class GeoInfoFetcherImpl
extends AbstractDataItemFetcher
implements IGeoInfoFetcher {
    protected static final String NO_GEOINFO_DATA_FILE = "exception.no.data.geoinfo";
    protected static final String GEOINFO_DATA_FILE_OPEN = "exception.open.data.geoinfo";
    protected static final String GEOINFO_DATA_FILE_ACCESS = "exception.access.data.geoinfo";
    protected static final String NO_GEOINFO_INDEX_FILE = "exception.no.index.geoinfo";
    protected static final String GEOINFO_INDEX_FILE_OPEN = "exception.open.index.geoinfo";
    protected static final String GEOINFO_INDEX_FILE_ACCESS = "exception.access.index.geoinfo";
    private final String m_dataPath;
    private IDataAccess m_dataAccess;
    private IMapMarkerIndex m_index;

    public GeoInfoFetcherImpl(String dataPath, Properties localSettings, Properties localMessages) throws DataDictionaryIntializationException {
        this(dataPath, localSettings, localMessages, true);
    }

    protected GeoInfoFetcherImpl(String dataPath, Properties localSettings, Properties localMessages, boolean initNow) throws DataDictionaryIntializationException {
        super(localSettings, localMessages);
        this.m_dataPath = dataPath;
        if (initNow) {
            this.init();
        }
    }

    protected String getDataPath() {
        return this.m_dataPath;
    }

    protected void init() throws DataDictionaryIntializationException {
        try {
            this.m_dataAccess = this.getDataAccessType();
            this.m_dataAccess.init(StringUtilities.appendToPath(this.m_dataPath, this.getGeoInfoFileName()));
        }
        catch (FileNotFoundException e) {
            throw new DataDictionaryIntializationException(NO_GEOINFO_DATA_FILE, e);
        }
        catch (IOException e) {
            throw new DataDictionaryIntializationException(GEOINFO_DATA_FILE_OPEN, e);
        }
        catch (DataAccessException e) {
            throw new DataDictionaryIntializationException(GEOINFO_DATA_FILE_ACCESS, e);
        }
        this.m_index = this.getGeoInfoIndexType();
        if (this.m_index != null) {
            try {
                ((IMapMarkerReadOnlyIndexFile)this.m_index).open(StringUtilities.appendToPath(this.m_dataPath, this.getGeoInfoIndexFileName()));
            }
            catch (FileNotFoundException e) {
                throw new DataDictionaryIntializationException(NO_GEOINFO_INDEX_FILE, e);
            }
            catch (IOException e) {
                throw new DataDictionaryIntializationException(GEOINFO_INDEX_FILE_OPEN, e);
            }
        }
    }

    @Override
    public void close() throws DataAccessException {
        if (this.m_index != null) {
            try {
                ((IMapMarkerReadOnlyIndexFile)this.m_index).close();
                this.m_index = null;
            }
            catch (IOException IOEx) {
                throw new DataAccessException(2102, (Throwable)IOEx);
            }
        }
    }

    protected IMapMarkerIndex getIndex() {
        return this.m_index;
    }

    protected IDataAccess getDataAccess() {
        return this.m_dataAccess;
    }

    protected IDataAccessHelper getDataAccessHelperType() {
        return new GeoInfoPreLoadedDataHelper();
    }

    protected IDataAccess getDataAccessType() {
        return new PreLoadedData(this.getDataAccessHelperType());
    }

    protected String getGeoInfoFileName() {
        return "geoinfo.jdr";
    }

    protected IMapMarkerIndex getGeoInfoIndexType() {
        return null;
    }

    protected String getGeoInfoIndexFileName() {
        return null;
    }

    protected InternalGeographicCandidate makeInternalGeographicCandidate() {
        return new InternalGeographicCandidate();
    }

    protected MapMarkerIndexKey[] makeGeoInfoIndexKeys(Address addr, IConstraints constraints) {
        return null;
    }

    protected long[] getGeoInfoIndexOffsets(MapMarkerIndexValue value) {
        long[] values = null;
        if (value instanceof MapMarkerIndexSingleValue) {
            values = new long[]{((MapMarkerIndexSingleValue)value).getOffset()};
        } else if (value instanceof MapMarkerIndexMultiValue) {
            MapMarkerIndexMultiValue multiValue = (MapMarkerIndexMultiValue)value;
            values = new long[multiValue.getValueCount()];
            for (short i = 0; i < multiValue.getValueCount(); i = (short)(i + 1)) {
                values[i] = multiValue.getOffsetAt(i);
            }
        }
        return values;
    }

    @Override
    public List getGeoInfoCandidates(Address addr, IConstraints constraints) throws IOException, LocalizationException, MMJEDataCorruptedException {
        ArrayList<ICandidate> candidates = null;
        if (this.m_index == null) {
            return candidates;
        }
        MapMarkerIndexKey[] keys = this.makeGeoInfoIndexKeys(addr, constraints);
        if (keys != null) {
            candidates = new ArrayList<ICandidate>(keys.length);
            HashSet<Long> usedOffsets = new HashSet<Long>();
            for (int i = 0; i < keys.length; ++i) {
                MapMarkerIndexValue value = this.m_index.search(keys[i]);
                if (value == null) continue;
                long[] offsets = this.getGeoInfoIndexOffsets(value);
                for (int j = 0; j < offsets.length; ++j) {
                    if (usedOffsets.contains(offsets[j])) continue;
                    GeoInfoRecord record = null;
                    try {
                        record = (GeoInfoRecord)this.m_dataAccess.getRecord(offsets[j]);
                        usedOffsets.add(offsets[j]);
                    }
                    catch (DataAccessException dataAccessException) {
                        // empty catch block
                    }
                    if (record == null) continue;
                    candidates.add(this.makeGeoInfoCandidate(record));
                }
            }
            if (candidates.isEmpty()) {
                candidates = null;
            }
        }
        return candidates;
    }

    @Override
    public GeoInfoRecord getGeoInfoRecord(long offset) {
        GeoInfoRecord record = null;
        try {
            record = (GeoInfoRecord)this.m_dataAccess.getRecord(offset);
        }
        catch (DataAccessException dataAccessException) {
            // empty catch block
        }
        return record;
    }

    protected ICandidate makeGeoInfoCandidate(GeoInfoRecord record) {
        InternalGeographicCandidate candidate = this.makeInternalGeographicCandidate();
        candidate.setCountry(this.m_dataAccess.getMetadata().getCountry());
        candidate.setVendorCode(String.valueOf(this.m_dataAccess.getMetadata().getVendorCode()));
        candidate.setGeoInfoRecord(record);
        return candidate;
    }
}

