/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.binary;

import com.mapinfo.mapmarker.utils.SeekableDataInput;
import com.mapinfo.mapmarker.utils.SeekableDataInputNIO;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class IndexFileCache {
    private Map<String, SeekableDataInput> m_indexFiles = new HashMap<String, SeekableDataInput>();

    public SeekableDataInput getIndexFile(String fileName) throws IOException {
        SeekableDataInput indexFile = this.m_indexFiles.get(fileName);
        if (indexFile == null) {
            indexFile = new SeekableDataInputNIO(new File(fileName), true);
            this.m_indexFiles.put(fileName, indexFile);
        }
        return indexFile;
    }

    public void closeAll() throws IOException {
        IOException exception = null;
        if (!this.m_indexFiles.isEmpty()) {
            Collection<SeekableDataInput> files = this.m_indexFiles.values();
            for (SeekableDataInput file : files) {
                try {
                    file.close();
                }
                catch (IOException IOEx) {
                    if (exception != null) continue;
                    exception = IOEx;
                }
            }
            this.m_indexFiles.clear();
        }
        if (exception != null) {
            throw exception;
        }
    }
}

