/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.binary;

import com.mapinfo.mapmarker.common.dp.FatalDataAccessException;
import com.mapinfo.mapmarker.common.dp.FatalDataAccessRuntimeException;
import com.mapinfo.mapmarker.common.dp.binary.DataFileMasks;
import com.mapinfo.mapmarker.common.dp.binary.GenericDataItem;
import com.mapinfo.mapmarker.common.dp.binary.MMJEDataCorruptedException;
import com.mapinfo.mapmarker.common.dp.binary.MMJETypeArraySizeExceededException;
import com.mapinfo.mapmarker.common.dp.binary.VendorDataType;
import com.mapinfo.mapmarker.utils.MiVersion;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class MMJDataFileMetadata {
    private static final int VENDOR_ID_BYTE = 0;
    private String m_copyRight = "Copyright (c) 1985-2012, Pitney Bowes Software, Inc. All rights reserved. Confidential Property of Pitney Bowes Software, Inc.";
    private MiVersion m_version = null;
    private String m_country = "";
    private DataFileMasks m_masks = null;
    private byte m_xPow10 = 0;
    private byte m_yPow10 = 0;
    private long m_xFactor = 1L;
    private long m_yFactor = 1L;
    private static final MiVersion METADATA_UPGRADE_VERSION = new MiVersion(-1, -1, -1);
    private GenericDataItem m_item = new GenericDataItem();

    public void setVersion(MiVersion version) {
        this.m_version = version;
    }

    public MiVersion getVersion() {
        return this.m_version;
    }

    public void setCopyRight(String copyRight) {
        this.m_copyRight = copyRight;
    }

    public String getCopyRight() {
        return this.m_copyRight;
    }

    public void setDataFileMasks(DataFileMasks masks) {
        this.m_masks = masks;
    }

    public DataFileMasks getDataFileMasks() {
        return this.m_masks;
    }

    public String getCountry() {
        return this.m_country;
    }

    public void setCountry(String country) {
        this.m_country = country;
    }

    public void setXPow10(byte xPow10) {
        this.m_xPow10 = xPow10;
        this.m_xFactor = (long)Math.pow(10.0, this.m_xPow10);
    }

    public byte getXPow10() {
        return this.m_xPow10;
    }

    public long getXFactor() {
        return this.m_xFactor;
    }

    public void setYPow10(byte yPow10) {
        this.m_yPow10 = yPow10;
        this.m_yFactor = (long)Math.pow(10.0, this.m_yPow10);
    }

    public byte getYPow10() {
        return this.m_yPow10;
    }

    public long getYFactor() {
        return this.m_yFactor;
    }

    public void setVendorCode(int vendorCode) {
        try {
            this.m_item.putUnsignedByte(0, (short)vendorCode);
        }
        catch (MMJETypeArraySizeExceededException MMJETASEEx) {
            throw new FatalDataAccessRuntimeException(new FatalDataAccessException(2101, (Throwable)MMJETASEEx));
        }
    }

    public int getVendorCode() {
        if (this.m_item.hasUnsignedByte(0)) {
            try {
                return this.m_item.getUnsignedByte(0);
            }
            catch (MMJETypeArraySizeExceededException MMJETASEEx) {
                throw new FatalDataAccessRuntimeException(new FatalDataAccessException(2101, (Throwable)MMJETASEEx));
            }
        }
        return VendorDataType.DATATYPE_UNKNOWN_VENDOR.getDataType();
    }

    public void read(DataInput in) throws IOException {
        this.m_copyRight = in.readUTF();
        this.m_version = MiVersion.read(in);
        this.m_country = in.readUTF();
        this.m_masks = new DataFileMasks();
        this.m_masks.read(in);
        this.setXPow10(in.readByte());
        this.setYPow10(in.readByte());
        if (this.m_version.compareTo(METADATA_UPGRADE_VERSION) == 0) {
            this.m_version = MiVersion.read(in);
            try {
                this.m_item.read(in, null);
            }
            catch (MMJEDataCorruptedException MMJEDCEx) {
                throw new IOException(MMJEDCEx);
            }
        }
    }

    public void write(DataOutput out) throws IOException {
        out.writeUTF(this.m_copyRight);
        METADATA_UPGRADE_VERSION.write(out);
        out.writeUTF(this.m_country);
        this.m_masks.write(out);
        out.writeByte(this.m_xPow10);
        out.writeByte(this.m_yPow10);
        this.m_version.write(out);
        try {
            this.m_item.write(out);
        }
        catch (MMJEDataCorruptedException MMJEDCEx) {
            throw new IOException(MMJEDCEx);
        }
    }

    public void shallowCopy(MMJDataFileMetadata src) {
        this.m_copyRight = src.m_copyRight;
        this.m_version = src.m_version;
        this.m_masks = src.getDataFileMasks();
        this.m_country = src.getCountry();
        this.setXPow10(src.m_xPow10);
        this.setYPow10(src.m_yPow10);
        this.m_item = src.m_item;
    }
}

