/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.binary;

import com.mapinfo.mapmarker.EngineInitModel;
import com.mapinfo.mapmarker.common.dp.binary.IGeoBase;
import com.mapinfo.mapmarker.common.dp.binary.MMJEDataCorruptedException;
import com.mapinfo.mapmarker.common.dp.binary.MMJGeo2SacRecord;
import com.mapinfo.mapmarker.common.dp.binary.SacData;
import com.mapinfo.mapmarker.common.dp.binary.SacMetadata;
import com.mapinfo.mapmarker.utils.SeekableDataInputStream;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class MMJGeo2SacData {
    public static final String GEO2SAC_FILE_NAME = "geo2sac.mmj";
    private MMJGeo2SacRecord m_recordType;
    private String m_dataPath;
    private int m_hashMapSize;
    private long m_dataStartOffset;
    private boolean m_bLoaded;
    private Map<IGeoBase, SacData> m_map;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MMJGeo2SacData(MMJGeo2SacRecord recordType, SacMetadata metadataType, String dataPath) throws IOException, MMJEDataCorruptedException {
        this.m_dataPath = dataPath;
        this.m_recordType = recordType;
        try (SeekableDataInputStream in = this.getStream();){
            SacMetadata metadata = metadataType.newInstance();
            metadata.read(in);
            this.m_dataStartOffset = in.getFilePointer();
            this.m_hashMapSize = metadata.getNumberOfEntries();
            if (this.m_hashMapSize == 0) {
                this.m_hashMapSize = 8300;
            }
            if (!EngineInitModel.useQuickInit()) {
                this.load();
            }
        }
    }

    public SacData getSacForGeoBase(IGeoBase base) {
        return this.m_map.get(base);
    }

    protected void addSacForGeoBase(IGeoBase base, SacData info) {
        this.m_map.put(base, info);
    }

    protected void initSacMap() {
        this.m_map = new HashMap<IGeoBase, SacData>(this.m_hashMapSize + 1, 1.0f);
    }

    protected void optimizeSacMap() {
        this.m_map = Collections.unmodifiableMap(this.m_map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void load() throws IOException, MMJEDataCorruptedException {
        try (SeekableDataInputStream in = this.getStream();){
            in.seek(this.m_dataStartOffset);
            this.initSacMap();
            boolean bCont = true;
            while (bCont) {
                MMJGeo2SacRecord record = this.m_recordType.newInstance();
                try {
                    record.read(in);
                    this.addSacDataForRecord(record);
                }
                catch (EOFException EOFEx) {
                    bCont = false;
                }
            }
            this.optimizeSacMap();
            this.m_bLoaded = true;
        }
    }

    protected void addSacDataForRecord(MMJGeo2SacRecord record) {
        SacData info = this.getSacForGeoBase(record.getGeoBase());
        if (info == null) {
            info = new SacData();
            this.addSacForGeoBase(record.getGeoBase(), info);
        }
        info.addSac(record.getSac());
    }

    protected int getSize() {
        return this.m_hashMapSize;
    }

    protected boolean isLoaded() {
        return this.m_bLoaded;
    }

    private SeekableDataInputStream getStream() throws IOException {
        return new SeekableDataInputStream(new File(StringUtilities.appendToPath(this.m_dataPath, GEO2SAC_FILE_NAME)));
    }
}

