/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.binary;

import com.mapinfo.mapmarker.EngineInitModel;
import com.mapinfo.mapmarker.common.dp.binary.IPostalBase;
import com.mapinfo.mapmarker.common.dp.binary.MMJEDataCorruptedException;
import com.mapinfo.mapmarker.common.dp.binary.MMJPost2SacRecord;
import com.mapinfo.mapmarker.common.dp.binary.SacData;
import com.mapinfo.mapmarker.common.dp.binary.SacMetadata;
import com.mapinfo.mapmarker.utils.SeekableDataInputStream;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;

public class MMJPost2SacData {
    public static final String POST2SAC_FILE_NAME = "post2sac.mmj";
    private String m_dataPath;
    private MMJPost2SacRecord m_recordType;
    private int m_hashMapSize;
    private long m_dataStartOffset;
    private boolean m_bLoaded;
    private HashMap m_map;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MMJPost2SacData(MMJPost2SacRecord recordType, SacMetadata metadataType, String dataPath) throws IOException, MMJEDataCorruptedException {
        this.m_dataPath = dataPath;
        this.m_recordType = recordType;
        try (SeekableDataInputStream in = this.getStream();){
            SacMetadata metadata = metadataType.newInstance();
            metadata.read(in);
            this.m_dataStartOffset = in.getFilePointer();
            this.m_hashMapSize = metadata.getNumberOfEntries();
            if (this.m_hashMapSize == 0) {
                this.m_hashMapSize = 8300;
            }
            if (!EngineInitModel.useQuickInit()) {
                this.load();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void load() throws IOException, MMJEDataCorruptedException {
        try (SeekableDataInputStream in = this.getStream();){
            in.seek(this.m_dataStartOffset);
            this.m_map = new HashMap(this.m_hashMapSize + 1, 1.0f);
            boolean bCont = true;
            while (bCont) {
                MMJPost2SacRecord record = this.m_recordType.newInstance();
                try {
                    record.read(in);
                    SacData info = (SacData)this.m_map.get(record.getPostalBase());
                    if (info == null) {
                        info = new SacData();
                        this.m_map.put(record.getPostalBase(), info);
                    }
                    info.addSac(record.getSac());
                }
                catch (EOFException EOFEx) {
                    bCont = false;
                }
            }
            this.m_bLoaded = true;
        }
    }

    public SacData getSacForPostalBase(IPostalBase base) {
        return (SacData)this.m_map.get(base);
    }

    protected boolean isLoaded() {
        return this.m_bLoaded;
    }

    private SeekableDataInputStream getStream() throws IOException {
        return new SeekableDataInputStream(new File(StringUtilities.appendToPath(this.m_dataPath, POST2SAC_FILE_NAME)));
    }
}

