/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.binary;

import com.mapinfo.mapmarker.common.dp.binary.CompressedSegment;
import com.mapinfo.mapmarker.common.dp.binary.ICompressedSegment;
import com.mapinfo.mapmarker.common.dp.binary.SegmentCompressionException;
import com.mapinfo.mapmarker.utils.DataInputUtilities;
import com.mapinfo.mapmarker.utils.LongPoint;
import com.mapinfo.midev.geometry.DirectPosition;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;

public class NoModCompressedSegment
implements ICompressedSegment {
    private int m_mask = 0;
    private short m_numPoints;
    private byte m_xPow10;
    private byte m_yPow10;
    private long m_xFactor;
    private long m_yFactor;
    private LongPoint[] m_longPnts;
    private LongPoint[] m_offsets;
    private byte[] m_data;
    private LongPoint m_origin;
    private byte m_firstPairInfo;
    private byte m_otherPointsInfo;
    private static final long MAX_4_BITS = 8L;
    private static final long MAX_8_BITS = 128L;
    private static final long MAX_12_BITS = 2048L;
    private static final long MAX_16_BITS = 32768L;
    private static final long MAX_20_BITS = 524288L;
    private static final long MAX_24_BITS = 0x800000L;
    private static final long MAX_28_BITS = 0x8000000L;
    private static final long MAX_32_BITS = 0x80000000L;
    private static final byte DELTA_TOO_LARGE = -1;
    private static final byte DELTA_AS_4_BITS = 0;
    private static final byte DELTA_AS_8_BITS = 1;
    private static final byte DELTA_AS_12_BITS = 2;
    private static final byte DELTA_AS_16_BITS = 3;
    private static final byte DELTA_AS_20_BITS = 4;
    private static final byte DELTA_AS_24_BITS = 5;
    private static final byte DELTA_AS_28_BITS = 6;
    private static final byte DELTA_AS_32_BITS = 7;
    private static final byte BYTE_POINT_COUNT = 0;
    private static final byte SHORT_POINT_COUNT = 1;
    private static final byte MAX_INTERNAL_POINT_COUNT = 15;

    public NoModCompressedSegment() {
        this(null, 0, 0);
    }

    public NoModCompressedSegment(byte[] bytes) throws IOException {
        this();
        ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
        this.read(new DataInputStream(stream));
    }

    public NoModCompressedSegment(DirectPosition[] doublePoints, byte xPow10, byte yPow10) {
        this.m_xPow10 = xPow10;
        this.m_yPow10 = yPow10;
        this.m_xFactor = this.m_xPow10 != 0 ? (long)Math.pow(10.0, this.m_xPow10) : 1L;
        this.m_yFactor = this.m_yPow10 != 0 ? (long)Math.pow(10.0, this.m_yPow10) : 1L;
        this.m_longPnts = this.convertToLongPoints(doublePoints);
        if (this.m_longPnts == null) {
            this.m_numPoints = 0;
            this.m_offsets = null;
        } else {
            this.m_numPoints = (short)this.m_longPnts.length;
        }
        this.m_origin = null;
    }

    public void setPow10(byte xPow10, byte yPow10, long xFactor, long yFactor) {
        this.m_xPow10 = xPow10;
        this.m_yPow10 = yPow10;
        this.m_xFactor = xFactor;
        this.m_yFactor = yFactor;
    }

    @Override
    public void setOrigin(DirectPosition origin) {
        if (origin != null) {
            long x = CompressedSegment.convertDoubleToLongAndRound(origin.getX(), this.m_xFactor);
            long y = CompressedSegment.convertDoubleToLongAndRound(origin.getY(), this.m_yFactor);
            this.m_origin = new LongPoint(x, y);
        }
    }

    @Override
    public DirectPosition[] convert() {
        this.recreateLongPoints();
        return this.convertToPoints();
    }

    @Override
    public short getNumberPoints() {
        return this.m_numPoints;
    }

    @Override
    public long getXFactor() {
        return this.m_xFactor;
    }

    @Override
    public long getYFactor() {
        return this.m_xFactor;
    }

    private LongPoint[] convertToLongPoints(DirectPosition[] points) {
        if (points == null || points.length == 0) {
            return null;
        }
        LongPoint[] longPnts = points.length == 1 ? new LongPoint[2] : new LongPoint[points.length];
        for (int i = 0; i < points.length; ++i) {
            long newX = CompressedSegment.convertDoubleToLongAndRound(points[i].getX(), this.m_xFactor);
            long newY = CompressedSegment.convertDoubleToLongAndRound(points[i].getY(), this.m_yFactor);
            longPnts[i] = new LongPoint(newX, newY);
        }
        if (points.length == 1) {
            longPnts[1] = longPnts[0];
        }
        return longPnts;
    }

    private void recreateLongPoints() {
        if (this.m_offsets == null) {
            this.recreateOffsets();
        }
        this.m_longPnts = new LongPoint[this.m_numPoints];
        this.m_longPnts[0] = this.m_origin != null ? new LongPoint(this.m_origin.getX() - this.m_offsets[0].getX(), this.m_origin.getY() - this.m_offsets[0].getY()) : new LongPoint(this.m_offsets[0].getX(), this.m_offsets[0].getY());
        this.m_longPnts[1] = new LongPoint(this.m_longPnts[0].getX() - this.m_offsets[1].getX(), this.m_longPnts[0].getY() - this.m_offsets[1].getY());
        for (int i = 2; i < this.m_numPoints; ++i) {
            long currentXDelta = this.computeDelta(this.m_longPnts[i - 2].getX(), this.m_longPnts[i - 1].getX());
            long currentYDelta = this.computeDelta(this.m_longPnts[i - 2].getY(), this.m_longPnts[i - 1].getY());
            long probableXCoord = this.m_longPnts[i - 1].getX() - currentXDelta;
            long probableYCoord = this.m_longPnts[i - 1].getY() - currentYDelta;
            this.m_longPnts[i] = new LongPoint(probableXCoord - this.m_offsets[i].getX(), probableYCoord - this.m_offsets[i].getY());
        }
    }

    private DirectPosition[] convertToPoints() {
        DirectPosition[] points = new DirectPosition[this.m_longPnts.length];
        for (int i = 0; i < this.m_longPnts.length; ++i) {
            double newX = (double)this.m_longPnts[i].getX() / (double)this.m_xFactor;
            double newY = (double)this.m_longPnts[i].getY() / (double)this.m_yFactor;
            points[i] = new DirectPosition(newX, newY);
        }
        return points;
    }

    private byte encodePointCount() throws SegmentCompressionException {
        if (this.m_numPoints > 65535) {
            throw new SegmentCompressionException("Point count does not conform to compression scheme.");
        }
        if (this.m_numPoints > 255) {
            return 1;
        }
        if (this.m_numPoints > 15) {
            return 0;
        }
        return (byte)this.m_numPoints;
    }

    private long computeDelta(long coord1, long coord2) {
        return coord1 - coord2;
    }

    private void computeOffsets() {
        this.m_offsets = new LongPoint[this.m_longPnts.length];
        this.m_offsets[0] = this.m_origin != null ? new LongPoint(this.computeDelta(this.m_origin.getX(), this.m_longPnts[0].getX()), this.computeDelta(this.m_origin.getY(), this.m_longPnts[0].getY())) : new LongPoint(this.m_longPnts[0].getX(), this.m_longPnts[0].getY());
        this.m_offsets[1] = new LongPoint(this.computeDelta(this.m_longPnts[0].getX(), this.m_longPnts[1].getX()), this.computeDelta(this.m_longPnts[0].getY(), this.m_longPnts[1].getY()));
        for (int i = 2; i < this.m_longPnts.length; ++i) {
            long currentXDelta = this.computeDelta(this.m_longPnts[i - 2].getX(), this.m_longPnts[i - 1].getX());
            long currentYDelta = this.computeDelta(this.m_longPnts[i - 2].getY(), this.m_longPnts[i - 1].getY());
            long probableXCoord = this.m_longPnts[i - 1].getX() - currentXDelta;
            long probableYCoord = this.m_longPnts[i - 1].getY() - currentYDelta;
            long actualXDelta = this.computeDelta(probableXCoord, this.m_longPnts[i].getX());
            long actualYDelta = this.computeDelta(probableYCoord, this.m_longPnts[i].getY());
            this.m_offsets[i] = new LongPoint(actualXDelta, actualYDelta);
        }
    }

    private long max(long value1, long value2) {
        if (value1 > value2) {
            return value1;
        }
        return value2;
    }

    private byte getDeltaType(long delta) {
        if (delta < 8L) {
            return 0;
        }
        if (delta < 128L) {
            return 1;
        }
        if (delta < 2048L) {
            return 2;
        }
        if (delta < 32768L) {
            return 3;
        }
        if (delta < 524288L) {
            return 4;
        }
        if (delta < 0x800000L) {
            return 5;
        }
        if (delta < 0x8000000L) {
            return 6;
        }
        if (delta < 0x80000000L) {
            return 7;
        }
        return -1;
    }

    private byte getDeltaBitCount(byte deltaType) {
        switch (deltaType) {
            case 0: {
                return 4;
            }
            case 1: {
                return 8;
            }
            case 2: {
                return 12;
            }
            case 3: {
                return 16;
            }
            case 4: {
                return 20;
            }
            case 5: {
                return 24;
            }
            case 6: {
                return 28;
            }
            case 7: {
                return 32;
            }
        }
        return 0;
    }

    private short encodeFirstPair() throws SegmentCompressionException {
        long maxXDelta = this.max(Math.abs(this.m_offsets[0].getX()), Math.abs(this.m_offsets[1].getX()));
        long maxYDelta = this.max(Math.abs(this.m_offsets[0].getY()), Math.abs(this.m_offsets[1].getY()));
        byte XDeltaStorage = this.getDeltaType(maxXDelta);
        byte YDeltaStorage = this.getDeltaType(maxYDelta);
        if (XDeltaStorage == -1 || YDeltaStorage == -1) {
            throw new SegmentCompressionException("First pair does not conform to compression scheme.");
        }
        return (short)(XDeltaStorage << 3 | YDeltaStorage);
    }

    private byte encodeOtherPoints() throws SegmentCompressionException {
        if (this.m_numPoints < 3) {
            return 0;
        }
        long maxXDelta = Long.MIN_VALUE;
        long maxYDelta = Long.MIN_VALUE;
        for (int i = 2; i < this.m_offsets.length; ++i) {
            maxXDelta = this.max(Math.abs(this.m_offsets[i].getX()), maxXDelta);
            maxYDelta = this.max(Math.abs(this.m_offsets[i].getY()), maxYDelta);
        }
        byte XDeltaStorage = this.getDeltaType(maxXDelta);
        byte YDeltaStorage = this.getDeltaType(maxYDelta);
        if (XDeltaStorage == -1 || YDeltaStorage == -1) {
            throw new SegmentCompressionException("Other points do not conform to compression scheme.");
        }
        return (byte)(XDeltaStorage << 3 | YDeltaStorage);
    }

    private void enocodePointInfo() throws SegmentCompressionException {
        byte pointCountInfo = this.encodePointCount();
        short firstPairInfo = this.encodeFirstPair();
        byte otherPointsInfo = this.encodeOtherPoints();
        this.m_mask = otherPointsInfo << 10 | firstPairInfo << 4 | pointCountInfo;
    }

    private byte decodePointCount() {
        return (byte)(this.m_mask & 0xF);
    }

    private byte decodeFirstPair() {
        return (byte)(this.m_mask >> 4 & 0x3F);
    }

    private byte decodeOtherPointsInfo() {
        return (byte)(this.m_mask >> 10 & 0x3F);
    }

    private void fillDataByteArray(byte firstPairInfo, byte otherPointsInfo) {
        byte firstPairXNumBits = this.getDeltaBitCount((byte)(firstPairInfo >> 3));
        byte firstPairYNumBits = this.getDeltaBitCount((byte)(firstPairInfo & 7));
        this.putValue(this.m_data, this.m_offsets[0].getX(), 0, firstPairXNumBits);
        this.putValue(this.m_data, this.m_offsets[0].getY(), firstPairXNumBits, firstPairYNumBits);
        this.putValue(this.m_data, this.m_offsets[1].getX(), firstPairXNumBits + firstPairYNumBits, firstPairXNumBits);
        this.putValue(this.m_data, this.m_offsets[1].getY(), firstPairXNumBits * 2 + firstPairYNumBits, firstPairYNumBits);
        if (this.m_numPoints > 2) {
            int start = 2 * (firstPairXNumBits + firstPairYNumBits);
            byte otherXNumBits = this.getDeltaBitCount((byte)(otherPointsInfo >> 3));
            byte otherYNumBits = this.getDeltaBitCount((byte)(otherPointsInfo & 7));
            for (int i = 2; i < this.m_offsets.length; ++i) {
                this.putValue(this.m_data, this.m_offsets[i].getX(), start, otherXNumBits);
                this.putValue(this.m_data, this.m_offsets[i].getY(), start + otherXNumBits, otherYNumBits);
                start = start + otherXNumBits + otherYNumBits;
            }
        }
    }

    private int getPointCount(DataInput in) throws IOException {
        byte decodedPointCount = this.decodePointCount();
        if (decodedPointCount == 0) {
            return in.readUnsignedByte();
        }
        if (decodedPointCount == 1) {
            return in.readUnsignedShort();
        }
        return decodedPointCount;
    }

    private int computeTotalBytes(int totalPoints, byte firstPairInfo, byte otherPointsInfo) {
        long firstPairXBits = this.getDeltaBitCount((byte)(firstPairInfo >> 3));
        long firstPairYBits = this.getDeltaBitCount((byte)(firstPairInfo & 7));
        long totalBits = 4L;
        totalBits += (firstPairXBits + firstPairYBits) * 2L;
        if (totalPoints > 2) {
            int otherPoints = totalPoints - 2;
            long otherXBits = this.getDeltaBitCount((byte)(otherPointsInfo >> 3));
            long otherYBits = this.getDeltaBitCount((byte)(otherPointsInfo & 7));
            totalBits += (long)otherPoints * (otherXBits + otherYBits);
        }
        return (int)(totalBits / 8L);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        this.computeOffsets();
        this.enocodePointInfo();
        out.writeShort(this.m_mask);
        byte encodedPointCount = this.decodePointCount();
        byte firstPairInfo = this.decodeFirstPair();
        byte otherPointsInfo = this.decodeOtherPointsInfo();
        if (encodedPointCount == 0) {
            out.writeByte(this.m_numPoints);
        } else if (encodedPointCount == 1) {
            out.writeShort(this.m_numPoints);
        }
        this.m_data = new byte[this.computeTotalBytes(this.m_numPoints, firstPairInfo, otherPointsInfo)];
        this.fillDataByteArray(firstPairInfo, otherPointsInfo);
        for (int i = 0; i < this.m_data.length; ++i) {
            out.writeByte(this.m_data[i]);
        }
    }

    public byte[] toBytes() throws IOException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        this.write(new DataOutputStream(stream));
        return stream.toByteArray();
    }

    private void recreateOffsets() {
        byte firstPairXNumBits = this.getDeltaBitCount((byte)(this.m_firstPairInfo >> 3));
        byte firstPairYNumBits = this.getDeltaBitCount((byte)(this.m_firstPairInfo & 7));
        this.m_offsets = new LongPoint[this.m_numPoints];
        this.m_offsets[0] = new LongPoint(this.getValue(this.m_data, 0, firstPairXNumBits), this.getValue(this.m_data, firstPairXNumBits, firstPairYNumBits));
        this.m_offsets[1] = new LongPoint(this.getValue(this.m_data, firstPairXNumBits + firstPairYNumBits, firstPairXNumBits), this.getValue(this.m_data, firstPairYNumBits + 2 * firstPairXNumBits, firstPairYNumBits));
        if (this.m_numPoints > 2) {
            int start = 2 * (firstPairXNumBits + firstPairYNumBits);
            byte otherXNumBits = this.getDeltaBitCount((byte)(this.m_otherPointsInfo >> 3));
            byte otherYNumBits = this.getDeltaBitCount((byte)(this.m_otherPointsInfo & 7));
            for (int i = 2; i < this.m_numPoints; ++i) {
                this.m_offsets[i] = new LongPoint(this.getValue(this.m_data, start, otherXNumBits), this.getValue(this.m_data, start + otherXNumBits, otherYNumBits));
                start = start + otherXNumBits + otherYNumBits;
            }
        }
    }

    @Override
    public void read(DataInput in) throws IOException {
        this.m_mask = in.readUnsignedShort();
        this.m_numPoints = (short)this.getPointCount(in);
        this.m_firstPairInfo = this.decodeFirstPair();
        this.m_otherPointsInfo = this.decodeOtherPointsInfo();
        int totalBytes = this.computeTotalBytes(this.m_numPoints, this.m_firstPairInfo, this.m_otherPointsInfo);
        this.m_data = DataInputUtilities.readByteArray(in, totalBytes);
    }

    private byte getUnsignedLowHalf(byte b) {
        return (byte)(b & 0xF);
    }

    private byte getUnsignedHighHalf(byte b) {
        return (byte)(b >> 4 & 0xF);
    }

    private void putValue(byte[] bytes, long value, int startBit, int bitLength) {
        boolean byteBoundary = startBit % 8 == 0;
        boolean byteLength = bitLength % 8 == 0;
        int start = startBit / 8;
        int limit = bitLength / 8;
        if (byteBoundary) {
            if (byteLength) {
                for (int i = limit; i > 0; --i) {
                    bytes[start + limit - i] = (byte)(value >> 8 * (i - 1) & 0xFFL);
                }
            } else {
                for (int i = limit; i > 0; --i) {
                    byte b = (byte)(value >> 8 * (limit - i) & 0xFFL);
                    byte low = this.getUnsignedLowHalf(b);
                    byte high = this.getUnsignedHighHalf(b);
                    bytes[start + i] = (byte)(bytes[start + i] | low << 4);
                    bytes[start + i - 1] = (byte)(bytes[start + i - 1] | high);
                }
                bytes[start] = (byte)(bytes[start] | this.getUnsignedLowHalf((byte)(value >> 8 * limit)) << 4);
            }
        } else if (byteLength) {
            for (int i = limit; i > 0; --i) {
                byte b = (byte)(value >> 8 * (limit - i) & 0xFFL);
                byte low = this.getUnsignedLowHalf(b);
                byte high = this.getUnsignedHighHalf(b);
                bytes[start + i] = (byte)(bytes[start + i] | low << 4);
                bytes[start + i - 1] = (byte)(bytes[start + i - 1] | high);
            }
        } else {
            for (int i = limit; i > 0; --i) {
                bytes[start + i] = (byte)(value >> 8 * (limit - i) & 0xFFL);
            }
            bytes[start] = (byte)(bytes[start] | this.getUnsignedLowHalf((byte)(value >> 8 * limit)));
        }
    }

    private long getValue(byte[] bytes, int startBit, int bitLength) {
        byte t;
        int i;
        int limit;
        boolean byteBoundary = startBit % 8 == 0;
        boolean byteLength = bitLength % 8 == 0;
        int start = startBit / 8;
        byte[] temp = new byte[8];
        if (byteBoundary) {
            if (byteLength) {
                limit = 8 - bitLength / 8;
                for (i = 7; i > limit; --i) {
                    temp[i] = bytes[start + (i - limit)];
                }
                temp[limit] = bytes[start];
            } else {
                limit = 7 - bitLength / 8;
                for (i = 7; i > limit; --i) {
                    temp[i] = this.getUnsignedHighHalf(bytes[start + (i - limit)]);
                    temp[i] = (byte)(temp[i] | this.getUnsignedLowHalf(bytes[start + (i - limit) - 1]) << 4);
                }
                t = this.getUnsignedHighHalf(bytes[start]);
                if ((t & 8) != 0) {
                    t = (byte)(t | 0xF0);
                }
                temp[limit] = t;
            }
        } else if (byteLength) {
            limit = 8 - bitLength / 8;
            for (i = 7; i > limit; --i) {
                temp[i] = this.getUnsignedHighHalf(bytes[start + (i - limit + 1)]);
                temp[i] = (byte)(temp[i] | this.getUnsignedLowHalf(bytes[start + (i - limit)]) << 4);
            }
            t = this.getUnsignedLowHalf(bytes[start]);
            t = (byte)(t << 4);
            temp[limit] = (byte)(this.getUnsignedHighHalf(bytes[start + 1]) | t);
        } else {
            limit = 7 - bitLength / 8;
            for (i = 7; i > limit; --i) {
                temp[i] = bytes[start + (i - limit)];
            }
            t = this.getUnsignedLowHalf(bytes[start]);
            if ((t & 8) != 0) {
                t = (byte)(t | 0xF0);
            }
            temp[limit] = t;
        }
        long value = 0L;
        for (int i2 = 7; i2 > limit; --i2) {
            value |= (long)(temp[i2] & 0xFF) << 8 * (7 - i2);
        }
        return value |= (long)temp[limit] << 8 * (7 - limit);
    }
}

