/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.binary;

import com.mapinfo.mapmarker.common.dp.DataAccessException;
import com.mapinfo.mapmarker.common.dp.binary.IBulkDataAccess;
import com.mapinfo.mapmarker.common.dp.binary.IDataAccessHelper;
import com.mapinfo.mapmarker.common.dp.binary.IDataFileDataItem;
import com.mapinfo.mapmarker.common.dp.binary.LocalizationException;
import com.mapinfo.mapmarker.common.dp.binary.MMJDataFileMetadata;
import com.mapinfo.mapmarker.common.dp.binary.MMJEDataCorruptedException;
import com.mapinfo.mapmarker.utils.FileProviderFactory;
import com.mapinfo.mapmarker.utils.SeekableDataInput;
import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class OnDemandDataAccess
implements IBulkDataAccess {
    private IDataAccessHelper m_helper;
    private MMJDataFileMetadata m_metadata;
    private String m_fileSpec;

    public OnDemandDataAccess(IDataAccessHelper helper) {
        this.m_helper = helper;
        this.m_metadata = this.m_helper.getMetadataType();
    }

    @Override
    public void init(String fileSpec) throws IOException {
        this.m_fileSpec = fileSpec;
        try (FilterInputStream stream = null;){
            stream = new DataInputStream(new BufferedInputStream(new FileInputStream(this.m_fileSpec)));
            this.m_metadata.read((DataInput)((Object)stream));
        }
    }

    @Override
    public MMJDataFileMetadata getMetadata() {
        return this.m_metadata;
    }

    @Override
    public Object getRecord(long offset) throws DataAccessException {
        SeekableDataInput stream = null;
        try {
            stream = FileProviderFactory.getFileProvider().get(this.m_fileSpec);
            stream.seek(offset);
            IDataFileDataItem item = this.m_helper.getDataItemType();
            item.read(stream, this.m_metadata);
            Object object = this.m_helper.makeDataRecord(item, this.m_metadata);
            return object;
        }
        catch (LocalizationException LEx) {
            throw new DataAccessException(2100, (Throwable)LEx);
        }
        catch (MMJEDataCorruptedException MMJEDCEx) {
            throw new DataAccessException(2101, (Throwable)MMJEDCEx);
        }
        catch (IOException IOEx) {
            throw new DataAccessException(2102, (Throwable)IOEx);
        }
        finally {
            if (stream != null) {
                try {
                    FileProviderFactory.getFileProvider().release(stream);
                }
                catch (IOException IOEx) {
                    throw new DataAccessException(2102, (Throwable)IOEx);
                }
            }
        }
    }

    @Override
    public List<Object> getRecords(List<Long> offsets) throws DataAccessException {
        ArrayList<Object> results = new ArrayList<Object>(offsets.size());
        SeekableDataInput stream = null;
        try {
            stream = FileProviderFactory.getFileProvider().get(this.m_fileSpec);
            for (Long offset : offsets) {
                stream.seek(offset);
                IDataFileDataItem item = this.m_helper.getDataItemType();
                item.read(stream, this.m_metadata);
                results.add(this.m_helper.makeDataRecord(item, this.m_metadata));
            }
        }
        catch (LocalizationException LEx) {
            throw new DataAccessException(2100, (Throwable)LEx);
        }
        catch (MMJEDataCorruptedException MMJEDCEx) {
            throw new DataAccessException(2101, (Throwable)MMJEDCEx);
        }
        catch (IOException IOEx) {
            throw new DataAccessException(2102, (Throwable)IOEx);
        }
        finally {
            if (stream != null) {
                try {
                    FileProviderFactory.getFileProvider().release(stream);
                }
                catch (IOException IOEx) {
                    throw new DataAccessException(2102, (Throwable)IOEx);
                }
            }
        }
        return results;
    }

    protected IDataAccessHelper getHelper() {
        return this.m_helper;
    }

    protected String getFileSpec() {
        return this.m_fileSpec;
    }
}

