/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.binary;

import com.mapinfo.mapmarker.common.dp.DataAccessException;
import com.mapinfo.mapmarker.common.dp.binary.IDataAccess;
import com.mapinfo.mapmarker.common.dp.binary.IDataAccessHelper;
import com.mapinfo.mapmarker.common.dp.binary.IDataFileDataItem;
import com.mapinfo.mapmarker.common.dp.binary.LocalizationException;
import com.mapinfo.mapmarker.common.dp.binary.MMJDataFileMetadata;
import com.mapinfo.mapmarker.common.dp.binary.MMJEDataCorruptedException;
import com.mapinfo.mapmarker.utils.IntObjMap;
import com.mapinfo.mapmarker.utils.SeekableDataInputNIO;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;

public class PreLoadedData
implements IDataAccess {
    private final IntObjMap m_dataMap = new IntObjMap();
    private final IDataAccessHelper m_helper;
    private final MMJDataFileMetadata m_metadata;

    public PreLoadedData(IDataAccessHelper helper) {
        this.m_helper = helper;
        this.m_metadata = this.m_helper.getMetadataType();
    }

    @Override
    public MMJDataFileMetadata getMetadata() {
        return this.m_metadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(String fileSpec) throws IOException, DataAccessException {
        try (SeekableDataInputNIO stream = new SeekableDataInputNIO(new File(fileSpec));){
            stream.seek(0L);
            this.m_metadata.read(stream);
            long len = stream.length();
            try {
                while (true) {
                    IDataFileDataItem item = this.m_helper.getDataItemType();
                    long offset = stream.getFilePointer();
                    if (offset == len) {
                        break;
                    }
                    item.read(stream, this.m_metadata);
                    this.m_dataMap.put((int)offset, this.m_helper.makeDataRecord(item, this.m_metadata));
                }
            }
            catch (EOFException item) {
            }
            catch (MMJEDataCorruptedException MMJEDCEx) {
                throw new DataAccessException(2101, (Throwable)MMJEDCEx);
            }
            catch (LocalizationException LEx) {
                throw new DataAccessException(2100, (Throwable)LEx);
            }
        }
    }

    @Override
    public Object getRecord(long offset) {
        return this.m_dataMap.get((int)offset);
    }

    protected IDataAccessHelper getHelper() {
        return this.m_helper;
    }

    protected IntObjMap getDataMap() {
        return this.m_dataMap;
    }
}

