/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.binary.index;

import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerMultiLevelIndexKey;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public abstract class AbstractMultiLevelIndexKey
implements MapMarkerMultiLevelIndexKey {
    private int m_levels;
    private MapMarkerIndexKey[] m_keys;

    protected AbstractMultiLevelIndexKey(int levels) {
        this.m_levels = levels;
        this.m_keys = new MapMarkerIndexKey[levels];
    }

    @Override
    public int getLevels() {
        return this.m_levels;
    }

    protected void setKeyAt(int level, MapMarkerIndexKey key) {
        this.m_keys[level] = key;
    }

    @Override
    public MapMarkerIndexKey getKeyAt(int level) {
        return this.m_keys[level];
    }

    public int compareTo(Object that) {
        MapMarkerMultiLevelIndexKey thatKey = (MapMarkerMultiLevelIndexKey)that;
        if (this.m_levels != thatKey.getLevels()) {
            throw new IllegalArgumentException();
        }
        int compare = 0;
        for (int i = 0; compare == 0 && i < this.m_levels; ++i) {
            compare = this.getKeyAt(i).compareTo(thatKey.getKeyAt(i));
        }
        return compare;
    }

    public boolean equals(Object that) {
        return this.compareTo(that) == 0;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        for (int i = 0; i < this.m_levels; ++i) {
            this.m_keys[i].write(out);
        }
    }

    @Override
    public void read(DataInput in) throws IOException {
        for (int i = 0; i < this.m_levels; ++i) {
            this.m_keys[i].read(in);
        }
    }
}

