/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.binary.index;

import com.mapinfo.mapmarker.common.dp.binary.index.BinaryTree;
import com.mapinfo.mapmarker.common.dp.binary.index.DuplicateKeyException;
import com.mapinfo.mapmarker.common.dp.binary.index.TreeItem;

class BinaryTreeNode {
    BinaryTreeNode left;
    BinaryTreeNode right;
    private TreeItem item;

    public BinaryTreeNode(TreeItem item) {
        this.item = item;
        this.left = BinaryTree.z;
        this.right = BinaryTree.z;
    }

    public void insert(BinaryTreeNode node) throws DuplicateKeyException {
        Comparable thisKey = this.getItem().getKey();
        if (thisKey.equals(node.getItem().getKey())) {
            throw new DuplicateKeyException("Key already in tree.");
        }
        if (thisKey.compareTo(node.getItem().getKey()) > 0) {
            if (this.left == BinaryTree.z) {
                this.attachLeft(node);
            } else {
                this.left.insert(node);
            }
        } else if (this.right == BinaryTree.z) {
            this.attachRight(node);
        } else {
            this.right.insert(node);
        }
    }

    void attachLeft(BinaryTreeNode node) {
        this.left = node;
    }

    void attachRight(BinaryTreeNode node) {
        this.right = node;
    }

    public TreeItem getItem() {
        return this.item;
    }

    void dispose() {
        if (this != BinaryTree.z) {
            this.left.dispose();
            this.left = null;
            this.right.dispose();
            this.right = null;
            this.delete();
        }
    }

    void delete() {
        this.item = null;
    }

    BinaryTreeNode getLeft() {
        return this.left;
    }

    BinaryTreeNode getRight() {
        return this.right;
    }
}

