/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.binary.index;

import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexValue;
import com.mapinfo.mapmarker.utils.DataInputUtilities;
import com.mapinfo.mapmarker.utils.LongArray;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class MapMarkerIndexMultiValue
implements MapMarkerIndexValue {
    private short m_count = 0;
    private LongArray m_values = new LongArray();

    public MapMarkerIndexMultiValue() {
    }

    public MapMarkerIndexMultiValue(MapMarkerIndexMultiValue value) {
        this();
        this.combine(value);
    }

    public void combine(MapMarkerIndexMultiValue value) {
        for (int i = 0; i < value.m_count; ++i) {
            this.addOffset(value.getOffsetAt((short)i));
        }
    }

    public short getValueCount() {
        return this.m_count;
    }

    public long getOffsetAt(short index) {
        if (index < 0) {
            return -1L;
        }
        return this.m_values.get(index);
    }

    public void addOffset(long offset) {
        this.m_values.add(offset);
        if (this.m_count == Short.MAX_VALUE) {
            throw new IllegalStateException("ERROR: Too many offsets for value to hold.");
        }
        this.m_count = (short)(this.m_count + 1);
    }

    @Override
    public void read(DataInput in) throws IOException {
        this.m_count = in.readShort();
        if (this.m_count > 0) {
            this.m_values = new LongArray(this.m_count);
            byte[] bytes = DataInputUtilities.readByteArray(in, this.m_count * 8);
            for (int i = 0; i < this.m_count; ++i) {
                this.m_values.add(DataInputUtilities.getLongFromByteArray(i * 8, bytes));
            }
        }
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeShort(this.m_count);
        if (this.m_count > 0) {
            for (int i = 0; i < this.m_count; ++i) {
                out.writeLong(this.m_values.get(i));
            }
        }
    }
}

