/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.binary.index;

import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexKey;
import com.mapinfo.mapmarker.utils.DataInputUtilities;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;

public class MapMarkerIntArraySubIndexKey
implements MapMarkerIndexKey {
    protected int[] m_key;

    public MapMarkerIntArraySubIndexKey() {
        this.m_key = null;
    }

    public MapMarkerIntArraySubIndexKey(int[] key) {
        this.m_key = key;
    }

    public short getLength() {
        if (this.m_key != null) {
            return (short)this.m_key.length;
        }
        return 0;
    }

    public boolean equals(Object that) {
        MapMarkerIntArraySubIndexKey thatKey = (MapMarkerIntArraySubIndexKey)that;
        return Arrays.equals(this.m_key, thatKey.m_key);
    }

    private int compareKeyElements(int[] key1, int[] key2, int elementsToCompare) {
        for (int i = 0; i < elementsToCompare; ++i) {
            if (key1[i] == key2[i]) continue;
            if (key1[i] < key2[i]) {
                return -1;
            }
            return 1;
        }
        return 0;
    }

    public int compareTo(Object o2) {
        MapMarkerIntArraySubIndexKey key2 = (MapMarkerIntArraySubIndexKey)o2;
        if (this.equals(key2)) {
            return 0;
        }
        if (this.m_key.length == key2.m_key.length) {
            return this.compareKeyElements(this.m_key, key2.m_key, this.m_key.length);
        }
        if (this.m_key.length < key2.m_key.length) {
            int keyCompare = this.compareKeyElements(this.m_key, key2.m_key, this.m_key.length);
            if (keyCompare == 0) {
                return -1;
            }
            return keyCompare;
        }
        int keyCompare = this.compareKeyElements(this.m_key, key2.m_key, key2.m_key.length);
        if (keyCompare == 0) {
            return 1;
        }
        return keyCompare;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeShort(this.m_key.length);
        for (int i = 0; i < this.m_key.length; ++i) {
            out.writeInt(this.m_key[i]);
        }
    }

    @Override
    public void read(DataInput in) throws IOException {
        int len = in.readShort();
        this.m_key = new int[len];
        byte[] bytes = DataInputUtilities.readByteArray(in, len * 4);
        for (int i = 0; i < len; ++i) {
            this.m_key[i] = DataInputUtilities.getIntFromByteArray(i * 4, bytes);
        }
    }
}

