/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.binary.index;

import com.mapinfo.mapmarker.common.dp.binary.index.IMapMarkerReadOnlyIndexFile;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexFileMetadata;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexValue;
import com.mapinfo.mapmarker.utils.FileProviderFactory;
import com.mapinfo.mapmarker.utils.SeekableDataInput;
import java.io.IOException;

public abstract class MapMarkerSimpleReadOnlyIndexFile
implements IMapMarkerReadOnlyIndexFile {
    private String m_indexFileName;
    private MapMarkerIndexFileMetadata m_metadata;
    private long m_indexStart;
    private static final long NO_OFFSET = -1L;

    @Override
    public void open(String indexFileName) throws IOException {
        this.m_indexFileName = indexFileName;
        SeekableDataInput file = FileProviderFactory.getFileProvider().get(this.m_indexFileName);
        try {
            file.seek(0L);
            this.m_metadata = this.getMetadataType();
            this.m_metadata.read(file);
            this.m_indexStart = file.getFilePointer();
        }
        finally {
            FileProviderFactory.getFileProvider().release(file);
        }
    }

    @Override
    public void close() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MapMarkerIndexValue search(MapMarkerIndexKey searchKey) throws IOException {
        SeekableDataInput file = FileProviderFactory.getFileProvider().get(this.m_indexFileName);
        MapMarkerIndexValue result = null;
        try {
            result = this.search(file, this.m_indexStart, searchKey);
        }
        finally {
            FileProviderFactory.getFileProvider().release(file);
        }
        return result;
    }

    private MapMarkerIndexValue search(SeekableDataInput file, long searchStart, MapMarkerIndexKey searchKey) throws IOException {
        if (searchStart == -1L) {
            return null;
        }
        file.seek(searchStart);
        MapMarkerIndexKey key = this.getIndexKeyType();
        key.read(file);
        MapMarkerIndexValue value = this.getIndexValueType();
        value.read(file);
        int keyRelation = key.compareTo(searchKey);
        if (keyRelation == 0) {
            return value;
        }
        if (keyRelation > 0) {
            return this.search(file, file.readLong(), searchKey);
        }
        file.skipBytes(8);
        return this.search(file, file.readLong(), searchKey);
    }

    protected MapMarkerIndexFileMetadata getMetadataType() {
        return new MapMarkerIndexFileMetadata();
    }

    protected abstract MapMarkerIndexKey getIndexKeyType();

    protected abstract MapMarkerIndexValue getIndexValueType();
}

