/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.binary.index;

import com.mapinfo.mapmarker.common.dp.binary.index.ISingleThreadedSubIndex;
import com.mapinfo.mapmarker.common.dp.binary.index.ITreeSubIndexFileNode;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.NonTerminalTreeSubIndexFileNode;
import com.mapinfo.mapmarker.common.dp.binary.index.TerminalTreeSubIndexFileNode;
import com.mapinfo.mapmarker.utils.SeekableDataInput;
import java.io.IOException;

public abstract class MapMarkerSingleThreadedTreeSubIndex
implements ISingleThreadedSubIndex {
    ITreeSubIndexFileNode m_root;

    @Override
    public void open(SeekableDataInput input, long start) throws IOException {
        input.seek(start);
        this.m_root = this.getNodeType();
        this.m_root.read(input);
    }

    @Override
    public Object search(MapMarkerIndexKey key, SeekableDataInput input) throws IOException {
        return this.searchTree(this.m_root, key, input);
    }

    protected ITreeSubIndexFileNode getNodeType() {
        if (this.isTerminal()) {
            return new TerminalTreeSubIndexFileNode(this.getIndexKeyType(), this.getIndexValueType());
        }
        return new NonTerminalTreeSubIndexFileNode(this.getIndexKeyType(), this.getIndexValueType());
    }

    protected abstract MapMarkerIndexKey getIndexKeyType();

    protected abstract Object getIndexValueType();

    protected abstract boolean isTerminal();

    private void attachLeft(ITreeSubIndexFileNode node, SeekableDataInput input) throws IOException {
        input.seek(node.getLeftOffset());
        ITreeSubIndexFileNode left = this.getNodeType();
        left.read(input);
        node.attachLeft(left);
    }

    private void attachRight(ITreeSubIndexFileNode node, SeekableDataInput input) throws IOException {
        input.seek(node.getRightOffset());
        ITreeSubIndexFileNode right = this.getNodeType();
        right.read(input);
        node.attachRight(right);
    }

    private Object searchTree(ITreeSubIndexFileNode node, MapMarkerIndexKey key, SeekableDataInput input) throws IOException {
        int keyRelation = node.getKey().compareTo(key);
        if (keyRelation == 0) {
            return node.getValue();
        }
        if (keyRelation > 0) {
            if (node.getLeft() != null) {
                return this.searchTree(node.getLeft(), key, input);
            }
            if (node.getLeftOffset() != -1L) {
                this.attachLeft(node, input);
                return this.searchFile(node.getLeft(), key, input);
            }
            return null;
        }
        if (node.getRight() != null) {
            return this.searchTree(node.getRight(), key, input);
        }
        if (node.getRightOffset() != -1L) {
            this.attachRight(node, input);
            return this.searchFile(node, key, input);
        }
        return null;
    }

    private Object searchFile(ITreeSubIndexFileNode node, MapMarkerIndexKey key, SeekableDataInput input) throws IOException {
        int keyRelation = node.getKey().compareTo(key);
        if (keyRelation == 0) {
            return node.getValue();
        }
        if (keyRelation > 0) {
            if (node.getLeftOffset() != -1L) {
                this.attachLeft(node, input);
                return this.searchFile(node.getLeft(), key, input);
            }
            return null;
        }
        if (node.getRightOffset() != -1L) {
            this.attachRight(node, input);
            return this.searchFile(node.getRight(), key, input);
        }
        return null;
    }
}

