/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.binary.index;

import com.mapinfo.mapmarker.common.dp.binary.index.IMapMarkerIndex;
import com.mapinfo.mapmarker.common.dp.binary.index.ISubIndex;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexValue;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerMultiLevelIndexKey;

public abstract class MultiLevelMapMarkerIndex
implements IMapMarkerIndex {
    private ISubIndex m_firstLevel;
    private int m_levels;

    protected void setFirstLevel(ISubIndex firstLevel) {
        this.m_firstLevel = firstLevel;
    }

    protected void setLevels(int levels) {
        this.m_levels = levels;
    }

    @Override
    public MapMarkerIndexValue search(MapMarkerIndexKey key) {
        MapMarkerMultiLevelIndexKey multiKey = (MapMarkerMultiLevelIndexKey)key;
        if (this.m_firstLevel == null) {
            return null;
        }
        ISubIndex value = (ISubIndex)this.m_firstLevel.search(multiKey.getKeyAt(0));
        if (value == null) {
            return null;
        }
        for (int i = 1; i < this.m_levels - 1; ++i) {
            if ((value = (ISubIndex)value.search(multiKey.getKeyAt(i))) != null) continue;
            return null;
        }
        return (MapMarkerIndexValue)value.search(multiKey.getKeyAt(this.m_levels - 1));
    }
}

