/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.index.spatial.binary;

import com.mapinfo.mapmarker.common.dp.DataAccessRuntimeException;
import com.mapinfo.mapmarker.common.dp.FatalDataAccessException;
import com.mapinfo.mapmarker.common.dp.FatalDataAccessRuntimeException;
import com.mapinfo.mapmarker.common.dp.index.spatial.IRGIndex;
import com.mapinfo.mapmarker.common.dp.index.spatial.IRGIterator;
import com.mapinfo.midev.geometry.Envelope;
import java.io.IOException;
import java.util.Iterator;

class CompositeRGIterator<E>
implements IRGIterator<E> {
    private final Envelope m_searchArea;
    private final Iterator<IRGIndex<E>> m_indexItr;
    private IRGIterator<E> m_currentItr;
    private E m_next;

    public CompositeRGIterator(Envelope searchArea, Iterator<IRGIndex<E>> indexItr) {
        this.m_searchArea = searchArea;
        this.m_indexItr = indexItr;
        this.updateNext();
    }

    @Override
    public boolean hasNext() throws DataAccessRuntimeException {
        return this.m_next != null;
    }

    @Override
    public E next() throws DataAccessRuntimeException {
        E result = this.m_next;
        this.updateNext();
        return result;
    }

    private void updateNext() {
        try {
            this.m_next = null;
            while (true) {
                if (this.m_currentItr == null) {
                    if (this.m_indexItr.hasNext()) {
                        this.m_currentItr = this.m_indexItr.next().search(this.m_searchArea);
                        continue;
                    }
                    break;
                }
                if (this.m_currentItr.hasNext()) {
                    this.m_next = this.m_currentItr.next();
                    break;
                }
                this.m_currentItr.close();
                this.m_currentItr = null;
            }
        }
        catch (IOException e) {
            throw new FatalDataAccessRuntimeException(new FatalDataAccessException(2102, (Throwable)e));
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() throws IOException {
        if (this.m_currentItr != null) {
            this.m_currentItr.close();
        }
    }
}

