/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.index.spatial.binary;

import com.mapinfo.mapmarker.common.dp.index.spatial.binary.ChildInfo;
import com.mapinfo.mapmarker.common.dp.index.spatial.binary.DiskRGHelper;
import com.mapinfo.mapmarker.common.dp.index.spatial.binary.DiskStructureUtils;
import com.mapinfo.mapmarker.common.dp.index.spatial.binary.RootInfo;
import com.mapinfo.midev.geometry.Envelope;
import com.mapinfo.midev.index.rtree.IEnvelopeDecorator;
import com.mapinfo.midev.index.rtree.IRTreeNode;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

class DiskNode
implements IRTreeNode {
    private static final int LEAF_LEVEL = 0;
    private final DiskRGHelper m_helper;
    private int m_position;
    private int m_level;
    private Envelope m_bounds;
    private List m_children;
    private DiskNode m_parent;

    public DiskNode(DiskRGHelper helper) {
        this.m_helper = helper;
        this.m_children = new ArrayList(this.m_helper.getMaxNodeCapacity());
        this.m_position = helper.getDiskOperations().allocateBlock();
        this.m_bounds = new Envelope(DiskStructureUtils.SI);
    }

    public DiskNode(DiskRGHelper helper, int position, Envelope bounds, int level, DiskNode parent) {
        this.m_helper = helper;
        this.m_parent = parent;
        this.m_children = new ArrayList(this.m_helper.getMaxNodeCapacity());
        this.m_position = position;
        this.m_bounds = bounds;
        this.m_level = level;
        this.m_children = this.m_level == 0 ? this.m_helper.getDiskOperations().readLeafBlockGroup(this.m_position) : this.m_helper.getDiskOperations().readIndexBlock(this.m_position);
    }

    public Envelope getBounds() {
        return this.m_bounds;
    }

    public void setBounds(Envelope envelope) {
        this.m_bounds = envelope;
        this.updateBounds();
    }

    public int getLevel() {
        return this.m_level;
    }

    public void setLevel(int newLevel) {
        if (this.isTrueRoot()) {
            this.m_helper.getDiskOperations().updateRootInfo(new RootInfo(this.m_position, this.m_bounds, newLevel));
        }
        this.m_level = newLevel;
    }

    private void updateBounds() {
        if (this.isTrueRoot()) {
            this.m_helper.getDiskOperations().updateRootInfo(new RootInfo(this.m_position, this.m_bounds, this.m_level));
        } else if (this.m_parent != null) {
            int childIdx = Integer.MIN_VALUE;
            for (int i = 0; i < this.m_parent.m_children.size(); ++i) {
                ChildInfo info = (ChildInfo)this.m_parent.m_children.get(i);
                if (info.getPosition() != this.m_position) continue;
                childIdx = i;
                break;
            }
            if (childIdx != Integer.MIN_VALUE) {
                this.m_helper.getDiskOperations().writeIndexChild(this.m_parent.getPosition(), this.m_parent.m_children.size(), childIdx, new ChildInfo(this.m_bounds, this.m_position));
            }
        }
    }

    public boolean isLeaf() {
        return this.m_level == 0;
    }

    public int size() {
        return this.m_children.size();
    }

    public Object getChild(int index) {
        Object child = this.m_children.get(index);
        if (child instanceof ChildInfo) {
            ChildInfo info = (ChildInfo)child;
            return new DiskNode(this.m_helper, info.getPosition(), info.getBounds(), this.getLevel() - 1, this);
        }
        return this.m_children.get(index);
    }

    public void addChild(Object o) {
        if (o instanceof DiskNode) {
            DiskNode child = (DiskNode)o;
            ChildInfo info = new ChildInfo(child.getBounds(), child.getPosition());
            this.m_children.add(info);
            this.m_helper.getDiskOperations().writeIndexChild(this.m_position, this.m_children.size(), this.m_children.size() - 1, info);
        } else {
            this.m_children.add(o);
            this.m_helper.getDiskOperations().addLeafChild(this.m_position, o);
        }
    }

    public void removeChild(int index) {
        throw new UnsupportedOperationException();
    }

    public boolean isRoot() {
        return this.m_parent == null;
    }

    public boolean isTrueRoot() {
        return this.getPosition() == this.m_helper.getRootNode().getPosition();
    }

    public DiskNode getParent() {
        return this.m_parent;
    }

    public void setParent(IRTreeNode irTreeNode) {
        this.m_parent = (DiskNode)irTreeNode;
    }

    public void clear() {
        if (this.m_level == 0) {
            this.m_helper.getDiskOperations().clearLeafBlockGroup(this.m_position);
        } else {
            this.m_helper.getDiskOperations().clearIndexBlock(this.m_position);
        }
        this.clearContents();
    }

    private void clearContents() {
        this.m_children.clear();
        this.m_parent = null;
        this.m_bounds.setEmpty();
        this.m_level = 0;
    }

    public int getPosition() {
        return this.m_position;
    }

    public List getIntersectingChildren(Envelope searchEnvelope, IEnvelopeDecorator dec) {
        if (this.isLeaf()) {
            LinkedList results = new LinkedList();
            for (Object child : this.m_children) {
                if (!dec.getEnvelope(child).intersects(searchEnvelope)) continue;
                results.add(child);
            }
            return results;
        }
        LinkedList<DiskNode> nodes = new LinkedList<DiskNode>();
        for (Object child : this.m_children) {
            ChildInfo info = (ChildInfo)child;
            if (!info.getBounds().intersects(searchEnvelope)) continue;
            nodes.add(new DiskNode(this.m_helper, info.getPosition(), info.getBounds(), this.getLevel() - 1, this));
        }
        return nodes;
    }

    public String toString() {
        return String.valueOf(this.m_position);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DiskNode diskNode = (DiskNode)o;
        return this.m_position == diskNode.m_position;
    }

    public int hashCode() {
        return this.m_position;
    }
}

