/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.index.spatial.binary;

import com.mapinfo.mapmarker.common.dp.DataAccessRuntimeException;
import com.mapinfo.mapmarker.common.dp.FatalDataAccessException;
import com.mapinfo.mapmarker.common.dp.FatalDataAccessRuntimeException;
import com.mapinfo.mapmarker.common.dp.index.spatial.IPersistenceDecorator;
import com.mapinfo.mapmarker.common.dp.index.spatial.IRGIndexBuilder;
import com.mapinfo.mapmarker.common.dp.index.spatial.binary.BlockInfo;
import com.mapinfo.mapmarker.common.dp.index.spatial.binary.DiskRGHelper;
import com.mapinfo.mapmarker.common.dp.index.spatial.binary.DiskRGIndexSorter;
import com.mapinfo.midev.index.rtree.IEnvelopeDecorator;
import com.mapinfo.midev.index.rtree.IRTreeHelper;
import com.mapinfo.midev.index.rtree.RTree;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;

public class DiskRGIndexBuilder<E>
implements IRGIndexBuilder<E> {
    private final File m_file;
    private final BlockInfo m_blockInfo;

    public DiskRGIndexBuilder(File file) {
        this(file, null);
    }

    public DiskRGIndexBuilder(File file, BlockInfo blockInfo) {
        this.m_file = file;
        this.m_blockInfo = blockInfo;
    }

    @Override
    public void buildIndex(Iterator<E> entries, IPersistenceDecorator<E> pDec, IEnvelopeDecorator<E> envDec) throws DataAccessRuntimeException {
        File tempFile = null;
        try {
            tempFile = File.createTempFile("tmpspx_", ".tmp", this.m_file.getParentFile());
            tempFile.delete();
            this.createStandardIndex(entries, pDec, envDec, tempFile);
            this.createSortedIndex(tempFile, this.m_file, pDec);
        }
        catch (IOException e) {
            throw new FatalDataAccessRuntimeException(new FatalDataAccessException(2102, (Throwable)e));
        }
        finally {
            if (tempFile != null && tempFile.exists()) {
                tempFile.delete();
            }
        }
    }

    private void createSortedIndex(File originalIndexFile, File sortedIndexFile, IPersistenceDecorator<E> pDec) {
        DiskRGIndexSorter<E> sorter = new DiskRGIndexSorter<E>(originalIndexFile, sortedIndexFile, pDec);
        sorter.createSortedIndex();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createStandardIndex(Iterator<E> entries, IPersistenceDecorator<E> pDec, IEnvelopeDecorator<E> envDec, File file) {
        try (DiskRGHelper helper = null;){
            helper = this.buildHelper(pDec, file);
            RTree tree = new RTree(envDec, (IRTreeHelper)helper);
            while (entries.hasNext()) {
                E e = entries.next();
                tree.add(e);
            }
        }
    }

    private DiskRGHelper buildHelper(IPersistenceDecorator<E> pDec, File file) {
        if (this.m_blockInfo == null) {
            return new DiskRGHelper(DiskRGHelper.AccessMode.CREATE, file, pDec);
        }
        return new DiskRGHelper(DiskRGHelper.AccessMode.CREATE, file, pDec, this.m_blockInfo);
    }
}

