/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.index.spatial.binary;

import com.mapinfo.mapmarker.common.dp.index.spatial.IPersistenceDecorator;
import com.mapinfo.mapmarker.common.dp.index.spatial.binary.BlockInfo;
import com.mapinfo.mapmarker.common.dp.index.spatial.binary.ChildInfo;
import com.mapinfo.mapmarker.common.dp.index.spatial.binary.DiskStructureUtils;
import com.mapinfo.mapmarker.common.dp.index.spatial.binary.GeneralBlockOperations;
import com.mapinfo.mapmarker.common.dp.index.spatial.binary.IndexBlockOperations;
import com.mapinfo.mapmarker.common.dp.index.spatial.binary.LeafBlockOperations;
import com.mapinfo.mapmarker.common.dp.index.spatial.binary.RootInfo;
import com.mapinfo.mapmarker.utils.IRandomDataInputOutputStream;
import com.mapinfo.midev.geometry.Envelope;
import java.util.List;

class DiskStructureOperations {
    private final IndexBlockOperations m_indexBlockOps;
    private final LeafBlockOperations m_leafBlockOps;
    private GeneralBlockOperations m_blockOps;

    public DiskStructureOperations(BlockInfo blockInfo, IRandomDataInputOutputStream stream, IPersistenceDecorator pDec) {
        this(new GeneralBlockOperations(blockInfo, stream), stream, pDec, true);
    }

    public DiskStructureOperations(IRandomDataInputOutputStream stream, IPersistenceDecorator pDec) {
        this(new GeneralBlockOperations(stream), stream, pDec, false);
    }

    private DiskStructureOperations(GeneralBlockOperations blockOps, IRandomDataInputOutputStream stream, IPersistenceDecorator pDec, boolean initialize) {
        this.m_blockOps = blockOps;
        BlockInfo blockInfo = this.m_blockOps.getBlockInfo();
        this.m_indexBlockOps = new IndexBlockOperations(blockInfo, stream);
        this.m_leafBlockOps = new LeafBlockOperations(blockInfo, stream, pDec);
        if (initialize) {
            int rootPos = this.m_blockOps.allocateBlock();
            this.m_leafBlockOps.initializeBlock(rootPos);
            this.m_blockOps.updateRootInfo(new RootInfo(rootPos, new Envelope(DiskStructureUtils.SI), 0));
        }
    }

    public RootInfo getRootInfo() {
        return this.m_blockOps.getRootInfo();
    }

    public void updateRootInfo(RootInfo info) {
        this.m_blockOps.updateRootInfo(info);
    }

    public List<ChildInfo> readIndexBlock(int pos) {
        return this.m_indexBlockOps.read(pos);
    }

    public void writeIndexChild(int pos, int totalChildCnt, int childIndex, ChildInfo info) {
        this.m_indexBlockOps.writeChild(pos, totalChildCnt, childIndex, info);
    }

    public void clearIndexBlock(int pos) {
        this.m_indexBlockOps.clearBlock(pos);
    }

    public List readLeafBlockGroup(int pos) {
        return this.m_leafBlockOps.read(pos);
    }

    public void addLeafChild(int pos, Object data) {
        this.m_leafBlockOps.addChild(pos, data, this.m_blockOps);
    }

    public void clearLeafBlockGroup(int pos) {
        this.m_leafBlockOps.clear(pos, this.m_blockOps);
    }

    public int allocateBlock() {
        int result = this.m_blockOps.allocateBlock();
        this.m_leafBlockOps.initializeBlock(result);
        return result;
    }

    public BlockInfo getBlockInfo() {
        return this.m_blockOps.getBlockInfo();
    }
}

