/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.index.spatial.binary;

import com.mapinfo.mapmarker.common.dp.FatalDataAccessException;
import com.mapinfo.mapmarker.common.dp.FatalDataAccessRuntimeException;
import com.mapinfo.mapmarker.utils.IRandomDataInputOutputStream;
import com.mapinfo.midev.coordsys.CoordSysConstants;
import com.mapinfo.midev.geometry.Envelope;
import com.mapinfo.midev.geometry.SpatialInfo;
import java.io.IOException;

class DiskStructureUtils {
    public static final SpatialInfo SI = new SpatialInfo(CoordSysConstants.longLatWGS84);
    public static final int NO_PTR = Integer.MIN_VALUE;
    private static final int BYTES_PER_INT = 4;
    private static final int COORD_CONVERSION = (int)Math.pow(10.0, 7.0);

    private DiskStructureUtils() {
    }

    public static void writeBounds(IRandomDataInputOutputStream stream, Envelope bounds) {
        try {
            if (bounds.isEmpty()) {
                stream.writeInt(Integer.MIN_VALUE);
                stream.writeInt(Integer.MIN_VALUE);
                stream.writeInt(Integer.MIN_VALUE);
                stream.writeInt(Integer.MIN_VALUE);
            } else {
                stream.writeInt(DiskStructureUtils.convert(bounds.getLLX()));
                stream.writeInt(DiskStructureUtils.convert(bounds.getLLY()));
                stream.writeInt(DiskStructureUtils.convert(bounds.getURX()));
                stream.writeInt(DiskStructureUtils.convert(bounds.getURY()));
            }
        }
        catch (IOException e) {
            throw new FatalDataAccessRuntimeException(new FatalDataAccessException(2102, (Throwable)e));
        }
    }

    public static Envelope readBounds(IRandomDataInputOutputStream stream) {
        try {
            int value = stream.readInt();
            if (value == Integer.MIN_VALUE) {
                stream.skipBytes(12);
                return new Envelope(SI);
            }
            double llX = DiskStructureUtils.convert(value);
            double llY = DiskStructureUtils.convert(stream.readInt());
            double urX = DiskStructureUtils.convert(stream.readInt());
            double urY = DiskStructureUtils.convert(stream.readInt());
            return new Envelope(llX, llY, urX, urY, SI);
        }
        catch (IOException e) {
            throw new FatalDataAccessRuntimeException(new FatalDataAccessException(2102, (Throwable)e));
        }
    }

    private static int convert(double lonOrLat) {
        return (int)Math.round(lonOrLat * (double)COORD_CONVERSION);
    }

    private static double convert(int lonOrLat) {
        return (double)lonOrLat / (double)COORD_CONVERSION;
    }
}

