/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.index.spatial.binary;

import com.mapinfo.mapmarker.common.dp.FatalDataAccessException;
import com.mapinfo.mapmarker.common.dp.FatalDataAccessRuntimeException;
import com.mapinfo.mapmarker.common.dp.index.spatial.binary.BlockInfo;
import com.mapinfo.mapmarker.common.dp.index.spatial.binary.DiskStructureUtils;
import com.mapinfo.mapmarker.common.dp.index.spatial.binary.HeaderInfo;
import com.mapinfo.mapmarker.common.dp.index.spatial.binary.RootInfo;
import com.mapinfo.mapmarker.utils.IRandomDataInputOutputStream;
import com.mapinfo.midev.geometry.Envelope;
import java.io.IOException;

class GeneralBlockOperations {
    private static final int CURRENT_VER = 3;
    private static final long DEALLOCATED_BLOCK_PTR = 16L;
    private final IRandomDataInputOutputStream m_stream;
    private static final int ROOT_INFO_POS = 20;
    private HeaderInfo m_header;

    public GeneralBlockOperations(BlockInfo blockInfo, IRandomDataInputOutputStream stream) {
        this.m_stream = stream;
        try {
            this.initializeHeader(blockInfo);
        }
        catch (IOException e) {
            throw new FatalDataAccessRuntimeException(new FatalDataAccessException(2102, (Throwable)e));
        }
    }

    public GeneralBlockOperations(IRandomDataInputOutputStream stream) {
        this.m_stream = stream;
        try {
            this.m_header = this.readHeader();
        }
        catch (IOException e) {
            throw new FatalDataAccessRuntimeException(new FatalDataAccessException(2102, (Throwable)e));
        }
        catch (FatalDataAccessException e) {
            throw new FatalDataAccessRuntimeException(e);
        }
    }

    public int allocateBlock() {
        try {
            if (this.getFreeBlockPos() == Integer.MIN_VALUE) {
                return (int)this.m_stream.length();
            }
            int pos = this.getFreeBlockPos();
            this.m_stream.seek(pos);
            int nextDeallocatedBlock = this.m_stream.readInt();
            this.updateFreeBlockPos(nextDeallocatedBlock);
            this.m_stream.seek(pos);
            return pos;
        }
        catch (IOException e) {
            throw new FatalDataAccessRuntimeException(new FatalDataAccessException(2102, (Throwable)e));
        }
    }

    public void deallocateBlock(int pos) {
        try {
            int prevFreeBlockPtr = this.getFreeBlockPos();
            this.updateFreeBlockPos(pos);
            this.m_stream.seek(pos);
            this.m_stream.writeInt(prevFreeBlockPtr);
        }
        catch (IOException e) {
            throw new FatalDataAccessRuntimeException(new FatalDataAccessException(2102, (Throwable)e));
        }
    }

    public void updateRootInfo(RootInfo rootInfo) {
        try {
            this.m_stream.seek(20L);
            this.writeRootInfo(rootInfo);
            this.m_header = new HeaderInfo(this.m_header.getFileVer(), this.m_header.getFreeBlockPos(), rootInfo, this.m_header.getBlockInfo());
        }
        catch (IOException e) {
            throw new FatalDataAccessRuntimeException(new FatalDataAccessException(2102, (Throwable)e));
        }
    }

    public RootInfo getRootInfo() {
        return this.m_header.getRootInfo();
    }

    public int getFreeBlockPos() {
        return this.m_header.getFreeBlockPos();
    }

    public void updateFreeBlockPos(int position) {
        try {
            this.m_stream.seek(16L);
            this.m_stream.writeInt(position);
            this.m_header = new HeaderInfo(this.m_header.getFileVer(), position, this.m_header.getRootInfo(), this.m_header.getBlockInfo());
        }
        catch (IOException e) {
            throw new FatalDataAccessRuntimeException(new FatalDataAccessException(2102, (Throwable)e));
        }
    }

    public BlockInfo getBlockInfo() {
        return this.m_header.getBlockInfo();
    }

    private void initializeHeader(BlockInfo blockInfo) throws IOException {
        this.m_header = new HeaderInfo(3, Integer.MIN_VALUE, new RootInfo(Integer.MIN_VALUE, new Envelope(DiskStructureUtils.SI), 0), blockInfo);
        this.writeHeader(this.m_header);
    }

    private void writeHeader(HeaderInfo header) throws IOException {
        this.m_stream.seek(0L);
        this.m_stream.writeInt(header.getFileVer());
        this.writeBlockInfo(header.getBlockInfo());
        this.m_stream.writeInt(header.getFreeBlockPos());
        this.writeRootInfo(header.getRootInfo());
    }

    private HeaderInfo readHeader() throws IOException, FatalDataAccessException {
        this.m_stream.seek(0L);
        int ver = this.m_stream.readInt();
        if (ver != 3) {
            throw new FatalDataAccessException(2109, new Object[]{new Integer(ver)});
        }
        BlockInfo blockInfo = this.readBlockInfo();
        int firstDeallocatedBlock = this.m_stream.readInt();
        RootInfo rootInfo = this.readRootInfo();
        return new HeaderInfo(ver, firstDeallocatedBlock, rootInfo, blockInfo);
    }

    private void writeBlockInfo(BlockInfo info) throws IOException {
        this.m_stream.writeInt(info.getBlockSize());
        this.m_stream.writeInt(info.getMaxNodeCapacity());
        this.m_stream.writeInt(info.getMinNodeCapacity());
    }

    private BlockInfo readBlockInfo() throws IOException {
        int blockSize = this.m_stream.readInt();
        int maxNodeCap = this.m_stream.readInt();
        int minNodeCap = this.m_stream.readInt();
        return new BlockInfo(blockSize, maxNodeCap, minNodeCap);
    }

    private void writeRootInfo(RootInfo info) throws IOException {
        this.m_stream.writeInt(info.getPosition());
        DiskStructureUtils.writeBounds(this.m_stream, info.getBounds());
        this.m_stream.writeInt(info.getLevel());
    }

    private RootInfo readRootInfo() throws IOException {
        int pos = this.m_stream.readInt();
        Envelope bounds = DiskStructureUtils.readBounds(this.m_stream);
        int level = this.m_stream.readInt();
        return new RootInfo(pos, bounds, level);
    }
}

