/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.index.spatial.binary;

import com.mapinfo.mapmarker.common.dp.FatalDataAccessException;
import com.mapinfo.mapmarker.common.dp.FatalDataAccessRuntimeException;
import com.mapinfo.mapmarker.common.dp.index.spatial.binary.BlockInfo;
import com.mapinfo.mapmarker.common.dp.index.spatial.binary.ChildInfo;
import com.mapinfo.mapmarker.common.dp.index.spatial.binary.DiskStructureUtils;
import com.mapinfo.mapmarker.utils.IRandomDataInputOutputStream;
import com.mapinfo.midev.geometry.Envelope;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

class IndexBlockOperations {
    private static final int BYTES_PER_CHILD = 20;
    private final BlockInfo m_blockInfo;
    private final IRandomDataInputOutputStream m_stream;

    public IndexBlockOperations(BlockInfo blockInfo, IRandomDataInputOutputStream stream) {
        this.m_blockInfo = blockInfo;
        this.m_stream = stream;
    }

    public void clearBlock(int pos) {
        try {
            this.m_stream.seek(pos);
            this.m_stream.writeByte(0);
        }
        catch (IOException e) {
            throw new FatalDataAccessRuntimeException(new FatalDataAccessException(2102, (Throwable)e));
        }
    }

    public List<ChildInfo> read(int pos) {
        try {
            this.m_stream.seek(pos);
            int numChild = this.m_stream.readByte();
            ArrayList<ChildInfo> result = new ArrayList<ChildInfo>(numChild);
            for (int i = 0; i < numChild; ++i) {
                Envelope childBounds = DiskStructureUtils.readBounds(this.m_stream);
                int childPos = this.m_stream.readInt();
                result.add(new ChildInfo(childBounds, childPos));
            }
            return result;
        }
        catch (IOException e) {
            throw new FatalDataAccessRuntimeException(new FatalDataAccessException(2102, (Throwable)e));
        }
    }

    public void writeChild(int pos, int totalChildCnt, int childIndex, ChildInfo info) {
        if (totalChildCnt > this.m_blockInfo.getMaxNodeCapacity() || childIndex > this.m_blockInfo.getMaxNodeCapacity() || totalChildCnt < 1 || childIndex < 0 || childIndex >= totalChildCnt) {
            throw new IllegalArgumentException();
        }
        try {
            this.m_stream.seek(pos);
            this.m_stream.writeByte(totalChildCnt);
            int numBytesToSkip = childIndex * 20;
            this.m_stream.skipBytes(numBytesToSkip);
            DiskStructureUtils.writeBounds(this.m_stream, info.getBounds());
            this.m_stream.writeInt(info.getPosition());
        }
        catch (IOException e) {
            throw new FatalDataAccessRuntimeException(new FatalDataAccessException(2102, (Throwable)e));
        }
    }
}

