/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.core.address;

import com.mapinfo.mapmarker.GeocodeResult;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.IHandler;
import com.mapinfo.mapmarker.MMGeneralGeocoderException;
import com.mapinfo.mapmarker.MMInternalFatalException;
import com.mapinfo.mapmarker.MapMarkerInternalException;
import com.mapinfo.mapmarker.common.ICandidate;
import com.mapinfo.mapmarker.core.address.IAddressGeocoder;
import com.mapinfo.mapmarker.core.address.ICoreAddressGeocoder;
import com.mapinfo.mapmarker.core.geographic.IGeographicGeocoder;
import com.mapinfo.mapmarker.utils.DebugLevel;
import com.mapinfo.mapmarker.utils.MMJLog;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;

public final class CoreAddressGeocoder
implements IAddressGeocoder {
    @Override
    public GeocodeResult geocode(IConstraints preferences, ResourceBundle bundle) throws MMInternalFatalException, MapMarkerInternalException {
        IHandler handler;
        GeocodeResult geocodeResult;
        int debugLevel;
        block11: {
            debugLevel = DebugLevel.getDebugLevel(1);
            geocodeResult = new GeocodeResult();
            handler = preferences.getHandler();
            try {
                if (handler.isParsedIntersection()) {
                    ((ICoreAddressGeocoder)((Object)handler)).getStreetGeocoder().geocodeIntersection(preferences, debugLevel, geocodeResult);
                    break block11;
                }
                if (handler.getParsedAddress() != null) {
                    ((ICoreAddressGeocoder)((Object)handler)).getStreetGeocoder().geocodeSingleAddress(preferences, debugLevel, geocodeResult);
                    break block11;
                }
                if (debugLevel >= 1) {
                    MMJLog.getLog().debug(bundle.getString("err_Parser_no_parse"));
                }
                throw new MMGeneralGeocoderException(2304);
            }
            catch (MapMarkerInternalException e) {
                geocodeResult = new GeocodeResult();
                if (debugLevel < 1) break block11;
                MMJLog.getLog().debug("Exception thrown on geocode", (Throwable)e);
            }
        }
        if (geocodeResult.getNumberCloseCandidates() == 0) {
            List savedMatchedCandidates = handler.getMatchResults();
            GeocodeResult fallbackResult = this.handleFallback(preferences);
            if (fallbackResult == null) {
                handler.setGeocodeResult(geocodeResult);
                handler.setMatchResults(savedMatchedCandidates);
            } else {
                geocodeResult.copy(fallbackResult);
            }
        }
        if (debugLevel >= 1) {
            MMJLog.getLog().debug(geocodeResult.toString());
        }
        if (geocodeResult.getNumberCloseCandidates() > 1) {
            List sortedMatchResults = null;
            sortedMatchResults = geocodeResult.getIntersectionStatus() ? ((ICoreAddressGeocoder)((Object)handler)).getMatcher().filterIntersectionCloseMatches(handler.getParsedAddressArray(), handler.getMatchResults()) : (((ICoreAddressGeocoder)((Object)handler)).getGeoFallbackOccured() ? ((ICoreAddressGeocoder)((Object)handler)).getGeographicCentroidFilter().filterGeographicCloseMatches(handler) : (((ICoreAddressGeocoder)((Object)handler)).getPostalFallbackOccured() ? ((ICoreAddressGeocoder)((Object)handler)).getPostalCentroidFilter().filterPostalCloseMatches(handler) : ((ICoreAddressGeocoder)((Object)handler)).getMatcher().filterCloseMatches(handler.getParsedAddressArray(), handler.getMatchResults())));
            this.countCandidates(sortedMatchResults, geocodeResult);
            this.countCloseMatches(sortedMatchResults, geocodeResult);
            handler.setGeocodeResult(geocodeResult);
            handler.setMatchResults(sortedMatchResults);
            if (debugLevel >= 1) {
                MMJLog.getLog().debug(geocodeResult.toString());
            }
        }
        return geocodeResult;
    }

    private void countCandidates(List candidateList, GeocodeResult geocodeResult) {
        if (candidateList == null || candidateList.isEmpty()) {
            return;
        }
        geocodeResult.setNumberCandidates(candidateList.size());
    }

    private void countCloseMatches(List candidateList, GeocodeResult geocodeResult) {
        int closeMatchCount = 0;
        if (candidateList == null || candidateList.isEmpty()) {
            return;
        }
        Iterator candidateIterator = candidateList.iterator();
        boolean done = false;
        while (candidateIterator.hasNext() && !done) {
            ICandidate candidate = (ICandidate)candidateIterator.next();
            if (candidate.isCloseMatch()) {
                ++closeMatchCount;
                continue;
            }
            done = true;
        }
        geocodeResult.setNumberCloseCandidates(closeMatchCount);
    }

    public GeocodeResult handleFallback(IConstraints constraints) throws MapMarkerInternalException, MMInternalFatalException {
        boolean bDoPostalFallback = constraints.isFallbackToPostal();
        boolean bDoGeoFallback = constraints.isFallbackToGeographic();
        GeocodeResult fallbackResult = null;
        ((ICoreAddressGeocoder)((Object)constraints.getHandler())).setPostalFallbackOccured(false);
        ((ICoreAddressGeocoder)((Object)constraints.getHandler())).setGeoFallbackOccured(false);
        if (!bDoPostalFallback && !bDoGeoFallback) {
            return null;
        }
        if (bDoPostalFallback && bDoGeoFallback) {
            if (((ICoreAddressGeocoder)((Object)constraints.getHandler())).preferPostalFallBack()) {
                fallbackResult = this.tryPostalFallback(constraints);
                if (fallbackResult != null) {
                    return fallbackResult;
                }
                bDoPostalFallback = false;
            } else {
                fallbackResult = this.tryGeoFallback(constraints);
                if (fallbackResult != null) {
                    return fallbackResult;
                }
                bDoGeoFallback = false;
            }
        }
        if (bDoPostalFallback && (fallbackResult = this.tryPostalFallback(constraints)) != null) {
            return fallbackResult;
        }
        if (bDoGeoFallback && (fallbackResult = this.tryGeoFallback(constraints)) != null) {
            return fallbackResult;
        }
        return null;
    }

    private GeocodeResult tryPostalFallback(IConstraints preferences) throws MapMarkerInternalException, MMInternalFatalException {
        GeocodeResult fallbackResult = preferences.getHandler().getPostalGeocoder().geocodePostal(preferences);
        if (fallbackResult.getNumberCloseCandidates() == 0) {
            return null;
        }
        ((ICoreAddressGeocoder)((Object)preferences.getHandler())).setPostalFallbackOccured(true);
        return fallbackResult;
    }

    private GeocodeResult tryGeoFallback(IConstraints constraints) throws MapMarkerInternalException, MMInternalFatalException {
        IGeographicGeocoder geo = constraints.getHandler().getGeographicGeocoder();
        if (geo == null) {
            return null;
        }
        GeocodeResult fallbackResult = geo.geocodeGeographic(constraints);
        if (fallbackResult.getNumberCloseCandidates() == 0) {
            return null;
        }
        ((ICoreAddressGeocoder)((Object)constraints.getHandler())).setGeoFallbackOccured(true);
        return fallbackResult;
    }
}

