/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.core.address;

import com.mapinfo.mapmarker.IHandler;
import com.mapinfo.mapmarker.common.InternalCandidateAddress;
import com.mapinfo.mapmarker.common.InternalIntersectionCandidateAddress;
import com.mapinfo.mapmarker.core.address.ICoreStreetIntersectionGeocoder;
import com.mapinfo.mapmarker.core.address.IStreetIntersectionGeocoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class CoreStreetIntersectionGeocoder
implements IStreetIntersectionGeocoder {
    @Override
    public boolean considerForIntersections(InternalCandidateAddress candidate) {
        return candidate.isCloseMatch();
    }

    @Override
    public List buildIntersectionCandidateList(List firstAddressMatchResults, List secondAddressMatchResults, IHandler handler) {
        if (firstAddressMatchResults == null || firstAddressMatchResults.isEmpty() || secondAddressMatchResults == null || secondAddressMatchResults.isEmpty()) {
            return null;
        }
        ArrayList<InternalIntersectionCandidateAddress> result = null;
        for (InternalCandidateAddress address1 : firstAddressMatchResults) {
            if (!((ICoreStreetIntersectionGeocoder)((Object)handler)).getStreetIntersectionGeocoder().considerForIntersections(address1)) continue;
            for (InternalCandidateAddress address2 : secondAddressMatchResults) {
                InternalIntersectionCandidateAddress intersectionCandidate;
                if (!((ICoreStreetIntersectionGeocoder)((Object)handler)).getStreetIntersectionGeocoder().considerForIntersections(address2) || address1.getStreetOffset() == address2.getStreetOffset() || !(intersectionCandidate = ((ICoreStreetIntersectionGeocoder)((Object)handler)).getIntersectionHelper().makeInternalIntersectionCandidate(address1, address2)).hasIntersection()) continue;
                if (result == null) {
                    result = new ArrayList<InternalIntersectionCandidateAddress>();
                }
                boolean add = true;
                if (!result.isEmpty()) {
                    for (InternalIntersectionCandidateAddress temp : result) {
                        if (!intersectionCandidate.isSameIntersection(temp)) continue;
                        add = false;
                    }
                }
                if (!add) continue;
                result.add(intersectionCandidate);
            }
        }
        if (result != null && result.size() != 0) {
            Collections.sort(result);
            Collections.reverse(result);
        }
        return result;
    }
}

