/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.core.address;

import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.MapMarkerInternalException;
import com.mapinfo.mapmarker.common.DuplicateCandidateComparator;
import com.mapinfo.mapmarker.common.InternalCandidateAddress;
import com.mapinfo.mapmarker.core.address.IStreetSingleAddressGeocoder;
import com.mapinfo.mapmarker.utils.DebugLevel;
import com.mapinfo.mapmarker.utils.MMJLog;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public final class CoreStreetSingleAddressGeocoder
implements IStreetSingleAddressGeocoder {
    @Override
    public boolean generateNewCase(IConstraints constraints) throws MapMarkerInternalException {
        return false;
    }

    @Override
    public void combineCandidateLists(List savedCandidates, List newCandidates) {
        savedCandidates.addAll(newCandidates);
    }

    @Override
    public void removeDuplicateCandidates(List candidates) {
        Collections.sort(candidates);
        Collections.reverse(candidates);
        DuplicateCandidateComparator comparator = new DuplicateCandidateComparator();
        Collections.sort(candidates, comparator);
        Collections.reverse(candidates);
        Iterator duplicateIterator = candidates.iterator();
        InternalCandidateAddress address = null;
        while (true) {
            if (address == null) {
                address = (InternalCandidateAddress)duplicateIterator.next();
            }
            if (!duplicateIterator.hasNext()) {
                Collections.sort(candidates);
                Collections.reverse(candidates);
                return;
            }
            InternalCandidateAddress nextAddress = (InternalCandidateAddress)duplicateIterator.next();
            if (address.getSegmentOffset() == nextAddress.getSegmentOffset()) {
                if (nextAddress.isCloseMatch()) continue;
                if (DebugLevel.getDebugLevel(1) >= 2) {
                    MMJLog.getLog().debug("Removing " + nextAddress.toString());
                    MMJLog.getLog().debug("In favor of: " + address.toString());
                }
                duplicateIterator.remove();
                continue;
            }
            address = nextAddress;
        }
    }
}

