/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.core.browse;

import com.mapinfo.mapmarker.GeocodeResult;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.IHandler;
import com.mapinfo.mapmarker.MMInternalFatalException;
import com.mapinfo.mapmarker.MapMarkerInternalException;
import com.mapinfo.mapmarker.core.IRetrievedCandidates;
import com.mapinfo.mapmarker.core.browse.IBrowseGeocoder;
import com.mapinfo.mapmarker.core.browse.ICoreBrowseGeocoder;
import java.util.List;

public final class CoreBrowseGeocoder
implements IBrowseGeocoder {
    @Override
    public GeocodeResult browse(IConstraints constraints) throws MapMarkerInternalException, MMInternalFatalException {
        GeocodeResult geocodeResult = new GeocodeResult();
        IHandler handler = constraints.getHandler();
        if (handler.getParsedAddressArray() == null) {
            return geocodeResult;
        }
        if (handler.isParsedIntersection()) {
            geocodeResult.setIntersectionStatus(true);
            return geocodeResult;
        }
        IRetrievedCandidates candidates = handler.getDataManager().retrieveBrowseAddresses(handler.getParsedAddress(), constraints);
        List sortedMatchResults = ((ICoreBrowseGeocoder)((Object)handler)).getBrowseFilter().filterAddresses(constraints, handler.getParsedAddress(), candidates.getCandidates());
        geocodeResult.setDataLicensed(candidates.getDataLicensed());
        this.countCandidates(sortedMatchResults, geocodeResult);
        handler.setGeocodeResult(geocodeResult);
        handler.setMatchResults(sortedMatchResults);
        return geocodeResult;
    }

    private void countCandidates(List candidateList, GeocodeResult geocodeResult) {
        if (candidateList == null || candidateList.isEmpty()) {
            return;
        }
        geocodeResult.setNumberCandidates(candidateList.size());
    }
}

