/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.core.matcher;

import com.mapinfo.mapmarker.DictionaryUsagePreference;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.IHandler;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.InternalCandidateAddress;
import com.mapinfo.mapmarker.common.InternalIntersectionCandidateAddress;
import com.mapinfo.mapmarker.common.InternalMatcherConstants;
import com.mapinfo.mapmarker.common.ScoringAddress;
import com.mapinfo.mapmarker.common.filters.ICloseMatchFilterRule;
import com.mapinfo.mapmarker.core.IRetrievedCandidates;
import com.mapinfo.mapmarker.core.matcher.ICoreMatcher;
import com.mapinfo.mapmarker.core.matcher.IMatchPreferences;
import com.mapinfo.mapmarker.core.matcher.IMatcher;
import com.mapinfo.mapmarker.core.matcher.IMatcherHandler;
import com.mapinfo.mapmarker.core.matcher.MatcherException;
import com.mapinfo.mapmarker.utils.DebugLevel;
import com.mapinfo.mapmarker.utils.MMJLog;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public final class CoreMatcher
implements IMatcher {
    public static final String removeMultipleSegments = "MATCHER_REMOVE_MULTIPLE_SEGMENTS";
    private ICloseMatchFilterRule[] m_candidateCloseMatchRules;
    private ICloseMatchFilterRule[] m_intersectionCloseMatchRules;

    public CoreMatcher() {
    }

    public CoreMatcher(ICloseMatchFilterRule[] candidateCloseMatchRules, ICloseMatchFilterRule[] intersectionCloseMatchRules) {
        this.m_candidateCloseMatchRules = candidateCloseMatchRules;
        this.m_intersectionCloseMatchRules = intersectionCloseMatchRules;
    }

    @Override
    public List matchAddress(IConstraints constraints, ScoringAddress scoringAddress, IRetrievedCandidates candidateInfo) throws MatcherException {
        List candidateList = candidateInfo.getCandidates();
        ListIterator iterator = candidateList.listIterator();
        if (!iterator.hasNext()) {
            return null;
        }
        IHandler handler = constraints.getHandler();
        InternalMatcherConstants matchConstants = handler.getMatcherConstants().getStreetMatcherConstants();
        IMatcherHandler matchHandler = ((ICoreMatcher)((Object)handler)).getMatcherHandler();
        matchHandler.computeMaximumAddressScore(scoringAddress, matchConstants);
        matchHandler.computeMaximumAdditionalFieldScore(scoringAddress, matchConstants);
        IMatchPreferences preferences = constraints.getHandler().getMatchConstraintsConverter().repackageGeocodingConstraints(constraints, scoringAddress);
        iterator = candidateList.listIterator();
        if (!iterator.hasNext()) {
            return null;
        }
        while (iterator.hasNext()) {
            InternalCandidateAddress candidate = (InternalCandidateAddress)iterator.next();
            matchHandler.scoreCandidate(candidate, scoringAddress, matchConstants);
            matchHandler.decideCloseMatch(preferences, candidate, matchConstants, scoringAddress);
            if (candidate.isCloseMatch() && candidate.getAddressNumberScore() != 1.0 && Boolean.valueOf(constraints.getCustomString("POBOX_MATCH_IN_PROGRESS", "false")).booleanValue()) {
                candidate.setCloseMatchFlag(false);
            }
            if (constraints.getDictionaryUsage() == DictionaryUsagePreference.PREFER_UD && candidate.fromUserDictionary()) {
                candidate.setDictionaryBonus();
                continue;
            }
            if (constraints.getDictionaryUsage() != DictionaryUsagePreference.PREFER_AD || candidate.fromUserDictionary()) continue;
            candidate.setDictionaryBonus();
        }
        if ((candidateList = matchHandler.removeMultipleSegmentsForStreet(candidateList, constraints)) != null && candidateList.size() != 0) {
            this.orderCandidates(candidateList);
        }
        return candidateList;
    }

    private void orderCandidates(List candidateList) {
        Collections.sort(candidateList);
        Collections.reverse(candidateList);
    }

    public static boolean fieldExists(String str) {
        return str != null && str.length() != 0;
    }

    @Override
    public List filterCloseMatches(Address[] inputAddresses, List candidates) {
        if (this.m_candidateCloseMatchRules == null) {
            return candidates;
        }
        boolean resort = false;
        InternalCandidateAddress bestCandidate = null;
        Iterator bestCandidateIterator = candidates.iterator();
        while (bestCandidateIterator.hasNext()) {
            InternalCandidateAddress otherCandidate = null;
            boolean bGetNextBestCandidate = false;
            boolean bGetNextOtherCandidate = true;
            bestCandidate = (InternalCandidateAddress)bestCandidateIterator.next();
            if (!bestCandidate.isCloseMatch()) continue;
            Iterator otherCandidateIterator = candidates.iterator();
            while (otherCandidateIterator.hasNext() && bGetNextOtherCandidate) {
                otherCandidate = (InternalCandidateAddress)otherCandidateIterator.next();
                if (otherCandidate != bestCandidate) continue;
                bGetNextOtherCandidate = false;
            }
            while (otherCandidateIterator.hasNext() && !bGetNextBestCandidate) {
                otherCandidate = (InternalCandidateAddress)otherCandidateIterator.next();
                if (!otherCandidate.isCloseMatch()) continue;
                boolean bGetNextCandidate = false;
                for (int i = 0; i < this.m_candidateCloseMatchRules.length && !bGetNextCandidate; ++i) {
                    if (this.m_candidateCloseMatchRules[i].demoteOther(inputAddresses, bestCandidate, otherCandidate)) {
                        if (DebugLevel.getDebugLevel(4) >= 2) {
                            MMJLog.getLog().debug("CoreMatcher::filterCloseMatches -- rule: " + this.m_candidateCloseMatchRules[i].getClass().getName() + " caused demotion of other: " + otherCandidate.toString());
                        }
                        resort = true;
                        otherCandidate.setCloseMatchFlag(false);
                        bGetNextCandidate = true;
                        continue;
                    }
                    if (!this.m_candidateCloseMatchRules[i].demoteOther(inputAddresses, otherCandidate, bestCandidate)) continue;
                    if (DebugLevel.getDebugLevel(4) >= 2) {
                        MMJLog.getLog().debug("CoreMatcher::filterCloseMatches -- rule: " + this.m_candidateCloseMatchRules[i].getClass().getName() + " caused demotion of best: " + bestCandidate.toString());
                    }
                    resort = true;
                    bestCandidate.setCloseMatchFlag(false);
                    bGetNextCandidate = true;
                    bGetNextBestCandidate = true;
                }
            }
        }
        if (resort) {
            Collections.reverse(candidates);
            Collections.sort(candidates);
            Collections.reverse(candidates);
        }
        return candidates;
    }

    @Override
    public List filterIntersectionCloseMatches(Address[] inputAddresses, List intersectionCandidates) {
        if (this.m_intersectionCloseMatchRules == null) {
            return intersectionCandidates;
        }
        InternalIntersectionCandidateAddress bestCandidate = null;
        Iterator candidateIterator = intersectionCandidates.iterator();
        bestCandidate = (InternalIntersectionCandidateAddress)candidateIterator.next();
        block0: while (candidateIterator.hasNext()) {
            InternalIntersectionCandidateAddress otherCandidate = (InternalIntersectionCandidateAddress)candidateIterator.next();
            for (int i = 0; i < this.m_intersectionCloseMatchRules.length; ++i) {
                if (!this.m_intersectionCloseMatchRules[i].demoteOther(inputAddresses, bestCandidate, otherCandidate)) continue;
                candidateIterator.remove();
                continue block0;
            }
        }
        return intersectionCandidates;
    }
}

